/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigCounters;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.FileList;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class SortedDataBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 2L;
    private static final InterSedes SEDES = InterSedesFactory.getInterSedesInstance();
    private static final Log log = LogFactory.getLog(SortedDataBag.class);
    private transient Comparator<Tuple> mComp;
    private boolean mReadStarted = false;

    public SortedDataBag(Comparator<Tuple> comp) {
        this.mComp = comp == null ? new DefaultComparator() : comp;
        this.mContents = new ArrayList();
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new SortedDataBagIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long spill() {
        if (this.mContents.size() == 0) {
            return 0L;
        }
        long spilled = 0L;
        Collection collection = this.mContents;
        synchronized (collection) {
            DataOutputStream out = null;
            try {
                out = this.getSpillFile();
            }
            catch (IOException ioe) {
                this.warn("Unable to create tmp file to spill to disk", PigWarning.UNABLE_TO_CREATE_FILE_TO_SPILL, ioe);
                return 0L;
            }
            try {
                if (!this.mReadStarted) {
                    Collections.sort((ArrayList)this.mContents, this.mComp);
                }
                Iterator i = this.mContents.iterator();
                while (i.hasNext()) {
                    SEDES.writeDatum(out, i.next(), (byte)110);
                    if ((++spilled & 0x3FFFL) != 0L) continue;
                    this.reportProgress();
                }
                out.flush();
            }
            catch (IOException ioe) {
                this.mSpillFiles.remove(this.mSpillFiles.size() - 1);
                this.warn("Unable to spill contents to disk", PigWarning.UNABLE_TO_SPILL, ioe);
                long l = 0L;
                return l;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                    }
                }
            }
            this.mContents.clear();
        }
        this.incSpillCount(PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT);
        return spilled;
    }

    private class SortedDataBagIterator
    implements Iterator<Tuple> {
        private Tuple mBuf = null;
        private int mMemoryPtr = 0;
        private PriorityQueue<PQContainer> mMergeQ = null;
        private ArrayList<DataInputStream> mStreams = null;
        private int mCntr = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SortedDataBagIterator() {
            Collection collection = SortedDataBag.this.mContents;
            synchronized (collection) {
                if (!SortedDataBag.this.mReadStarted) {
                    this.preMerge();
                    Collections.sort((ArrayList)SortedDataBag.this.mContents, SortedDataBag.this.mComp);
                    SortedDataBag.this.mReadStarted = true;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.mBuf = this.next();
            return this.mBuf != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tuple next() {
            if ((this.mCntr++ & 0x3FF) == 0) {
                SortedDataBag.this.reportProgress();
            }
            if (this.mBuf != null) {
                Tuple t = this.mBuf;
                this.mBuf = null;
                return t;
            }
            boolean spilled = false;
            Collection collection = SortedDataBag.this.mContents;
            synchronized (collection) {
                if (SortedDataBag.this.mSpillFiles == null || SortedDataBag.this.mSpillFiles.size() == 0) {
                    return this.readFromMemory();
                }
                if (this.mMemoryPtr > 0 && SortedDataBag.this.mContents.size() == 0) {
                    spilled = true;
                }
            }
            if (spilled) {
                DataInputStream in;
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)SortedDataBag.this.mSpillFiles.get(SortedDataBag.this.mSpillFiles.size() - 1))));
                    if (this.mStreams == null) {
                        this.mMergeQ = new PriorityQueue(1);
                        this.mStreams = new ArrayList(1);
                    }
                    this.mStreams.add(in);
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)fnfe);
                    throw new RuntimeException(msg, fnfe);
                }
                for (int i = 0; i < this.mMemoryPtr; ++i) {
                    try {
                        SEDES.readDatum(in);
                        continue;
                    }
                    catch (EOFException eof) {
                        String msg = "Ran out of tuples to read prematurely.";
                        log.fatal((Object)msg, (Throwable)eof);
                        throw new RuntimeException(msg, eof);
                    }
                    catch (IOException ioe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                }
                this.mMemoryPtr = 0;
                this.addToQueue(null, SortedDataBag.this.mSpillFiles.size() - 1);
            }
            return this.readFromPriorityQ();
        }

        @Override
        public void remove() {
        }

        private Tuple readFromPriorityQ() {
            PQContainer c;
            if (this.mMergeQ == null) {
                this.mMergeQ = new PriorityQueue(SortedDataBag.this.mSpillFiles.size() + 1);
                this.mStreams = new ArrayList(SortedDataBag.this.mSpillFiles.size() + 1);
                Iterator i = SortedDataBag.this.mSpillFiles.iterator();
                while (i.hasNext()) {
                    try {
                        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)i.next())));
                        this.mStreams.add(in);
                        this.addToQueue(null, this.mStreams.size() - 1);
                    }
                    catch (FileNotFoundException fnfe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)fnfe);
                        throw new RuntimeException(msg, fnfe);
                    }
                }
                if (SortedDataBag.this.mContents.size() > 0) {
                    this.addToQueue(null, -1);
                }
            }
            if ((c = this.mMergeQ.poll()) == null) {
                return null;
            }
            Tuple t = c.tuple;
            this.addToQueue(c, c.fileNum);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToQueue(PQContainer c, int fileNum) {
            if (c == null) {
                c = new PQContainer();
            }
            c.fileNum = fileNum;
            if (fileNum == -1) {
                Collection collection = SortedDataBag.this.mContents;
                synchronized (collection) {
                    c.tuple = this.readFromMemory();
                }
                if (c.tuple != null) {
                    this.mMergeQ.add(c);
                }
                return;
            }
            DataInputStream in = this.mStreams.get(fileNum);
            if (in != null) {
                try {
                    c.tuple = (Tuple)SEDES.readDatum(in);
                    this.mMergeQ.add(c);
                }
                catch (EOFException eof) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close spill file.", (Throwable)e);
                    }
                    this.mStreams.set(fileNum, null);
                }
                catch (IOException ioe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)ioe);
                    throw new RuntimeException(msg, ioe);
                }
            }
        }

        private Tuple readFromMemory() {
            if (SortedDataBag.this.mContents.size() == 0) {
                return null;
            }
            if (this.mMemoryPtr < SortedDataBag.this.mContents.size()) {
                return (Tuple)((ArrayList)SortedDataBag.this.mContents).get(this.mMemoryPtr++);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preMerge() {
            if (SortedDataBag.this.mSpillFiles == null || SortedDataBag.this.mSpillFiles.size() <= 100) {
                return;
            }
            try {
                LinkedList<File> ll = new LinkedList<File>(SortedDataBag.this.mSpillFiles);
                LinkedList<File> filesToDelete = new LinkedList<File>();
                while (ll.size() > 100) {
                    String msg;
                    ListIterator i = ll.listIterator();
                    this.mStreams = new ArrayList(100);
                    this.mMergeQ = new PriorityQueue(100);
                    for (int j = 0; j < 100; ++j) {
                        try {
                            File f = (File)i.next();
                            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                            this.mStreams.add(in);
                            this.addToQueue(null, this.mStreams.size() - 1);
                            i.remove();
                            filesToDelete.add(f);
                            continue;
                        }
                        catch (FileNotFoundException fnfe) {
                            msg = "Unable to find our spill file.";
                            log.fatal((Object)msg, (Throwable)fnfe);
                            throw new RuntimeException(msg, fnfe);
                        }
                    }
                    DataOutputStream out = null;
                    try {
                        Tuple t;
                        out = SortedDataBag.this.getSpillFile();
                        ll.add((File)SortedDataBag.this.mSpillFiles.get(SortedDataBag.this.mSpillFiles.size() - 1));
                        while ((t = this.readFromPriorityQ()) != null) {
                            t.write(out);
                        }
                        out.flush();
                    }
                    catch (IOException ioe) {
                        msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            SortedDataBag.this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                        }
                    }
                }
                for (File f : filesToDelete) {
                    if (f.delete()) continue;
                    log.warn((Object)("Failed to delete spill file: " + f.getPath()));
                }
                SortedDataBag.this.mSpillFiles.clear();
                SortedDataBag.this.mSpillFiles = new FileList(ll);
            }
            finally {
                this.mStreams = null;
                this.mMergeQ = null;
            }
        }

        private class PQContainer
        implements Comparable<PQContainer> {
            public Tuple tuple;
            public int fileNum;

            private PQContainer() {
            }

            @Override
            public int compareTo(PQContainer other) {
                return SortedDataBag.this.mComp.compare(this.tuple, other.tuple);
            }

            public boolean equals(Object other) {
                if (other instanceof PQContainer) {
                    return this.tuple.equals(((PQContainer)other).tuple);
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }

    private static class DefaultComparator
    implements Comparator<Tuple> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return t1.compareTo(t2);
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return 42;
        }
    }
}

