/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.webjars;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoWebjarsTransformer
implements ArtifactUrlTransformer {
    private Logger logger = LoggerFactory.getLogger(PentahoWebjarsTransformer.class);

    public URL transform(URL url) throws Exception {
        return new URL("pentaho-webjars", null, url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File file) {
        if (file == null || file.getName() == null || !file.getName().endsWith(".jar")) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.endsWith("-requirejs.js")) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

