/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.XmlParserFactoryProducer;

public class XmlDom4JUtils {
    protected static Log logger = LogFactory.getLog(XmlDom4JUtils.class);

    public static Document getDocumentFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            Document document = XmlParserFactoryProducer.getSAXReader(null).read(is);
            return document;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    public static Document getDocumentFromFile(IBasicFile file) throws IOException {
        return file != null ? XmlDom4JUtils.getDocumentFromStream(file.getContents()) : null;
    }

    public static Document getDocumentFromFile(IReadAccess access, String filePath) throws IOException {
        if (access != null && filePath != null && access.fileExists(filePath)) {
            return XmlDom4JUtils.getDocumentFromFile(access.fetchFile(filePath));
        }
        return null;
    }

    public static String getNodeText(String xpath, Node node) {
        return XmlDom4JUtils.getNodeText(xpath, node, null);
    }

    public static String getNodeText(String xpath, Node node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        Node n = node.selectSingleNode(xpath);
        if (n == null) {
            return defaultValue;
        }
        return n.getText();
    }
}

