/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;
import pt.webdetails.cpf.utils.CharsetHelper;

public abstract class FileBasedResourceAccess
implements IRWAccess {
    @Override
    public InputStream getFileInputStream(String path) throws IOException {
        File file = this.getFile(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents(String path) throws IOException {
        InputStream input = null;
        try {
            input = this.getFileInputStream(path);
            String string = IOUtils.toString((InputStream)input, (String)CharsetHelper.getEncoding());
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public boolean fileExists(String path) {
        return this.getFile(path).exists();
    }

    @Override
    public long getLastModified(String path) {
        return this.getFile(path).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(String path, String contents) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getFile(path));
            IOUtils.write((String)contents, (OutputStream)out);
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            return bl;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return true;
    }

    @Override
    public boolean deleteFile(String path) {
        return this.getFile(path).delete();
    }

    @Override
    public boolean copyFile(String pathFrom, String pathTo) {
        try {
            return this.saveFile(pathTo, this.getFileContents(pathFrom));
        }
        catch (IOException e) {
            return false;
        }
    }

    protected abstract File getFile(String var1);

    @Override
    public IBasicFile fetchFile(String path) {
        return this.asBasicFile(this.getFile(path), path);
    }

    @Override
    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter) {
        return this.listFiles(new ArrayList<IBasicFile>(), this.getFile(path), this.asFileFilter(filter), false, false, -1);
    }

    @Override
    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth, boolean includeDirs) {
        return this.listFiles(new ArrayList<IBasicFile>(), this.getFile(path), this.asFileFilter(filter), includeDirs, false, -1);
    }

    @Override
    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth) {
        return this.listFiles(new ArrayList<IBasicFile>(), this.getFile(path), this.asFileFilter(filter), false, false, maxDepth);
    }

    @Override
    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth, boolean includeDirs, boolean showHiddenFilesAndFolders) {
        return this.listFiles(new ArrayList<IBasicFile>(), this.getFile(path), this.asFileFilter(filter), includeDirs, showHiddenFilesAndFolders, maxDepth);
    }

    private List<IBasicFile> listFiles(List<IBasicFile> list, File root, FileFilter filter, boolean includeDirs, boolean showHiddenFilesAndFolders, int depth) {
        if (root.isDirectory()) {
            if (includeDirs && filter.accept(root)) {
                list.add(this.asBasicFile(root, this.relativizePath(root)));
            }
            if (depth != 0) {
                for (File file : root.listFiles()) {
                    this.listFiles(list, file, filter, includeDirs, showHiddenFilesAndFolders, depth - 1);
                }
            }
        } else if (filter.accept(root)) {
            list.add(this.asBasicFile(root, this.relativizePath(root)));
        }
        return list;
    }

    private String relativizePath(File file) {
        return RepositoryHelper.relativizePath(this.getFile(null).getAbsolutePath(), file.getAbsolutePath(), false);
    }

    private FileFilter asFileFilter(final IBasicFileFilter filter) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return filter.accept(FileBasedResourceAccess.this.asBasicFile(file, FileBasedResourceAccess.this.relativizePath(file)));
            }
        };
    }

    protected IBasicFile asBasicFile(final File file, final String relPath) {
        if (file == null) {
            return null;
        }
        return new IBasicFile(){

            @Override
            public InputStream getContents() throws IOException {
                return new FileInputStream(file);
            }

            @Override
            public String getName() {
                return file.getName();
            }

            @Override
            public String getFullPath() {
                return file.getAbsolutePath();
            }

            @Override
            public String getPath() {
                return relPath;
            }

            @Override
            public String getExtension() {
                return RepositoryHelper.getExtension(this.getName());
            }

            @Override
            public boolean isDirectory() {
                return file.isDirectory();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(String path, InputStream in) {
        boolean bl;
        File file = this.getFile(path);
        FileOutputStream fout = null;
        try {
            if (file != null && !file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            fout = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)fout);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
            return bl2;
        }
        IOUtils.closeQuietly((OutputStream)fout);
        return bl;
    }

    @Override
    public boolean createFolder(String path) {
        return this.createFolder(path, false);
    }

    @Override
    public boolean createFolder(String path, boolean isHidden) {
        File folder = this.getFile(path);
        return folder.mkdirs();
    }
}

