/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager;

import java.util.LinkedHashMap;
import java.util.Map;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.StringFilter;
import pt.webdetails.cpf.packager.dependencies.CssMinifiedDependency;
import pt.webdetails.cpf.packager.dependencies.Dependency;
import pt.webdetails.cpf.packager.dependencies.FileDependency;
import pt.webdetails.cpf.packager.dependencies.JsMinifiedDependency;
import pt.webdetails.cpf.packager.dependencies.MapDependency;
import pt.webdetails.cpf.packager.dependencies.PackagedFileDependency;
import pt.webdetails.cpf.packager.dependencies.SnippetDependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IRWAccess;

public class DependenciesPackage {
    private String name;
    private PackageType type;
    protected Map<String, FileDependency> fileDependencies;
    protected PackagedFileDependency packagedDependency;
    protected Object packagingLock = new Object();
    private Map<String, SnippetDependency> rawDependencies;
    protected IContentAccessFactory factory;
    protected IUrlProvider urlProvider;

    public DependenciesPackage(String name, PackageType type, IContentAccessFactory factory, IUrlProvider urlProvider) {
        this.name = name;
        this.fileDependencies = new LinkedHashMap<String, FileDependency>();
        this.rawDependencies = new LinkedHashMap<String, SnippetDependency>();
        this.type = type;
        this.factory = factory;
        this.urlProvider = urlProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerFileDependency(String name, String version, PathOrigin origin, String path) {
        FileDependency newDep = new FileDependency(version, origin, path, this.urlProvider);
        Object object = this.packagingLock;
        synchronized (object) {
            if (this.registerDependency(name, newDep, this.fileDependencies)) {
                this.packagedDependency = null;
                return true;
            }
        }
        return false;
    }

    public boolean registerRawDependency(String name, String version, String contents) {
        SnippetDependency snip = new SnippetDependency(version, contents);
        return this.registerDependency(name, snip, this.rawDependencies);
    }

    protected <T extends Dependency> boolean registerDependency(String name, T dependency, Map<String, T> registry) {
        Dependency dep = (Dependency)registry.get(name);
        if (dep == null || dep.isOlderVersionThan(dependency)) {
            registry.put(name, dependency);
            return true;
        }
        return false;
    }

    public String getDependencies(StringFilter format, boolean isPackaged) {
        return isPackaged ? this.getPackagedDependency(format, null) : this.getUnpackagedDependencies(format, null);
    }

    public String getRawDependencies(boolean isPackaged) {
        StringBuilder sb = new StringBuilder();
        for (SnippetDependency dep : this.rawDependencies.values()) {
            sb.append(dep.getContents());
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getDependencies(boolean isPackaged) {
        return this.getDependencies(DependenciesPackage.getDefaultStringFilter(this.type), isPackaged);
    }

    public String getName() {
        return this.name;
    }

    public String getDependencies(boolean isPackaged, IDependencyInclusionFilter filter) {
        return this.getDependencies(DependenciesPackage.getDefaultStringFilter(this.type), isPackaged, filter);
    }

    public String getDependencies(StringFilter format, boolean isPackaged, IDependencyInclusionFilter filter) {
        return isPackaged ? this.getPackagedDependency(format, filter) : this.getUnpackagedDependencies(format, filter);
    }

    public String getUnpackagedDependencies(StringFilter format, IDependencyInclusionFilter filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (filter != null) {
            for (FileDependency fileDependency : this.fileDependencies.values()) {
                if (!filter.include(fileDependency)) continue;
                sb.append(format.filter(fileDependency.getDependencyInclude()));
            }
        } else {
            for (Dependency dependency : this.fileDependencies.values()) {
                sb.append(format.filter(dependency.getDependencyInclude()));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPackagedDependency(StringFilter format, IDependencyInclusionFilter filter) {
        boolean isMap = this.type.equals((Object)PackageType.MAP);
        if (filter != null) {
            LinkedHashMap<String, FileDependency> customDependencies = new LinkedHashMap<String, FileDependency>();
            for (FileDependency dep : this.fileDependencies.values()) {
                if (!filter.include(dep)) continue;
                customDependencies.put(dep.getDependencyInclude(), dep);
            }
            String packagedPath = isMap ? this.name : this.name + "." + this.type.toString().toLowerCase();
            String baseDir = this.type.toString().toLowerCase();
            IRWAccess writer = this.factory.getPluginSystemWriter(baseDir);
            StaticSystemOrigin origin = new StaticSystemOrigin(baseDir);
            switch (this.type) {
                case CSS: {
                    return format.filter(new CssMinifiedDependency(origin, packagedPath, writer, customDependencies.values(), this.urlProvider).getDependencyInclude());
                }
                case JS: {
                    return format.filter(new JsMinifiedDependency(origin, packagedPath, writer, customDependencies.values(), this.urlProvider).getDependencyInclude());
                }
                case MAP: {
                    return format.filter(new MapDependency(origin, packagedPath, writer, customDependencies.values(), this.urlProvider).getDependencyInclude());
                }
            }
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a recognized type: " + (Object)((Object)this.type));
        }
        Object object = this.packagingLock;
        synchronized (object) {
            if (this.packagedDependency == null) {
                String packagedPath = isMap ? this.name : this.name + "." + this.type.toString().toLowerCase();
                String baseDir = isMap ? "css" : this.type.toString().toLowerCase();
                IRWAccess writer = this.factory.getPluginSystemWriter(baseDir);
                StaticSystemOrigin origin = new StaticSystemOrigin(baseDir);
                switch (this.type) {
                    case CSS: {
                        this.packagedDependency = new CssMinifiedDependency(origin, packagedPath, writer, this.fileDependencies.values(), this.urlProvider);
                        break;
                    }
                    case JS: {
                        this.packagedDependency = new JsMinifiedDependency(origin, packagedPath, writer, this.fileDependencies.values(), this.urlProvider);
                        break;
                    }
                    case MAP: {
                        this.packagedDependency = new MapDependency(origin, this.name, writer, this.fileDependencies.values(), this.urlProvider);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a recognized type: " + (Object)((Object)this.type));
                    }
                }
            }
            return format.filter(this.packagedDependency.getDependencyInclude());
        }
    }

    public PackageType getType() {
        return this.type;
    }

    public StringFilter getDefaultFilter() {
        return DependenciesPackage.getDefaultStringFilter(this.type);
    }

    private static StringFilter getDefaultStringFilter(PackageType type) {
        switch (type) {
            case CSS: {
                return new StringFilter(){

                    @Override
                    public String filter(String input) {
                        return this.filter(input, "");
                    }

                    @Override
                    public String filter(String input, String baseUrl) {
                        return String.format("\t\t<link href=\"%s%s\" rel=\"stylesheet\" type=\"text/css\" />\n", baseUrl, baseUrl.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
                    }
                };
            }
            case JS: {
                return new StringFilter(){

                    @Override
                    public String filter(String input) {
                        return this.filter(input, "");
                    }

                    @Override
                    public String filter(String input, String baseUrl) {
                        return String.format("\t\t<script language=\"javascript\" type=\"text/javascript\" src=\"%s%s\"></script>\n", baseUrl, baseUrl.endsWith("/") && input.startsWith("/") ? input.replaceFirst("/", "") : input);
                    }
                };
            }
            case MAP: {
                return new StringFilter(){

                    @Override
                    public String filter(String input) {
                        return "";
                    }

                    @Override
                    public String filter(String input, String absRoot) {
                        return "";
                    }
                };
            }
        }
        return new StringFilter(){

            @Override
            public String filter(String input) {
                return this.filter(input, "");
            }

            @Override
            public String filter(String input, String baseUrl) {
                return baseUrl + input + "\n";
            }
        };
    }

    public static interface IDependencyInclusionFilter {
        public boolean include(Dependency var1);
    }

    public static enum PackageType {
        CSS,
        JS,
        MAP;

    }

    public static enum PackagingMode {
        MINIFY,
        CONCATENATE;

    }
}

