/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.log.HapiLogFactory;

public class SPD
extends AbstractType
implements Composite {
    private Type[] data;

    public SPD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 337);
        this.data[3] = new DT(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getSpecialtyName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSpd1_SpecialtyName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getGoverningBoard() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSpd2_GoverningBoard() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getEligibleOrCertified() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getSpd3_EligibleOrCertified() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getDateOfCertification() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getSpd4_DateOfCertification() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

