/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3n.vfs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.pentaho.s3n.vfs.S3NFileNameParser;
import org.pentaho.s3n.vfs.S3NFileSystem;

public class S3NFileProvider
extends AbstractOriginatingFileProvider {
    public static final String SCHEME = "s3n";
    public static final String ATTR_USER_INFO = "UI";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.RANDOM_ACCESS_READ));

    public S3NFileProvider() {
        this.setFileNameParser(S3NFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new S3NFileSystem(name, fileSystemOptions);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

