/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveMultiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveGBOpConvUtil;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveOpConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveOpConverter.class);
    private final SemanticAnalyzer semanticAnalyzer;
    private final HiveConf hiveConf;
    private final UnparseTranslator unparseTranslator;
    private final Map<String, TableScanOperator> topOps;
    private int uniqueCounter;

    public HiveOpConverter(SemanticAnalyzer semanticAnalyzer, HiveConf hiveConf, UnparseTranslator unparseTranslator, Map<String, TableScanOperator> topOps) {
        this.semanticAnalyzer = semanticAnalyzer;
        this.hiveConf = hiveConf;
        this.unparseTranslator = unparseTranslator;
        this.topOps = topOps;
        this.uniqueCounter = 0;
    }

    public Operator convert(RelNode root) throws SemanticException {
        OpAttr opAf = this.dispatch(root);
        return (Operator)opAf.inputs.get(0);
    }

    OpAttr dispatch(RelNode rn) throws SemanticException {
        if (rn instanceof HiveTableScan) {
            return this.visit((HiveTableScan)rn);
        }
        if (rn instanceof HiveProject) {
            return this.visit((HiveProject)rn);
        }
        if (rn instanceof HiveMultiJoin) {
            return this.visit((HiveMultiJoin)rn);
        }
        if (rn instanceof HiveJoin) {
            return this.visit((HiveJoin)rn);
        }
        if (rn instanceof HiveSemiJoin) {
            HiveSemiJoin sj = (HiveSemiJoin)rn;
            HiveJoin hj = HiveJoin.getJoin(sj.getCluster(), sj.getLeft(), sj.getRight(), sj.getCondition(), sj.getJoinType(), true);
            return this.visit(hj);
        }
        if (rn instanceof HiveFilter) {
            return this.visit((HiveFilter)rn);
        }
        if (rn instanceof HiveSortLimit) {
            return this.visit((HiveSortLimit)rn);
        }
        if (rn instanceof HiveUnion) {
            return this.visit((HiveUnion)rn);
        }
        if (rn instanceof HiveSortExchange) {
            return this.visit((HiveSortExchange)rn);
        }
        if (rn instanceof HiveAggregate) {
            return this.visit((HiveAggregate)rn);
        }
        LOG.error(rn.getClass().getCanonicalName() + "operator translation not supported yet in return path.");
        return null;
    }

    OpAttr visit(HiveTableScan scanRel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + scanRel.getId() + ":" + scanRel.getRelTypeName() + " with row type: [" + scanRel.getRowType() + "]");
        }
        RelOptHiveTable ht = (RelOptHiveTable)scanRel.getTable();
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
        ArrayList<Integer> neededColumnIDs = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        HashSet<Integer> vcolsInCalcite = new HashSet<Integer>();
        ArrayList<String> partColNames = new ArrayList<String>();
        ImmutableMap<Integer, VirtualColumn> VColsMap = HiveCalciteUtil.getVColsMap(ht.getVirtualCols(), ht.getNoOfNonVirtualCols());
        Map<Integer, ColumnInfo> posToPartColInfo = ht.getPartColInfoMap();
        Map<Integer, ColumnInfo> posToNonPartColInfo = ht.getNonPartColInfoMap();
        List<Integer> neededColIndxsFrmReloptHT = scanRel.getNeededColIndxsFrmReloptHT();
        List scanColNames = scanRel.getRowType().getFieldNames();
        String tableAlias = scanRel.getConcatQbIDAlias();
        for (int index = 0; index < scanRel.getRowType().getFieldList().size(); ++index) {
            ColumnInfo colInfo;
            String colName = (String)scanColNames.get(index);
            if (VColsMap.containsKey(index)) {
                VirtualColumn vc = (VirtualColumn)VColsMap.get(index);
                virtualCols.add(vc);
                colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                vcolsInCalcite.add(index);
            } else if (posToPartColInfo.containsKey(index)) {
                partColNames.add(colName);
                colInfo = posToPartColInfo.get(index);
                vcolsInCalcite.add(index);
            } else {
                colInfo = posToNonPartColInfo.get(index);
            }
            colInfos.add(colInfo);
            if (!neededColIndxsFrmReloptHT.contains(index)) continue;
            neededColumnIDs.add(index);
            neededColumnNames.add(colName);
        }
        TableScanDesc tsd = new TableScanDesc(tableAlias, virtualCols, ht.getHiveTableMD());
        tsd.setPartColumns(partColNames);
        tsd.setNeededColumnIDs(neededColumnIDs);
        tsd.setNeededColumns(neededColumnNames);
        TableScanOperator ts = (TableScanOperator)OperatorFactory.get(this.semanticAnalyzer.getOpContext(), tsd, new RowSchema(colInfos));
        this.topOps.put(tableAlias, ts);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + ts + " with row schema: [" + ts.getSchema() + "]");
        }
        return new OpAttr(tableAlias, vcolsInCalcite, ts);
    }

    OpAttr visit(HiveProject projectRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(projectRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + projectRel.getId() + ":" + projectRel.getRelTypeName() + " with row type: [" + projectRel.getRowType() + "]");
        }
        WindowingSpec windowingSpec = new WindowingSpec();
        ArrayList<String> exprNames = new ArrayList<String>(projectRel.getRowType().getFieldNames());
        ArrayList<ExprNodeDesc> exprCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int pos = 0; pos < projectRel.getChildExps().size(); ++pos) {
            ExprNodeConverter converter = new ExprNodeConverter(inputOpAf.tabAlias, (String)projectRel.getRowType().getFieldNames().get(pos), projectRel.getInput().getRowType(), projectRel.getRowType(), (Set<Integer>)inputOpAf.vcolsInCalcite, projectRel.getCluster().getTypeFactory(), true);
            ExprNodeDesc exprCol = (ExprNodeDesc)((RexNode)projectRel.getChildExps().get(pos)).accept((RexVisitor)converter);
            colExprMap.put((String)exprNames.get(pos), exprCol);
            exprCols.add(exprCol);
            if (converter.getWindowFunctionSpec() == null) continue;
            for (WindowingSpec.WindowFunctionSpec wfs : converter.getWindowFunctionSpec()) {
                windowingSpec.addWindowFunction(wfs);
            }
        }
        if (windowingSpec.getWindowExpressions() != null && !windowingSpec.getWindowExpressions().isEmpty()) {
            inputOpAf = this.genPTF(inputOpAf, windowingSpec);
        }
        SelectDesc sd = new SelectDesc(exprCols, exprNames);
        Pair<ArrayList<ColumnInfo>, Set<Integer>> colInfoVColPair = HiveOpConverter.createColInfos(projectRel.getChildExps(), exprCols, exprNames, inputOpAf);
        SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(sd, new RowSchema((ArrayList)colInfoVColPair.getKey()), (Operator)inputOpAf.inputs.get(0), new Operator[0]);
        selOp.setColumnExprMap(colExprMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + selOp + " with row schema: [" + selOp.getSchema() + "]");
        }
        return new OpAttr(inputOpAf.tabAlias, (Set)colInfoVColPair.getValue(), selOp);
    }

    OpAttr visit(HiveMultiJoin joinRel) throws SemanticException {
        return this.translateJoin((RelNode)joinRel);
    }

    OpAttr visit(HiveJoin joinRel) throws SemanticException {
        return this.translateJoin(joinRel);
    }

    private String getHiveDerivedTableAlias() {
        return "$hdt$_" + this.uniqueCounter++;
    }

    private OpAttr translateJoin(RelNode joinRel) throws SemanticException {
        int i;
        String[] baseSrc = new String[joinRel.getInputs().size()];
        String tabAlias = this.getHiveDerivedTableAlias();
        OpAttr[] inputs = new OpAttr[joinRel.getInputs().size()];
        ArrayList children = new ArrayList(joinRel.getInputs().size());
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            inputs[i2] = this.dispatch(joinRel.getInput(i2));
            children.add((Operator<?>)inputs[i2].inputs.get(0));
            baseSrc[i2] = inputs[i2].tabAlias;
        }
        for (int tag = 0; tag < children.size(); ++tag) {
            ReduceSinkOperator reduceSinkOp = (ReduceSinkOperator)children.get(tag);
            ((ReduceSinkDesc)reduceSinkOp.getConf()).setTag(tag);
        }
        HashSet<Integer> newVcolsInCalcite = new HashSet<Integer>();
        newVcolsInCalcite.addAll((Collection<Integer>)inputs[0].vcolsInCalcite);
        if (joinRel instanceof HiveMultiJoin || HiveOpConverter.extractJoinType((HiveJoin)joinRel) != JoinType.LEFTSEMI) {
            int shift = ((Operator)inputs[0].inputs.get(0)).getSchema().getSignature().size();
            for (i = 1; i < inputs.length; ++i) {
                newVcolsInCalcite.addAll((Collection<Integer>)HiveCalciteUtil.shiftVColsSet(inputs[i].vcolsInCalcite, shift));
                shift += ((Operator)inputs[i].inputs.get(0)).getSchema().getSignature().size();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + joinRel.getId() + ":" + joinRel.getRelTypeName() + " with row type: [" + joinRel.getRowType() + "]");
        }
        ExprNodeDesc[][] joinExpressions = new ExprNodeDesc[inputs.length][];
        for (i = 0; i < inputs.length; ++i) {
            joinExpressions[i] = ((HiveSortExchange)joinRel.getInput(i)).getJoinExpressions();
        }
        ImmutableList joinFilters = joinRel instanceof HiveJoin ? ImmutableList.of((Object)((HiveJoin)joinRel).getJoinFilter()) : ((HiveMultiJoin)joinRel).getJoinFilters();
        ArrayList filterExpressions = Lists.newArrayList();
        for (int i3 = 0; i3 < joinFilters.size(); ++i3) {
            ArrayList<ExprNodeDesc> filterExpressionsForInput = new ArrayList<ExprNodeDesc>();
            if (joinFilters.get(i3) != null) {
                for (RexNode conj : RelOptUtil.conjunctions((RexNode)((RexNode)joinFilters.get(i3)))) {
                    ExprNodeDesc expr = HiveOpConverter.convertToExprNode(conj, joinRel, null, newVcolsInCalcite);
                    filterExpressionsForInput.add(expr);
                }
            }
            filterExpressions.add(filterExpressionsForInput);
        }
        JoinOperator joinOp = HiveOpConverter.genJoin(joinRel, joinExpressions, filterExpressions, children, baseSrc, tabAlias);
        return new OpAttr(tabAlias, newVcolsInCalcite, joinOp);
    }

    OpAttr visit(HiveAggregate aggRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(aggRel.getInput());
        return HiveGBOpConvUtil.translateGB(inputOpAf, aggRel, this.hiveConf);
    }

    OpAttr visit(HiveSortLimit sortRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(sortRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " with row type: [" + sortRel.getRowType() + "]");
            if (sortRel.getCollation() == RelCollations.EMPTY) {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of limit");
            } else if (sortRel.fetch == null) {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort");
            } else {
                LOG.debug("Operator rel#" + sortRel.getId() + ":" + sortRel.getRelTypeName() + " consists of sort+limit");
            }
        }
        Operator inputOp = (Operator)inputOpAf.inputs.get(0);
        SelectOperator resultOp = (SelectOperator)inputOpAf.inputs.get(0);
        if (sortRel.getCollation() != RelCollations.EMPTY) {
            String error;
            if (sortRel.fetch == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)this.hiveConf)) != null) {
                throw new SemanticException(error);
            }
            ImmutableBitSet.Builder sortColsPosBuilder = ImmutableBitSet.builder();
            ImmutableBitSet.Builder sortOutputColsPosBuilder = ImmutableBitSet.builder();
            Map<Integer, RexNode> obRefToCallMap = sortRel.getInputRefToCallMap();
            ArrayList<ExprNodeColumnDesc> sortCols = new ArrayList<ExprNodeColumnDesc>();
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            for (RelFieldCollation sortInfo : sortRel.getCollation().getFieldCollations()) {
                int sortColumnPos = sortInfo.getFieldIndex();
                ColumnInfo columnInfo = new ColumnInfo(inputOp.getSchema().getSignature().get(sortColumnPos));
                ExprNodeColumnDesc sortColumn = new ExprNodeColumnDesc(columnInfo.getType(), columnInfo.getInternalName(), columnInfo.getTabAlias(), columnInfo.getIsVirtualCol());
                sortCols.add(sortColumn);
                if (sortInfo.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                    order.append("-");
                } else {
                    order.append("+");
                }
                if (sortInfo.nullDirection == RelFieldCollation.NullDirection.FIRST) {
                    nullOrder.append("a");
                } else if (sortInfo.nullDirection == RelFieldCollation.NullDirection.LAST) {
                    nullOrder.append("z");
                } else {
                    nullOrder.append(sortInfo.getDirection() == RelFieldCollation.Direction.DESCENDING ? "z" : "a");
                }
                if (obRefToCallMap == null) continue;
                RexNode obExpr = obRefToCallMap.get(sortColumnPos);
                sortColsPosBuilder.set(sortColumnPos);
                if (obExpr != null) continue;
                sortOutputColsPosBuilder.set(sortColumnPos);
            }
            int numReducers = 1;
            ArrayList<String> keepColumns = new ArrayList<String>();
            ImmutableBitSet sortColsPos = sortColsPosBuilder.build();
            ImmutableBitSet sortOutputColsPos = sortOutputColsPosBuilder.build();
            ArrayList<ColumnInfo> inputSchema = inputOp.getSchema().getSignature();
            for (int pos = 0; pos < inputSchema.size(); ++pos) {
                if ((!sortColsPos.get(pos) || !sortOutputColsPos.get(pos)) && (sortColsPos.get(pos) || sortOutputColsPos.get(pos))) continue;
                keepColumns.add(inputSchema.get(pos).getInternalName());
            }
            resultOp = HiveOpConverter.genReduceSinkAndBacktrackSelect(resultOp, sortCols.toArray(new ExprNodeDesc[sortCols.size()]), 0, new ArrayList<ExprNodeDesc>(), order.toString(), nullOrder.toString(), numReducers, AcidUtils.Operation.NOT_ACID, this.hiveConf, keepColumns);
        }
        if (sortRel.fetch != null) {
            int limit = RexLiteral.intValue((RexNode)sortRel.fetch);
            LimitDesc limitDesc = new LimitDesc(limit);
            if (this.semanticAnalyzer != null && this.semanticAnalyzer.getQB() != null && this.semanticAnalyzer.getQB().getParseInfo() != null) {
                this.semanticAnalyzer.getQB().getParseInfo().setOuterQueryLimit(limit);
            }
            ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos(resultOp);
            resultOp = OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(cinfoLst), (Operator)resultOp, new Operator[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated " + resultOp + " with row schema: [" + resultOp.getSchema() + "]");
            }
        }
        return inputOpAf.clone(new Operator[]{resultOp});
    }

    OpAttr visit(HiveFilter filterRel) throws SemanticException {
        OpAttr inputOpAf = this.dispatch(filterRel.getInput());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + filterRel.getId() + ":" + filterRel.getRelTypeName() + " with row type: [" + filterRel.getRowType() + "]");
        }
        ExprNodeDesc filCondExpr = (ExprNodeDesc)filterRel.getCondition().accept((RexVisitor)new ExprNodeConverter(inputOpAf.tabAlias, filterRel.getInput().getRowType(), (Set<Integer>)inputOpAf.vcolsInCalcite, filterRel.getCluster().getTypeFactory(), true));
        FilterDesc filDesc = new FilterDesc(filCondExpr, false);
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos((Operator)inputOpAf.inputs.get(0));
        FilterOperator filOp = (FilterOperator)OperatorFactory.getAndMakeChild(filDesc, new RowSchema(cinfoLst), (Operator)inputOpAf.inputs.get(0), new Operator[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + filOp + " with row schema: [" + filOp.getSchema() + "]");
        }
        return inputOpAf.clone(new Operator[]{filOp});
    }

    private List<RelNode> extractRelNodeFromUnion(HiveUnion unionRel) {
        ArrayList<RelNode> ret = new ArrayList<RelNode>();
        for (RelNode input : unionRel.getInputs()) {
            if (input instanceof HiveUnion) {
                ret.addAll(this.extractRelNodeFromUnion((HiveUnion)input));
                continue;
            }
            ret.add(input);
        }
        return ret;
    }

    OpAttr visit(HiveUnion unionRel) throws SemanticException {
        List<RelNode> inputsList = this.extractRelNodeFromUnion(unionRel);
        OpAttr[] inputs = new OpAttr[inputsList.size()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.dispatch(inputsList.get(i));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + unionRel.getId() + ":" + unionRel.getRelTypeName() + " with row type: [" + unionRel.getRowType() + "]");
        }
        UnionDesc unionDesc = new UnionDesc();
        unionDesc.setNumInputs(inputs.length);
        String tableAlias = this.getHiveDerivedTableAlias();
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfos((Operator)inputs[0].inputs.get(0), tableAlias);
        Operator[] children = new Operator[inputs.length];
        for (int i = 0; i < children.length; ++i) {
            if (i == 0) {
                children[i] = (Operator)inputs[i].inputs.get(0);
                continue;
            }
            Operator op = (Operator)inputs[i].inputs.get(0);
            children[i] = this.genInputSelectForUnion(op, cinfoLst);
        }
        Operator<UnionDesc> unionOp = OperatorFactory.getAndMakeChild(this.semanticAnalyzer.getOpContext(), unionDesc, new RowSchema(cinfoLst), children);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + unionOp + " with row schema: [" + unionOp.getSchema() + "]");
        }
        return new OpAttr(tableAlias, (Set<Integer>)inputs[0].vcolsInCalcite, unionOp);
    }

    OpAttr visit(HiveSortExchange exchangeRel) throws SemanticException {
        RelDistribution distribution;
        OpAttr inputOpAf = this.dispatch(exchangeRel.getInput());
        String tabAlias = inputOpAf.tabAlias;
        if (tabAlias == null || tabAlias.length() == 0) {
            tabAlias = this.getHiveDerivedTableAlias();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + exchangeRel.getId() + ":" + exchangeRel.getRelTypeName() + " with row type: [" + exchangeRel.getRowType() + "]");
        }
        if ((distribution = exchangeRel.getDistribution()).getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            throw new SemanticException("Only hash distribution supported for LogicalExchange");
        }
        ExprNodeDesc[] expressions = new ExprNodeDesc[exchangeRel.getJoinKeys().size()];
        for (int index = 0; index < exchangeRel.getJoinKeys().size(); ++index) {
            expressions[index] = HiveOpConverter.convertToExprNode((RexNode)exchangeRel.getJoinKeys().get(index), exchangeRel.getInput(), inputOpAf.tabAlias, inputOpAf);
        }
        exchangeRel.setJoinExpressions(expressions);
        ReduceSinkOperator rsOp = HiveOpConverter.genReduceSink((Operator)inputOpAf.inputs.get(0), tabAlias, expressions, -1, -1, AcidUtils.Operation.NOT_ACID, this.hiveConf);
        return new OpAttr(tabAlias, (Set<Integer>)inputOpAf.vcolsInCalcite, rsOp);
    }

    private OpAttr genPTF(OpAttr inputOpAf, WindowingSpec wSpec) throws SemanticException {
        Operator<PTFDesc> input = (Operator<PTFDesc>)inputOpAf.inputs.get(0);
        wSpec.validateAndMakeEffective();
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = new RowResolver();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            rr.put(inputOpAf.tabAlias, ci.getInternalName(), ci);
        }
        while (groups.hasNext()) {
            wSpec = groups.next(this.hiveConf, this.semanticAnalyzer, this.unparseTranslator, rr);
            ArrayList<ExprNodeDesc> keyCols = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
            StringBuilder order = new StringBuilder();
            StringBuilder nullOrder = new StringBuilder();
            for (PTFInvocationSpec.PartitionExpression partCol : wSpec.getQueryPartitionSpec().getExpressions()) {
                ExprNodeDesc partExpr = this.semanticAnalyzer.genExprNodeDesc(partCol.getExpression(), rr);
                if (ExprNodeDescUtils.indexOf(partExpr, partCols) >= 0) continue;
                keyCols.add(partExpr);
                partCols.add(partExpr);
                order.append('+');
                nullOrder.append('a');
            }
            if (wSpec.getQueryOrderSpec() != null) {
                for (PTFInvocationSpec.OrderExpression orderCol : wSpec.getQueryOrderSpec().getExpressions()) {
                    ExprNodeDesc orderExpr = this.semanticAnalyzer.genExprNodeDesc(orderCol.getExpression(), rr);
                    char orderChar = orderCol.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
                    char nullOrderChar = orderCol.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
                    int index = ExprNodeDescUtils.indexOf(orderExpr, keyCols);
                    if (index >= 0) {
                        order.setCharAt(index, orderChar);
                        nullOrder.setCharAt(index, nullOrderChar);
                        continue;
                    }
                    keyCols.add(orderExpr);
                    order.append(orderChar);
                    nullOrder.append(nullOrderChar);
                }
            }
            SelectOperator selectOp = HiveOpConverter.genReduceSinkAndBacktrackSelect(input, keyCols.toArray(new ExprNodeDesc[keyCols.size()]), 0, partCols, order.toString(), nullOrder.toString(), -1, AcidUtils.Operation.NOT_ACID, this.hiveConf);
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this.semanticAnalyzer, this.hiveConf, rr, this.unparseTranslator);
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            Operator<PTFDesc> ptfOp = OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), (Operator)selectOp, new Operator[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generated " + ptfOp + " with row schema: [" + ptfOp.getSchema() + "]");
            }
            rr = ptfOpRR;
            input = ptfOp;
        }
        return inputOpAf.clone(new Operator[]{input});
    }

    private static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        return HiveOpConverter.genReduceSinkAndBacktrackSelect(input, keys, tag, partitionCols, order, nullOrder, numReducers, acidOperation, hiveConf, input.getSchema().getColumnNames());
    }

    private static SelectOperator genReduceSinkAndBacktrackSelect(Operator<?> input, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf, List<String> keepColNames) throws SemanticException {
        String tableAlias = null;
        Set<String> tableNames = input.getSchema().getTableNames();
        for (String tableName : tableNames) {
            if (tableName == null) continue;
            if (tableName.length() == 0) {
                if (tableAlias != null) continue;
                tableAlias = tableName;
                continue;
            }
            if (tableAlias == null || tableAlias.length() == 0) {
                tableAlias = tableName;
                continue;
            }
            if (tableName.equals(tableAlias)) continue;
            throw new SemanticException("In CBO return path, genReduceSinkAndBacktrackSelect is expecting only one tableAlias but there is more than one");
        }
        if (tableAlias == null) {
            throw new SemanticException("In CBO return path, genReduceSinkAndBacktrackSelect is expecting only one tableAlias but there is none");
        }
        ReduceSinkOperator rsOp = HiveOpConverter.genReduceSink(input, tableAlias, keys, tag, partitionCols, order, nullOrder, numReducers, acidOperation, hiveConf);
        Map<String, ExprNodeDesc> descriptors = HiveOpConverter.buildBacktrackFromReduceSink(keepColNames, ((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames(), ((ReduceSinkDesc)rsOp.getConf()).getOutputValueColumnNames(), rsOp.getValueIndex(), input);
        SelectDesc selectDesc = new SelectDesc(new ArrayList<ExprNodeDesc>(descriptors.values()), new ArrayList<String>(descriptors.keySet()));
        ArrayList<ColumnInfo> cinfoLst = HiveOpConverter.createColInfosSubset(input, keepColNames);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(selectDesc, new RowSchema(cinfoLst), (Operator)rsOp, new Operator[0]);
        selectOp.setColumnExprMap(descriptors);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + selectOp + " with row schema: [" + selectOp.getSchema() + "]");
        }
        return selectOp;
    }

    private static ReduceSinkOperator genReduceSink(Operator<?> input, String tableAlias, ExprNodeDesc[] keys, int tag, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        return HiveOpConverter.genReduceSink(input, tableAlias, keys, tag, new ArrayList<ExprNodeDesc>(), "", "", numReducers, acidOperation, hiveConf);
    }

    private static ReduceSinkOperator genReduceSink(Operator<?> input, String tableAlias, ExprNodeDesc[] keys, int tag, ArrayList<ExprNodeDesc> partitionCols, String order, String nullOrder, int numReducers, AcidUtils.Operation acidOperation, HiveConf hiveConf) throws SemanticException {
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(input));
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeysBack = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc key : keys) {
            reduceKeys.add(key);
            reduceKeysBack.add(ExprNodeDescUtils.backtrack(key, dummy, input));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceValuesBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ColumnInfo> inputColumns = input.getSchema().getSignature();
        ArrayList<ColumnInfo> outputColumns = new ArrayList<ColumnInfo>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        int[] index = new int[inputColumns.size()];
        for (int i = 0; i < inputColumns.size(); ++i) {
            int vindex;
            int kindex;
            ColumnInfo colInfo = (ColumnInfo)inputColumns.get(i);
            String outputColName = colInfo.getInternalName();
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc exprBack = ExprNodeDescUtils.backtrack((ExprNodeDesc)expr, dummy, input);
            int n = kindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceKeysBack);
            if (kindex >= 0) {
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setAlias(outputColName);
                newColInfo.setTabAlias(tableAlias);
                outputColumns.add(newColInfo);
                index[i] = kindex;
                continue;
            }
            int n2 = vindex = exprBack == null ? -1 : ExprNodeDescUtils.indexOf(exprBack, reduceValuesBack);
            if (vindex >= 0) {
                index[i] = -vindex - 1;
                continue;
            }
            index[i] = -reduceValues.size() - 1;
            reduceValues.add(expr);
            reduceValuesBack.add(exprBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName((Object)((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setAlias(outputColName);
            newColInfo.setTabAlias(tableAlias);
            outputColumns.add(newColInfo);
            outputColumnNames.add(outputColName);
        }
        dummy.setParentOperators(null);
        if (reduceKeys.size() == 0) {
            numReducers = 1;
            String error = HiveConf.StrictChecks.checkCartesian((Configuration)hiveConf);
            if (error != null) {
                throw new SemanticException(error);
            }
        }
        ReduceSinkDesc rsDesc = order.isEmpty() ? PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, reduceKeys.size(), numReducers, acidOperation) : PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, false, tag, partitionCols, order, nullOrder, numReducers, acidOperation);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(outputColumns), input, new Operator[0]);
        ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + (String)keyColNames.get(i), reduceKeys.get(i));
        }
        ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
        for (int i = 0; i < valColNames.size(); ++i) {
            colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + (String)valColNames.get(i), reduceValues.get(i));
        }
        rsOp.setValueIndex(index);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAliases(input.getSchema().getTableNames().toArray(new String[input.getSchema().getTableNames().size()]));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + rsOp + " with row schema: [" + rsOp.getSchema() + "]");
        }
        return rsOp;
    }

    private static JoinOperator genJoin(RelNode join, ExprNodeDesc[][] joinExpressions, List<List<ExprNodeDesc>> filterExpressions, List<Operator<?>> children, String[] baseSrc, String tabAlias) throws SemanticException {
        int i;
        Object tag;
        boolean noOuterJoin;
        boolean semiJoin;
        JoinCondDesc[] joinCondns;
        if (join instanceof HiveMultiJoin) {
            HiveMultiJoin hmj = (HiveMultiJoin)join;
            joinCondns = new JoinCondDesc[hmj.getJoinInputs().size()];
            for (int i2 = 0; i2 < hmj.getJoinInputs().size(); ++i2) {
                joinCondns[i2] = new JoinCondDesc(new JoinCond((Integer)hmj.getJoinInputs().get((int)i2).left, (Integer)hmj.getJoinInputs().get((int)i2).right, HiveOpConverter.transformJoinType(hmj.getJoinTypes().get(i2))));
            }
            semiJoin = false;
            noOuterJoin = !hmj.isOuterJoin();
        } else {
            joinCondns = new JoinCondDesc[1];
            JoinType joinType = HiveOpConverter.extractJoinType((HiveJoin)join);
            joinCondns[0] = new JoinCondDesc(new JoinCond(0, 1, joinType));
            semiJoin = joinType == JoinType.LEFTSEMI;
            noOuterJoin = joinType != JoinType.FULLOUTER && joinType != JoinType.LEFTOUTER && joinType != JoinType.RIGHTOUTER;
        }
        ArrayList<ColumnInfo> outputColumns = new ArrayList<ColumnInfo>();
        ArrayList<String> outputColumnNames = new ArrayList<String>(join.getRowType().getFieldNames());
        Operator[] childOps = new Operator[children.size()];
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<ExprNodeDesc>> exprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<Byte, List<ExprNodeDesc>> filters = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        int outputPos = 0;
        for (int pos = 0; pos < children.size(); ++pos) {
            ReduceSinkOperator inputRS = (ReduceSinkOperator)children.get(pos);
            if (inputRS.getNumParent() != 1) {
                throw new SemanticException("RS should have single parent");
            }
            Operator<OperatorDesc> parent = inputRS.getParentOperators().get(0);
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)inputRS.getConf();
            int[] index = inputRS.getValueIndex();
            tag = (byte)rsDesc.getTag();
            if (semiJoin && pos != 0) {
                exprMap.put((Byte)tag, new ArrayList());
                childOps[pos] = inputRS;
                continue;
            }
            ArrayList<String> keyColNames = rsDesc.getOutputKeyColumnNames();
            ArrayList<String> valColNames = rsDesc.getOutputValueColumnNames();
            posToAliasMap.put(pos, new HashSet<String>(inputRS.getSchema().getTableNames()));
            Map<String, ExprNodeDesc> descriptors = HiveOpConverter.buildBacktrackFromReduceSinkForJoin(outputPos, outputColumnNames, keyColNames, valColNames, index, parent, baseSrc[pos]);
            ArrayList<ColumnInfo> parentColumns = parent.getSchema().getSignature();
            for (int i3 = 0; i3 < index.length; ++i3) {
                ColumnInfo info = new ColumnInfo((ColumnInfo)parentColumns.get(i3));
                info.setInternalName(outputColumnNames.get(outputPos));
                info.setTabAlias(tabAlias);
                outputColumns.add(info);
                reversedExprs.put(outputColumnNames.get(outputPos), (Byte)tag);
                ++outputPos;
            }
            exprMap.put((Byte)tag, new ArrayList<ExprNodeDesc>(descriptors.values()));
            colExprMap.putAll(descriptors);
            childOps[pos] = inputRS;
        }
        ArrayList filtersPerInput = Lists.newArrayList();
        int[][] filterMap = new int[children.size()][];
        for (i = 0; i < children.size(); ++i) {
            filtersPerInput.add(new ArrayList());
        }
        for (i = 0; i < filterExpressions.size(); ++i) {
            int leftPos = joinCondns[i].getLeft();
            int rightPos = joinCondns[i].getRight();
            for (ExprNodeDesc expr : filterExpressions.get(i)) {
                int inputPos = HiveOpConverter.updateExprNode(expr, reversedExprs, colExprMap);
                if (inputPos == -1) {
                    inputPos = leftPos;
                }
                ((List)filtersPerInput.get(inputPos)).add(expr);
                if (joinCondns[i].getType() != 3 && joinCondns[i].getType() != 1 && joinCondns[i].getType() != 2) continue;
                if (inputPos == leftPos) {
                    HiveOpConverter.updateFilterMap(filterMap, leftPos, rightPos);
                    continue;
                }
                HiveOpConverter.updateFilterMap(filterMap, rightPos, leftPos);
            }
        }
        for (int pos = 0; pos < children.size(); ++pos) {
            ReduceSinkOperator inputRS = (ReduceSinkOperator)children.get(pos);
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)inputRS.getConf();
            tag = (byte)rsDesc.getTag();
            filters.put((Byte)tag, (List<ExprNodeDesc>)filtersPerInput.get(pos));
        }
        JoinDesc desc = new JoinDesc(exprMap, outputColumnNames, noOuterJoin, joinCondns, filters, joinExpressions);
        desc.setReversedExprs(reversedExprs);
        desc.setFilterMap(filterMap);
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(childOps[0].getCompilationOpContext(), desc, new RowSchema(outputColumns), childOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated " + joinOp + " with row schema: [" + joinOp.getSchema() + "]");
        }
        return joinOp;
    }

    private static int updateExprNode(ExprNodeDesc expr, Map<String, Byte> reversedExprs, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        byte inputPos = -1;
        if (expr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)expr;
            ArrayList<ExprNodeDesc> newChildren = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc functionChild : func.getChildren()) {
                if (functionChild instanceof ExprNodeColumnDesc) {
                    String colRef = functionChild.getExprString();
                    byte pos = reversedExprs.get(colRef);
                    if (pos != -1) {
                        if (inputPos == -1) {
                            inputPos = pos;
                        } else if (inputPos != pos) {
                            throw new SemanticException("UpdateExprNode is expecting only one position for join operator convert. But there are more than one.");
                        }
                    }
                    newChildren.add(colExprMap.get(colRef));
                    continue;
                }
                byte pos = HiveOpConverter.updateExprNode(functionChild, reversedExprs, colExprMap);
                if (pos != -1) {
                    if (inputPos == -1) {
                        inputPos = pos;
                    } else if (inputPos != pos) {
                        throw new SemanticException("UpdateExprNode is expecting only one position for join operator convert. But there are more than one.");
                    }
                }
                newChildren.add(functionChild);
            }
            func.setChildren(newChildren);
        }
        return inputPos;
    }

    private static void updateFilterMap(int[][] filterMap, int inputPos, int joinPos) {
        int[] map = filterMap[inputPos];
        if (map == null) {
            filterMap[inputPos] = new int[2];
            filterMap[inputPos][0] = joinPos;
            int[] nArray = filterMap[inputPos];
            nArray[1] = nArray[1] + 1;
        } else {
            boolean inserted = false;
            for (int j = 0; j < map.length / 2 && !inserted; ++j) {
                if (map[j * 2] != joinPos) continue;
                int n = j * 2 + 1;
                map[n] = map[n] + 1;
                inserted = true;
            }
            if (!inserted) {
                int[] newMap = new int[map.length + 2];
                System.arraycopy(map, 0, newMap, 0, map.length);
                newMap[map.length] = joinPos;
                int n = map.length + 1;
                newMap[n] = newMap[n] + 1;
                filterMap[inputPos] = newMap;
            }
        }
    }

    private static JoinType extractJoinType(HiveJoin join) {
        JoinType resultJoinType;
        if (join.isLeftSemiJoin()) {
            return JoinType.LEFTSEMI;
        }
        switch (join.getJoinType()) {
            case FULL: {
                resultJoinType = JoinType.FULLOUTER;
                break;
            }
            case LEFT: {
                resultJoinType = JoinType.LEFTOUTER;
                break;
            }
            case RIGHT: {
                resultJoinType = JoinType.RIGHTOUTER;
                break;
            }
            default: {
                resultJoinType = JoinType.INNER;
            }
        }
        return resultJoinType;
    }

    private static JoinType transformJoinType(JoinRelType type) {
        JoinType resultJoinType;
        switch (type) {
            case FULL: {
                resultJoinType = JoinType.FULLOUTER;
                break;
            }
            case LEFT: {
                resultJoinType = JoinType.LEFTOUTER;
                break;
            }
            case RIGHT: {
                resultJoinType = JoinType.RIGHTOUTER;
                break;
            }
            default: {
                resultJoinType = JoinType.INNER;
            }
        }
        return resultJoinType;
    }

    private static Map<String, ExprNodeDesc> buildBacktrackFromReduceSinkForJoin(int initialPos, List<String> outputColumnNames, List<String> keyColNames, List<String> valueColNames, int[] index, Operator<?> inputOp, String tabAlias) {
        LinkedHashMap<String, ExprNodeDesc> columnDescriptors = new LinkedHashMap<String, ExprNodeDesc>();
        for (int i = 0; i < index.length; ++i) {
            ColumnInfo info = new ColumnInfo(inputOp.getSchema().getSignature().get(i));
            String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
            ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, tabAlias, info.getIsVirtualCol());
            columnDescriptors.put(outputColumnNames.get(initialPos + i), desc);
        }
        return columnDescriptors;
    }

    private static Map<String, ExprNodeDesc> buildBacktrackFromReduceSink(List<String> keepColNames, List<String> keyColNames, List<String> valueColNames, int[] index, Operator<?> inputOp) {
        LinkedHashMap<String, ExprNodeDesc> columnDescriptors = new LinkedHashMap<String, ExprNodeDesc>();
        int pos = 0;
        for (int i = 0; i < index.length; ++i) {
            ColumnInfo info = inputOp.getSchema().getSignature().get(i);
            if (pos >= keepColNames.size() || !info.getInternalName().equals(keepColNames.get(pos))) continue;
            String field = index[i] >= 0 ? (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : (Object)((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
            ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            columnDescriptors.put(keepColNames.get(pos), desc);
            ++pos;
        }
        return columnDescriptors;
    }

    private static ExprNodeDesc convertToExprNode(RexNode rn, RelNode inputRel, String tabAlias, OpAttr inputAttr) {
        return HiveOpConverter.convertToExprNode(rn, inputRel, tabAlias, inputAttr.vcolsInCalcite);
    }

    private static ExprNodeDesc convertToExprNode(RexNode rn, RelNode inputRel, String tabAlias, Set<Integer> vcolsInCalcite) {
        return (ExprNodeDesc)rn.accept((RexVisitor)new ExprNodeConverter(tabAlias, inputRel.getRowType(), vcolsInCalcite, inputRel.getCluster().getTypeFactory(), true));
    }

    private static ArrayList<ColumnInfo> createColInfos(Operator<?> input) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            cInfoLst.add(new ColumnInfo(ci));
        }
        return cInfoLst;
    }

    private static ArrayList<ColumnInfo> createColInfos(Operator<?> input, String tableAlias) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            ColumnInfo copyOfColumnInfo = new ColumnInfo(ci);
            copyOfColumnInfo.setTabAlias(tableAlias);
            cInfoLst.add(copyOfColumnInfo);
        }
        return cInfoLst;
    }

    private static ArrayList<ColumnInfo> createColInfosSubset(Operator<?> input, List<String> keepColNames) {
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        int pos = 0;
        for (ColumnInfo ci : input.getSchema().getSignature()) {
            if (pos >= keepColNames.size() || !ci.getInternalName().equals(keepColNames.get(pos))) continue;
            cInfoLst.add(new ColumnInfo(ci));
            ++pos;
        }
        return cInfoLst;
    }

    private static Pair<ArrayList<ColumnInfo>, Set<Integer>> createColInfos(List<RexNode> calciteExprs, List<ExprNodeDesc> hiveExprs, List<String> projNames, OpAttr inpOpAf) {
        if (hiveExprs.size() != projNames.size()) {
            throw new RuntimeException("Column expressions list doesn't match Column Names list");
        }
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        HashSet<Integer> newVColSet = new HashSet<Integer>();
        for (int i = 0; i < hiveExprs.size(); ++i) {
            ExprNodeDesc pe = hiveExprs.get(i);
            RexNode rexN = calciteExprs.get(i);
            boolean vc = false;
            if (rexN instanceof RexInputRef && inpOpAf.vcolsInCalcite.contains((Object)((RexInputRef)rexN).getIndex())) {
                newVColSet.add(i);
                vc = true;
            }
            colInfos.add(new ColumnInfo(projNames.get(i), pe.getTypeInfo(), inpOpAf.tabAlias, vc));
        }
        return new Pair(colInfos, newVColSet);
    }

    private Operator<? extends OperatorDesc> genInputSelectForUnion(Operator<? extends OperatorDesc> origInputOp, ArrayList<ColumnInfo> uColumnInfo) throws SemanticException {
        Iterator<ColumnInfo> oIter = origInputOp.getSchema().getSignature().iterator();
        Iterator<ColumnInfo> uIter = uColumnInfo.iterator();
        ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
        ArrayList<String> colName = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        boolean needSelectOp = false;
        while (oIter.hasNext()) {
            ColumnInfo uInfo;
            ColumnInfo oInfo = oIter.next();
            if (!oInfo.isSameColumnForRR(uInfo = uIter.next())) {
                needSelectOp = true;
            }
            ExprNodeDesc column = new ExprNodeColumnDesc(oInfo.getType(), oInfo.getInternalName(), oInfo.getTabAlias(), oInfo.getIsVirtualCol(), oInfo.isSkewedCol());
            if (!oInfo.getType().equals((Object)uInfo.getType())) {
                column = ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)uInfo.getType());
            }
            columns.add(column);
            colName.add(uInfo.getInternalName());
            columnExprMap.put(uInfo.getInternalName(), column);
        }
        if (needSelectOp) {
            return OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(uColumnInfo), columnExprMap, origInputOp, new Operator[0]);
        }
        return origInputOp;
    }

    static class OpAttr {
        final String tabAlias;
        ImmutableList<Operator> inputs;
        ImmutableSet<Integer> vcolsInCalcite;

        OpAttr(String tabAlias, Set<Integer> vcols, Operator ... inputs) {
            this.tabAlias = tabAlias;
            this.inputs = ImmutableList.copyOf((Object[])inputs);
            this.vcolsInCalcite = ImmutableSet.copyOf(vcols);
        }

        private OpAttr clone(Operator ... inputs) {
            return new OpAttr(this.tabAlias, (Set<Integer>)this.vcolsInCalcite, inputs);
        }
    }

    public static enum HIVEAGGOPMODE {
        NO_SKEW_NO_MAP_SIDE_AGG,
        SKEW_NO_MAP_SIDE_AGG,
        NO_SKEW_MAP_SIDE_AGG,
        SKEW_MAP_SIDE_AGG;

    }
}

