/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class TimestampScalarSubtractIntervalYearMonthColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private Timestamp value;
    private int outputColumn;
    private HiveIntervalYearMonth scratchIntervalYearMonth2;
    private DateTimeMath dtm = new DateTimeMath();

    public TimestampScalarSubtractIntervalYearMonthColumn(Timestamp value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
        this.scratchIntervalYearMonth2 = new HiveIntervalYearMonth();
    }

    public TimestampScalarSubtractIntervalYearMonthColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector2.noNulls;
        outputColVector.isRepeating = inputColVector2.isRepeating;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector2.isRepeating) {
            this.scratchIntervalYearMonth2.set((int)vector2[0]);
            this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("interval_year_month")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

