/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringGroupColLessEqualStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public StringGroupColLessEqualStringGroupColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public StringGroupColLessEqualStringGroupColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        block73: {
            int[] length2;
            int[] length1;
            int[] start2;
            int[] start1;
            byte[][] vector2;
            byte[][] vector1;
            int n;
            boolean[] outNull;
            boolean[] nullPos2;
            boolean[] nullPos1;
            int[] sel;
            BytesColumnVector inputColVector2;
            BytesColumnVector inputColVector1;
            block78: {
                block76: {
                    block77: {
                        block74: {
                            block75: {
                                block72: {
                                    if (this.childExpressions != null) {
                                        super.evaluateChildren(batch);
                                    }
                                    inputColVector1 = (BytesColumnVector)batch.cols[this.colNum1];
                                    inputColVector2 = (BytesColumnVector)batch.cols[this.colNum2];
                                    LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
                                    sel = batch.selected;
                                    nullPos1 = inputColVector1.isNull;
                                    nullPos2 = inputColVector2.isNull;
                                    outNull = outputColVector.isNull;
                                    n = batch.size;
                                    vector1 = inputColVector1.vector;
                                    vector2 = inputColVector2.vector;
                                    start1 = inputColVector1.start;
                                    start2 = inputColVector2.start;
                                    length1 = inputColVector1.length;
                                    length2 = inputColVector2.length;
                                    long[] outVector = outputColVector.vector;
                                    if (n == 0) {
                                        return;
                                    }
                                    outputColVector.noNulls = true;
                                    outputColVector.isRepeating = false;
                                    if (!inputColVector1.noNulls || !inputColVector2.noNulls) break block72;
                                    outputColVector.noNulls = true;
                                    if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                                        outputColVector.isRepeating = true;
                                        int ret = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]);
                                        outVector[0] = ret <= 0 ? 1L : 0L;
                                    } else if (inputColVector1.isRepeating) {
                                        if (batch.selectedInUse) {
                                            for (int j = 0; j != n; ++j) {
                                                int i = sel[j];
                                                outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                            }
                                        } else {
                                            for (int i = 0; i != n; ++i) {
                                                outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                            }
                                        }
                                    } else if (inputColVector2.isRepeating) {
                                        if (batch.selectedInUse) {
                                            for (int j = 0; j != n; ++j) {
                                                int i = sel[j];
                                                outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                                            }
                                        } else {
                                            for (int i = 0; i != n; ++i) {
                                                outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                                            }
                                        }
                                    } else if (batch.selectedInUse) {
                                        for (int j = 0; j != n; ++j) {
                                            int i = sel[j];
                                            outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                        }
                                    } else {
                                        for (int i = 0; i != n; ++i) {
                                            outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                        }
                                    }
                                    break block73;
                                }
                                if (!inputColVector1.noNulls) break block74;
                                outputColVector.noNulls = false;
                                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block75;
                                outputColVector.isRepeating = true;
                                outNull[0] = nullPos2[0];
                                if (nullPos2[0]) break block73;
                                outVector[0] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                                break block73;
                            }
                            if (inputColVector1.isRepeating) {
                                if (batch.selectedInUse) {
                                    for (int j = 0; j != n; ++j) {
                                        int i = sel[j];
                                        outNull[i] = nullPos2[i];
                                        if (nullPos2[i]) continue;
                                        outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                    }
                                } else {
                                    for (int i = 0; i != n; ++i) {
                                        outNull[i] = nullPos2[i];
                                        if (nullPos2[i]) continue;
                                        outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                    }
                                }
                            } else if (inputColVector2.isRepeating) {
                                if (nullPos2[0]) {
                                    outputColVector.isRepeating = true;
                                    outNull[0] = true;
                                    return;
                                }
                                if (batch.selectedInUse) {
                                    for (int j = 0; j != n; ++j) {
                                        int i = sel[j];
                                        outNull[i] = false;
                                        outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                                    }
                                } else {
                                    for (int i = 0; i != n; ++i) {
                                        outNull[i] = false;
                                        outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                                    }
                                }
                            } else if (batch.selectedInUse) {
                                for (int j = 0; j != n; ++j) {
                                    int i = sel[j];
                                    outNull[i] = nullPos2[i];
                                    if (nullPos2[i]) continue;
                                    outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                }
                            } else {
                                for (int i = 0; i != n; ++i) {
                                    outNull[i] = nullPos2[i];
                                    if (nullPos2[i]) continue;
                                    outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                                }
                            }
                            break block73;
                        }
                        if (!inputColVector2.noNulls) break block76;
                        outputColVector.noNulls = false;
                        if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block77;
                        outputColVector.isRepeating = true;
                        outNull[0] = nullPos1[0];
                        if (nullPos1[0]) break block73;
                        outVector[0] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                        break block73;
                    }
                    if (inputColVector1.isRepeating) {
                        if (nullPos1[0]) {
                            outputColVector.isRepeating = true;
                            outNull[0] = true;
                            return;
                        }
                        if (batch.selectedInUse) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outNull[i] = false;
                                outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                            }
                        } else {
                            for (int i = 0; i != n; ++i) {
                                outNull[i] = false;
                                outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                            }
                        }
                    } else if (inputColVector2.isRepeating) {
                        if (batch.selectedInUse) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outNull[i] = nullPos1[i];
                                if (nullPos1[i]) continue;
                                outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                            }
                        } else {
                            for (int i = 0; i != n; ++i) {
                                outNull[i] = nullPos1[i];
                                if (nullPos1[i]) continue;
                                outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                            }
                        }
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outNull[i] = nullPos1[i];
                            if (nullPos1[i]) continue;
                            outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            outNull[i] = nullPos1[i];
                            if (nullPos1[i]) continue;
                            outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                        }
                    }
                    break block73;
                }
                outputColVector.noNulls = false;
                if (!inputColVector1.isRepeating || !inputColVector2.isRepeating) break block78;
                outputColVector.isRepeating = true;
                boolean bl = outNull[0] = nullPos1[0] || nullPos2[0];
                if (outNull[0]) break block73;
                outVector[0] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                break block73;
            }
            if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    outputColVector.isRepeating = true;
                    outNull[0] = true;
                    return;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outNull[i] = nullPos2[i];
                        if (nullPos2[i]) continue;
                        outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outNull[i] = nullPos2[i];
                        if (nullPos2[i]) continue;
                        outVector[i] = StringExpr.compare((byte[])vector1[0], (int)start1[0], (int)length1[0], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    outputColVector.isRepeating = true;
                    outNull[0] = true;
                    return;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outNull[i] = nullPos1[i];
                        if (nullPos1[i]) continue;
                        outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outNull[i] = nullPos1[i];
                        if (nullPos1[i]) continue;
                        outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[0], (int)start2[0], (int)length2[0]) <= 0 ? 1L : 0L;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    boolean bl = outNull[i] = nullPos1[i] || nullPos2[i];
                    if (outNull[i]) continue;
                    outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    boolean bl = outNull[i] = nullPos1[i] || nullPos2[i];
                    if (outNull[i]) continue;
                    outVector[i] = StringExpr.compare((byte[])vector1[i], (int)start1[i], (int)length1[i], (byte[])vector2[i], (int)start2[i], (int)length2[i]) <= 0 ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

