/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.spark.SparkRecordHandler;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkReduceRecordHandler
extends SparkRecordHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SparkReduceRecordHandler.class);
    private final Deserializer[] inputValueDeserializer = new Deserializer[127];
    private final Object[] valueObject = new Object[127];
    private final List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
    private final boolean isLogInfoEnabled = LOG.isInfoEnabled();
    private Deserializer inputKeyDeserializer;
    private Operator<?> reducer;
    private boolean isTagged = false;
    private TableDesc keyTableDesc;
    private TableDesc[] valueTableDesc;
    private ObjectInspector[] rowObjectInspector;
    private boolean vectorized = false;
    private transient Object keyObject;
    private transient BytesWritable groupKey;
    private DataOutputBuffer buffer;
    private VectorizedRowBatch[] batches;
    private int keysColumnOffset;
    private static final int BATCH_SIZE = 1024;
    private StructObjectInspector keyStructInspector;
    private StructObjectInspector[] valueStructInspectors;
    private List<VectorExpressionWriter>[] valueStringWriters;
    private MapredLocalWork localWork = null;

    public void init(JobConf job, OutputCollector output, Reporter reporter) throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkInitializeOperators");
        super.init(job, output, reporter);
        this.rowObjectInspector = new ObjectInspector[127];
        ObjectInspector[] valueObjectInspector = new ObjectInspector[127];
        ReduceWork gWork = Utilities.getReduceWork((Configuration)job);
        this.reducer = gWork.getReducer();
        this.vectorized = gWork.getVectorMode();
        this.reducer.setParentOperators(null);
        this.isTagged = gWork.getNeedsTagging();
        try {
            this.keyTableDesc = gWork.getKeyDesc();
            this.inputKeyDeserializer = (Deserializer)ReflectionUtils.newInstance(this.keyTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe((Deserializer)this.inputKeyDeserializer, null, (Properties)this.keyTableDesc.getProperties(), null);
            ObjectInspector keyObjectInspector = this.inputKeyDeserializer.getObjectInspector();
            this.valueTableDesc = new TableDesc[gWork.getTagToValueDesc().size()];
            if (this.vectorized) {
                int maxTags = gWork.getTagToValueDesc().size();
                this.keyStructInspector = (StructObjectInspector)keyObjectInspector;
                this.batches = new VectorizedRowBatch[maxTags];
                this.valueStructInspectors = new StructObjectInspector[maxTags];
                this.valueStringWriters = new List[maxTags];
                this.keysColumnOffset = this.keyStructInspector.getAllStructFieldRefs().size();
                this.buffer = new DataOutputBuffer();
            }
            for (int tag = 0; tag < gWork.getTagToValueDesc().size(); ++tag) {
                this.valueTableDesc[tag] = gWork.getTagToValueDesc().get(tag);
                this.inputValueDeserializer[tag] = (Deserializer)ReflectionUtils.newInstance(this.valueTableDesc[tag].getDeserializerClass(), null);
                SerDeUtils.initializeSerDe((Deserializer)this.inputValueDeserializer[tag], null, (Properties)this.valueTableDesc[tag].getProperties(), null);
                valueObjectInspector[tag] = this.inputValueDeserializer[tag].getObjectInspector();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                if (this.vectorized) {
                    this.valueStructInspectors[tag] = (StructObjectInspector)valueObjectInspector[tag];
                    int n = this.keysColumnOffset + this.valueStructInspectors[tag].getAllStructFieldRefs().size();
                    this.valueStringWriters[tag] = new ArrayList<VectorExpressionWriter>(n);
                    this.valueStringWriters[tag].addAll(Arrays.asList(VectorExpressionWriterFactory.genVectorStructExpressionWritables(this.keyStructInspector)));
                    this.valueStringWriters[tag].addAll(Arrays.asList(VectorExpressionWriterFactory.genVectorStructExpressionWritables(this.valueStructInspectors[tag])));
                    this.rowObjectInspector[tag] = Utilities.constructVectorizedReduceRowOI(this.keyStructInspector, this.valueStructInspectors[tag]);
                    this.batches[tag] = gWork.getVectorizedRowBatchCtx().createVectorizedRowBatch();
                    continue;
                }
                ois.add(keyObjectInspector);
                ois.add(valueObjectInspector[tag]);
                this.rowObjectInspector[tag] = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, (List)ois);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ExecMapperContext execContext = new ExecMapperContext(job);
        this.localWork = gWork.getMapRedLocalWork();
        execContext.setJc(this.jc);
        execContext.setLocalWork(this.localWork);
        this.reducer.passExecContext(execContext);
        this.reducer.setReporter(this.rp);
        OperatorUtils.setChildrenCollector(Arrays.asList(this.reducer), output);
        try {
            LOG.info(this.reducer.dump(0));
            this.reducer.initialize((Configuration)this.jc, this.rowObjectInspector);
            if (this.localWork != null) {
                for (Operator operator : this.localWork.getDummyParentOp()) {
                    operator.setExecContext(execContext);
                    operator.initialize((Configuration)this.jc, null);
                }
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkInitializeOperators");
    }

    @Override
    public void processRow(Object key, Object value) throws IOException {
        throw new UnsupportedOperationException("Do not support this method in SparkReduceRecordHandler.");
    }

    @Override
    public <E> void processRow(Object key, Iterator<E> values) throws IOException {
        if (this.reducer.getDone()) {
            return;
        }
        try {
            BytesWritable keyWritable = (BytesWritable)key;
            byte tag = 0;
            if (this.isTagged) {
                int size = keyWritable.getSize() - 1;
                tag = keyWritable.get()[size];
                keyWritable = new BytesWritable(keyWritable.getBytes(), size);
                keyWritable.setSize(size);
            }
            if (!keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    LOG.trace("End Group");
                    this.reducer.endGroup();
                }
                try {
                    this.keyObject = this.inputKeyDeserializer.deserialize((Writable)keyWritable);
                }
                catch (Exception e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.get(), 0, keyWritable.getSize()) + " with properties " + this.keyTableDesc.getProperties(), e);
                }
                this.groupKey.set(keyWritable.get(), 0, keyWritable.getSize());
                LOG.trace("Start Group");
                this.reducer.setGroupKeyObject(this.keyObject);
                this.reducer.startGroup();
            }
            if (this.vectorized) {
                this.processVectors(values, tag);
            } else {
                this.processKeyValues(values, tag);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            Utilities.setReduceWork((Configuration)this.jc, null);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            String msg = "Fatal error: " + e;
            LOG.error(msg, e);
            throw new RuntimeException(e);
        }
    }

    private <E> boolean processKeyValues(Iterator<E> values, byte tag) throws HiveException {
        while (values.hasNext()) {
            BytesWritable valueWritable = (BytesWritable)values.next();
            try {
                this.valueObject[tag] = this.inputValueDeserializer[tag].deserialize((Writable)valueWritable);
            }
            catch (SerDeException e) {
                throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.get(), 0, valueWritable.getSize()) + " with properties " + this.valueTableDesc[tag].getProperties(), e);
            }
            this.row.clear();
            this.row.add(this.keyObject);
            this.row.add(this.valueObject[tag]);
            if (this.isLogInfoEnabled) {
                this.logMemoryInfo();
            }
            try {
                this.reducer.process(this.row, tag);
            }
            catch (Exception e) {
                String rowString = null;
                try {
                    rowString = SerDeUtils.getJSONString(this.row, (ObjectInspector)this.rowObjectInspector[tag]);
                }
                catch (Exception e2) {
                    rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                }
                throw new HiveException("Error while processing row (tag=" + tag + ") " + rowString, e);
            }
        }
        return true;
    }

    private <E> boolean processVectors(Iterator<E> values, byte tag) throws HiveException {
        VectorizedRowBatch batch = this.batches[tag];
        batch.reset();
        VectorizedBatchUtil.addRowToBatchFrom(this.keyObject, this.keyStructInspector, 0, 0, batch, this.buffer);
        for (int i = 0; i < this.keysColumnOffset; ++i) {
            VectorizedBatchUtil.setRepeatingColumn(batch, i);
        }
        int rowIdx = 0;
        try {
            while (values.hasNext()) {
                BytesWritable valueWritable = (BytesWritable)values.next();
                Object valueObj = this.deserializeValue(valueWritable, tag);
                VectorizedBatchUtil.addRowToBatchFrom(valueObj, this.valueStructInspectors[tag], rowIdx, this.keysColumnOffset, batch, this.buffer);
                if (++rowIdx < 1024) continue;
                VectorizedBatchUtil.setBatchSize(batch, rowIdx);
                this.reducer.process(batch, tag);
                rowIdx = 0;
                if (!this.isLogInfoEnabled) continue;
                this.logMemoryInfo();
            }
            if (rowIdx > 0) {
                VectorizedBatchUtil.setBatchSize(batch, rowIdx);
                this.reducer.process(batch, tag);
            }
            if (this.isLogInfoEnabled) {
                this.logMemoryInfo();
            }
        }
        catch (Exception e) {
            String rowString = null;
            try {
                rowString = batch.toString();
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            throw new HiveException("Error while processing vector batch (tag=" + tag + ") " + rowString, e);
        }
        return true;
    }

    private Object deserializeValue(BytesWritable valueWritable, byte tag) throws HiveException {
        try {
            return this.inputValueDeserializer[tag].deserialize((Writable)valueWritable);
        }
        catch (SerDeException e) {
            throw new HiveException("Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.getBytes(), 0, valueWritable.getLength()) + " with properties " + this.valueTableDesc[tag].getProperties(), e);
        }
    }

    @Override
    public void close() {
        if (this.oc == null) {
            LOG.trace("Close called without any rows processed");
        }
        try {
            if (this.groupKey != null) {
                LOG.trace("End Group");
                this.reducer.endGroup();
            }
            if (this.isLogInfoEnabled) {
                this.logCloseInfo();
            }
            this.reducer.close(this.abort);
            if (this.localWork != null) {
                for (Operator<? extends OperatorDesc> dummyOp : this.localWork.getDummyParentOp()) {
                    dummyOp.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats(this.rp, (Configuration)this.jc);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            MapredContext.close();
            Utilities.clearWorkMap((Configuration)this.jc);
        }
    }

    @Override
    public boolean getDone() {
        return this.reducer.getDone();
    }
}

