/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class MapJoinObjectSerDeContext {
    private final ObjectInspector standardOI;
    private final SerDe serde;
    private final boolean hasFilter;

    public MapJoinObjectSerDeContext(SerDe serde, boolean hasFilter) throws SerDeException {
        this.serde = serde;
        this.hasFilter = hasFilter;
        this.standardOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)serde.getObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    public ObjectInspector getStandardOI() {
        return this.standardOI;
    }

    public SerDe getSerDe() {
        return this.serde;
    }

    public boolean hasFilterTag() {
        return this.hasFilter;
    }

    public String toString() {
        return "MapJoinObjectSerDeContext [standardOI=" + this.standardOI + ", serde=" + this.serde + ", hasFilter=" + this.hasFilter + "]";
    }
}

