/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.mapred.OutputCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorUtils.class);

    public static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperators(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperator(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperators(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperators(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            if (start == null) continue;
            OperatorUtils.findOperators(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                OperatorUtils.findOperators(child, clazz, found);
            }
        }
        return found;
    }

    public static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperatorUpstream(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> T findSingleOperatorUpstreamJoinAccounted(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperatorsUpstreamJoinAccounted(start, clazz, new HashSet());
        return found.size() >= 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperatorsUpstream(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            OperatorUtils.findOperatorsUpstream(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                OperatorUtils.findOperatorsUpstream(parent, clazz, found);
            }
        }
        return found;
    }

    public static <T> Set<T> findOperatorsUpstreamJoinAccounted(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        int onlyIncludeIndex = -1;
        if (start instanceof AbstractMapJoinOperator) {
            AbstractMapJoinOperator mapJoinOp = (AbstractMapJoinOperator)start;
            MapJoinDesc desc = (MapJoinDesc)mapJoinOp.getConf();
            onlyIncludeIndex = desc.getPosBigTable();
        }
        if (start.getParentOperators() != null) {
            int i = 0;
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                if (onlyIncludeIndex >= 0) {
                    if (onlyIncludeIndex == i) {
                        OperatorUtils.findOperatorsUpstream(parent, clazz, found);
                    }
                } else {
                    OperatorUtils.findOperatorsUpstream(parent, clazz, found);
                }
                ++i;
            }
        }
        return found;
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, OutputCollector out) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getName().equals(ReduceSinkOperator.getOperatorName())) {
                op.setOutputCollector(out);
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), out);
        }
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, Map<String, OutputCollector> outMap) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getIsReduceSink()) {
                String outputName = op.getReduceOutputName();
                if (!outMap.containsKey(outputName)) continue;
                LOG.info("Setting output collector: " + op + " --> " + outputName);
                op.setOutputCollector(outMap.get(outputName));
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), outMap);
        }
    }

    public static <T> T findLastOperator(Operator<?> op, Class<T> clazz) {
        Operator<Object> currentOp = op;
        Operator<?> lastOp = null;
        while (currentOp != null) {
            if (clazz.isInstance(currentOp)) {
                lastOp = currentOp;
            }
            if (currentOp.getChildOperators().size() == 1) {
                currentOp = currentOp.getChildOperators().get(0);
                continue;
            }
            currentOp = null;
        }
        return (T)lastOp;
    }

    public static <T> T findLastOperatorUpstream(Operator<?> op, Class<T> clazz) {
        Operator<Object> currentOp = op;
        Operator<?> lastOp = null;
        while (currentOp != null) {
            if (clazz.isInstance(currentOp)) {
                lastOp = currentOp;
            }
            if (currentOp.getParentOperators().size() == 1) {
                currentOp = currentOp.getParentOperators().get(0);
                continue;
            }
            currentOp = null;
        }
        return (T)lastOp;
    }

    public static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function) {
        OperatorUtils.iterateParents(operator, function, new HashSet());
    }

    private static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function, Set<Operator<?>> visited) {
        if (!visited.add(operator)) {
            return;
        }
        function.apply(operator);
        if (operator.getNumParent() > 0) {
            for (Operator<OperatorDesc> parent : operator.getParentOperators()) {
                OperatorUtils.iterateParents(parent, function, visited);
            }
        }
    }

    public static boolean sameRowSchema(Operator<?> operator1, Operator<?> operator2) {
        return operator1.getSchema().equals(operator2.getSchema());
    }

    public static Multimap<Class<? extends Operator<?>>, Operator<?>> classifyOperators(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        ImmutableMultimap.Builder resultMap = new ImmutableMultimap.Builder();
        ArrayList ops = new ArrayList();
        ops.add(start);
        while (!ops.isEmpty()) {
            ArrayList<Operator<OperatorDesc>> allChildren = new ArrayList<Operator<OperatorDesc>>();
            for (Operator operator : ops) {
                for (Class<Operator<?>> clazz : classes) {
                    if (!clazz.isInstance(operator)) continue;
                    resultMap.put(clazz, (Object)operator);
                }
                allChildren.addAll(operator.getChildOperators());
            }
            ops = allChildren;
        }
        return resultMap.build();
    }

    public static Multimap<Class<? extends Operator<?>>, Operator<?>> classifyOperatorsUpstream(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        ImmutableMultimap.Builder resultMap = new ImmutableMultimap.Builder();
        ArrayList ops = new ArrayList();
        ops.add(start);
        while (!ops.isEmpty()) {
            ArrayList<Operator<OperatorDesc>> allParent = new ArrayList<Operator<OperatorDesc>>();
            for (Operator operator : ops) {
                for (Class<Operator<?>> clazz : classes) {
                    if (!clazz.isInstance(operator)) continue;
                    resultMap.put(clazz, (Object)operator);
                }
                if (operator.getParentOperators() == null) continue;
                allParent.addAll(operator.getParentOperators());
            }
            ops = allParent;
        }
        return resultMap.build();
    }

    public static int countOperatorsUpstream(Operator<?> start, Set<Class<? extends Operator<?>>> classes) {
        Multimap<Class<? extends Operator<?>>, Operator<?>> ops = OperatorUtils.classifyOperatorsUpstream(start, classes);
        int numberOperators = 0;
        HashSet<Operator> uniqueOperators = new HashSet<Operator>();
        for (Operator op : ops.values()) {
            if (!uniqueOperators.add(op)) continue;
            ++numberOperators;
        }
        return numberOperators;
    }
}

