/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase;

import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseServiceImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.IOExceptionUtil;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPool;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.HBaseTableImpl;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HBaseConnectionImpl
implements HBaseConnection {
    private final HBaseServiceImpl hBaseService;
    private final HBaseConnectionPool hBaseConnectionPool;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;

    public HBaseConnectionImpl(HBaseServiceImpl hBaseService, HBaseShim hBaseShim, HBaseBytesUtilShim hBaseBytesUtilShim, Properties connectionProps, LogChannelInterface logChannelInterface) throws IOException {
        this(hBaseService, hBaseBytesUtilShim, new HBaseConnectionPool(hBaseShim, connectionProps, logChannelInterface));
    }

    public HBaseConnectionImpl(HBaseServiceImpl hBaseService, HBaseBytesUtilShim hBaseBytesUtilShim, HBaseConnectionPool hBaseConnectionPool) {
        this.hBaseService = hBaseService;
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.hBaseConnectionPool = hBaseConnectionPool;
    }

    public HBaseService getService() {
        return this.hBaseService;
    }

    public HBaseTableImpl getTable(String tableName) throws IOException {
        return new HBaseTableImpl(this.hBaseConnectionPool, this.hBaseService.getHBaseValueMetaInterfaceFactory(), this.hBaseBytesUtilShim, tableName);
    }

    public void checkHBaseAvailable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().checkHBaseAvailable();
        }
        catch (Exception e) {
            throw IOExceptionUtil.wrapIfNecessary(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listTableNames() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            List<String> list = hBaseConnectionHandle.getConnection().listTableNames();
            return list;
        }
        catch (Exception e) {
            throw IOExceptionUtil.wrapIfNecessary(e);
        }
    }

    public void close() throws IOException {
        this.hBaseConnectionPool.close();
    }
}

