/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;

public class ShellPrevalidator {
    public static final String JAVA_VAR_HADOOP_HOME_DIR = "hadoop.home.dir";
    public static final String ENV_HADOOP_HOME = "HADOOP_HOME";

    static String checkHadoopHome() {
        String home = System.getProperty(JAVA_VAR_HADOOP_HOME_DIR);
        if (home == null) {
            home = System.getenv(ENV_HADOOP_HOME);
        }
        try {
            File ioe;
            if (home == null) {
                throw new IOException("HADOOP_HOME or hadoop.home.dir are not set.");
            }
            if (home.startsWith("\"") && home.endsWith("\"")) {
                home = home.substring(1, home.length() - 1);
            }
            if (!((ioe = new File(home)).isAbsolute() && ioe.exists() && ioe.isDirectory())) {
                throw new IOException("Hadoop home directory " + ioe + " does not exist, is not a directory, or is not an absolute path.");
            }
            home = ioe.getCanonicalPath();
        }
        catch (IOException var2) {
            home = null;
        }
        return home;
    }

    public static boolean doesWinutilsFileExist() throws IOException {
        String fullExeName;
        if (ShellPrevalidator.isWindows() && !ShellPrevalidator.doesFileExist(fullExeName = ShellPrevalidator.checkHadoopHome() + File.separator + "bin" + File.separator + "winutils.exe")) {
            throw new IOException("Could not locate executable " + fullExeName + " in the Hadoop binaries.");
        }
        return true;
    }

    protected static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    static boolean doesFileExist(String fullExeName) {
        File exeFile = new File(fullExeName);
        return exeFile.exists();
    }
}

