/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3n.vfs;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.s3n.vfs.S3NFileSystem;
import org.pentaho.s3n.vfs.S3NPipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NFileObject
extends AbstractFileObject {
    private static final Logger logger = LoggerFactory.getLogger(S3NFileObject.class);
    public static final String DELIMITER = "/";
    private S3NFileSystem fileSystem;
    private String bucketName;
    private String key;
    private S3Object s3Object;

    protected S3NFileObject(AbstractFileName name, S3NFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
        this.bucketName = this.getS3BucketName();
        this.key = this.getBucketRelativeS3Path();
    }

    protected long doGetContentSize() throws Exception {
        S3Object object = this.fileSystem.getS3Client().getObject(this.bucketName, this.key);
        return object.getObjectMetadata().getContentLength();
    }

    protected InputStream doGetInputStream() throws Exception {
        logger.debug("Accessing content " + this.getQualifiedName());
        this.activateContent();
        return this.s3Object.getObjectContent();
    }

    protected FileType doGetType() throws Exception {
        return this.getType();
    }

    protected String[] doListChildren() throws Exception {
        List<Object> childrenList = new ArrayList();
        if (this.getType() == FileType.FOLDER || this.isRootBucket()) {
            childrenList = this.getS3ObjectsFromVirtualFolder();
        }
        String[] childrenArr = new String[childrenList.size()];
        return childrenList.toArray(childrenArr);
    }

    public FileObject[] getChildren() throws FileSystemException {
        FileObject[] children;
        for (FileObject child : children = super.getChildren()) {
            S3NFileObject o = (S3NFileObject)child;
            if (o.key == null || o.key.equals("") || child.getType() != FileType.FILE) continue;
            try {
                logger.debug("Closing inputStream " + this.getQualifiedName(o));
                o.getS3Object().getObjectContent().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return children;
    }

    protected String getS3BucketName() {
        String bucketName = this.getName().getPath();
        bucketName = bucketName.indexOf(DELIMITER, 1) > 1 ? bucketName.substring(1, bucketName.indexOf(DELIMITER, 1)) : bucketName.replaceAll(DELIMITER, "");
        return bucketName;
    }

    private List<String> getS3ObjectsFromVirtualFolder() {
        ArrayList<String> childrenList = new ArrayList<String>();
        String realKey = this.key;
        if (!realKey.endsWith(DELIMITER)) {
            realKey = realKey + DELIMITER;
        }
        if ("".equals(this.key) && "".equals(this.bucketName)) {
            List bucketList = this.fileSystem.getS3Client().listBuckets();
            for (Bucket bucket : bucketList) {
                childrenList.add(bucket.getName() + DELIMITER);
            }
        } else {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(this.key).withDelimiter(DELIMITER);
            ObjectListing ol = this.fileSystem.getS3Client().listObjects(listObjectsRequest);
            ArrayList allSummaries = new ArrayList(ol.getObjectSummaries());
            ArrayList allCommonPrefixes = new ArrayList(ol.getCommonPrefixes());
            while (ol.isTruncated()) {
                ol = this.fileSystem.getS3Client().listNextBatchOfObjects(ol);
                allSummaries.addAll(ol.getObjectSummaries());
                allCommonPrefixes.addAll(ol.getCommonPrefixes());
            }
            for (S3ObjectSummary s3os : allSummaries) {
                if (s3os.getKey().equals(realKey)) continue;
                childrenList.add(s3os.getKey().substring(this.key.length()));
            }
            for (String commonPrefix : allCommonPrefixes) {
                if (commonPrefix.equals(realKey)) continue;
                childrenList.add(commonPrefix.substring(this.key.length()));
            }
        }
        return childrenList;
    }

    private String getBucketRelativeS3Path() {
        if (this.getName().getPath().indexOf(DELIMITER, 1) >= 0) {
            return this.getName().getPath().substring(this.getName().getPath().indexOf(DELIMITER, 1) + 1);
        }
        return "";
    }

    private S3Object getS3Object() {
        return this.getS3Object(this.key);
    }

    private S3Object getS3Object(String key) {
        if (this.s3Object != null && this.s3Object.getObjectContent() != null) {
            logger.debug("Returning exisiting object " + this.getQualifiedName());
            return this.s3Object;
        }
        logger.debug("Getting object " + this.getQualifiedName());
        return this.fileSystem.getS3Client().getObject(this.bucketName, key);
    }

    private S3Object activateContent() {
        this.s3Object = null;
        this.s3Object = this.getS3Object();
        return this.s3Object;
    }

    private boolean isRootBucket() {
        return this.key.equals("");
    }

    protected void doAttach() throws Exception {
        block5: {
            logger.debug("Attach called on " + this.getQualifiedName());
            this.injectType(FileType.IMAGINARY);
            if (this.isRootBucket()) {
                this.injectType(FileType.FOLDER);
                return;
            }
            try {
                this.s3Object = this.getS3Object();
                this.injectType(this.getName().getType());
            }
            catch (AmazonS3Exception e) {
                String keyWithDelimiter = this.key + DELIMITER;
                try {
                    this.s3Object = this.getS3Object(keyWithDelimiter);
                    this.injectType(FileType.FOLDER);
                    this.key = keyWithDelimiter;
                }
                catch (AmazonS3Exception e2) {
                    String errorCode = e2.getErrorCode();
                    if (errorCode.equals("NoSuchKey")) break block5;
                    logger.error("Could not get information on " + this.getQualifiedName(), (Throwable)e2);
                    throw new FileSystemException("vfs.provider/get-type.error", (Object)this.getQualifiedName(), (Throwable)e2);
                }
            }
        }
    }

    protected void doDetach() throws Exception {
        if (this.s3Object != null) {
            logger.debug("detaching " + this.getQualifiedName());
            this.getS3Object().close();
        }
    }

    public void doDelete() throws FileSystemException {
        if (this.getType() == FileType.FOLDER) {
            ObjectListing ol = this.fileSystem.getS3Client().listObjects(this.bucketName, this.key);
            ArrayList allSummaries = new ArrayList(ol.getObjectSummaries());
            while (ol.isTruncated()) {
                ol = this.fileSystem.getS3Client().listNextBatchOfObjects(ol);
                allSummaries.addAll(ol.getObjectSummaries());
            }
            for (S3ObjectSummary s3os : allSummaries) {
                this.fileSystem.getS3Client().deleteObject(this.bucketName, s3os.getKey());
            }
        }
        this.fileSystem.getS3Client().deleteObject(this.bucketName, this.key);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new S3NPipedOutputStream(this.fileSystem, this.bucketName, this.key);
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.s3Object.getObjectMetadata().getLastModified().getTime();
    }

    protected void doCreateFolder() throws Exception {
        if (!this.isRootBucket()) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            metadata.setContentType("binary/octet-stream");
            ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, this.key + DELIMITER, (InputStream)emptyContent, metadata);
            try {
                this.fileSystem.getS3Client().putObject(putObjectRequest);
            }
            catch (AmazonS3Exception e) {
                throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this, (Throwable)e);
            }
        } else {
            throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
        }
    }

    protected void doRename(FileObject newFile) throws Exception {
        if (this.getType().equals((Object)FileType.FOLDER)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        if (this.s3Object == null) {
            throw new FileSystemException("vfs.provider/rename.error", new Object[]{this, newFile});
        }
        S3NFileObject dest = (S3NFileObject)newFile;
        CopyObjectRequest copyObjRequest = new CopyObjectRequest(this.bucketName, this.key, dest.bucketName, dest.key);
        this.fileSystem.getS3Client().copyObject(copyObjRequest);
        this.delete();
    }

    private String getQualifiedName() {
        return this.getQualifiedName(this);
    }

    private String getQualifiedName(S3NFileObject s3nFileObject) {
        return s3nFileObject.bucketName + DELIMITER + s3nFileObject.key;
    }
}

