/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.URLFileNameParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.pentaho.s3.vfs.S3FileName;

public class S3FileNameParser
extends URLFileNameParser {
    private static final S3FileNameParser INSTANCE = new S3FileNameParser();

    public S3FileNameParser() {
        super(843);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String s) throws FileSystemException {
        URLFileName name;
        FileType type;
        if (fileName == null) {
            s = this.encodeAccessKeys(s);
        }
        if (FileType.FILE.equals((Object)(type = (name = (URLFileName)super.parseUri(vfsComponentContext, fileName, s)).getType())) && name.getPath().split("/").length == 2) {
            type = FileType.FOLDER;
        }
        String user = name.getUserName();
        String password = name.getPassword();
        return new S3FileName(name.getScheme(), name.getHostName(), name.getPort(), this.getDefaultPort(), user, password, name.getPath(), type, name.getQueryString());
    }

    public String encodeAccessKeys(String url) {
        int hostNameIndex;
        int n = hostNameIndex = url.indexOf("@s3") == -1 ? url.indexOf("@S3") : url.indexOf("@s3");
        if (url.startsWith("s3://") && hostNameIndex != -1) {
            try {
                String auth = url.substring(5, hostNameIndex);
                String accessKey = auth.substring(0, auth.indexOf(":")).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
                String secretKey = auth.substring(auth.indexOf(":") + 1).replaceAll("\\+", "%2B").replaceAll("/", "%2F");
                return "s3://" + accessKey + ":" + secretKey + url.substring(hostNameIndex);
            }
            catch (StringIndexOutOfBoundsException e) {
                return url;
            }
        }
        return url;
    }
}

