/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.utils;

import com.github.zafarkhaja.semver.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;

public class RequireJsDependencyResolver {
    private Map<String, Map<String, IRequireJsPackageConfiguration>> packagesIndex = new HashMap<String, Map<String, IRequireJsPackageConfiguration>>();
    private final Map<String, PackageDependentsRequirements> requirements = new HashMap<String, PackageDependentsRequirements>();

    public RequireJsDependencyResolver(Collection<IRequireJsPackageConfiguration> availablePackages) {
        for (IRequireJsPackageConfiguration availablePackage : availablePackages) {
            if (availablePackage.getName().isEmpty() || availablePackage.getVersion().isEmpty()) continue;
            Map packageVersion = this.packagesIndex.computeIfAbsent(availablePackage.getName(), name -> new HashMap());
            packageVersion.putIfAbsent(availablePackage.getVersion(), availablePackage);
        }
        for (IRequireJsPackageConfiguration packageConfiguration : availablePackages) {
            packageConfiguration.getDependencies().forEach(this::processPackageDependentsRequirements);
        }
        this.requirements.values().forEach(PackageDependentsRequirements::resolve);
    }

    public IRequireJsPackageConfiguration getResolvedVersion(String dependencyPackageName, String dependencyPackageVersion) {
        String resolvedVersion = this.requirements.containsKey(dependencyPackageName) ? this.requirements.get(dependencyPackageName).getResolution(dependencyPackageVersion) : null;
        return resolvedVersion != null ? this.packagesIndex.get(dependencyPackageName).get(resolvedVersion) : null;
    }

    private void processPackageDependentsRequirements(String requiredPackageId, String requiredVersionCondition) {
        if (!this.packagesIndex.containsKey(requiredPackageId)) {
            return;
        }
        PackageDependentsRequirements requiredPackage = this.requirements.computeIfAbsent(requiredPackageId, k -> new PackageDependentsRequirements());
        if (!requiredPackage.hasProcessedVersionCondition(requiredVersionCondition)) {
            Set<String> availableVersions = this.packagesIndex.get(requiredPackageId).keySet();
            ArrayList<String> resolvedVersions = this.filterVersions(requiredVersionCondition, availableVersions);
            GroupDetail g = new GroupDetail(resolvedVersions);
            requiredPackage.groups.put(requiredVersionCondition, g);
            for (String resolvedVersionId : resolvedVersions) {
                VersionDetail resolvedVersion = requiredPackage.versions.computeIfAbsent(resolvedVersionId, x$0 -> new VersionDetail((String)x$0));
                resolvedVersion.addGroup(g);
            }
        }
    }

    private ArrayList<String> filterVersions(String versionFilter, Set<String> availableVersions) {
        ArrayList<Object> validVersions = new ArrayList<Object>();
        ArrayList<String> validVersionsStrings = new ArrayList<String>();
        if (availableVersions.contains(versionFilter)) {
            validVersionsStrings.add(versionFilter);
            return validVersionsStrings;
        }
        for (String string : availableVersions) {
            try {
                Version parsedAvailableVersion = Version.valueOf((String)string);
                if (!this.versionSatisfiesFilter(parsedAvailableVersion, versionFilter)) continue;
                validVersions.add(parsedAvailableVersion);
            }
            catch (Exception exception) {}
        }
        if (validVersions.isEmpty()) {
            try {
                Version.valueOf((String)versionFilter);
                return this.filterVersions("^" + versionFilter, availableVersions);
            }
            catch (Exception exception) {}
        } else {
            validVersions.sort(Comparator.naturalOrder());
            for (Version version : validVersions) {
                validVersionsStrings.add(version.toString());
            }
        }
        return validVersionsStrings;
    }

    private boolean versionSatisfiesFilter(Version parsedAvailableVersion, String versionFilter) {
        return versionFilter.equals(parsedAvailableVersion.toString()) || parsedAvailableVersion.satisfies(versionFilter);
    }

    private class GroupDetail {
        private final ArrayList<String> versions;
        private final ArrayList<String> excluded;

        GroupDetail(ArrayList<String> resolvedVersions) {
            this.versions = resolvedVersions;
            this.excluded = new ArrayList();
        }

        ArrayList<String> getVersions() {
            return this.versions;
        }

        void exclude(String version) {
            if (this.versions.size() - 1 > this.excluded.size()) {
                this.excluded.add(version);
            }
        }

        String getResolvedVersion() {
            for (String v : this.versions) {
                if (this.excluded.contains(v)) continue;
                return v;
            }
            return null;
        }
    }

    private class VersionDetail
    implements Comparable<VersionDetail> {
        private final String version;
        private final HashSet<GroupDetail> groups;
        private Version parsedVersion;

        VersionDetail(String version) {
            this.version = version;
            this.groups = new HashSet();
            try {
                this.parsedVersion = Version.valueOf((String)this.version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int compareTo(VersionDetail v) {
            int uniqueVersions1;
            int groupsCount1;
            int groupsCount = this.getGroupsCount();
            if (groupsCount != (groupsCount1 = v.getGroupsCount())) {
                return groupsCount > groupsCount1 ? 1 : -1;
            }
            int uniqueVersions = this.getUniqueVersionsCount();
            if (uniqueVersions != (uniqueVersions1 = v.getUniqueVersionsCount())) {
                return uniqueVersions > uniqueVersions1 ? 1 : -1;
            }
            return this.parsedVersion != null && v.parsedVersion != null ? this.parsedVersion.compareTo(v.parsedVersion) : 0;
        }

        int getGroupsCount() {
            return this.groups.size();
        }

        int getUniqueVersionsCount() {
            HashSet<String> uniqueVersions = new HashSet<String>();
            for (GroupDetail g : this.groups) {
                uniqueVersions.addAll(g.getVersions());
            }
            return uniqueVersions.size();
        }

        public void excludeYourself() {
            for (GroupDetail g : this.groups) {
                g.exclude(this.version);
            }
        }

        void addGroup(GroupDetail g) {
            this.groups.add(g);
        }
    }

    private class PackageDependentsRequirements {
        Map<String, GroupDetail> groups = new HashMap<String, GroupDetail>();
        Map<String, VersionDetail> versions = new HashMap<String, VersionDetail>();

        PackageDependentsRequirements() {
        }

        void resolve() {
            ArrayList<VersionDetail> sortedVersions = new ArrayList<VersionDetail>(this.versions.values());
            Collections.sort(sortedVersions);
            for (VersionDetail version : sortedVersions) {
                version.excludeYourself();
            }
        }

        String getResolution(String versionRequirement) {
            if (this.groups.containsKey(versionRequirement)) {
                return this.groups.get(versionRequirement).getResolvedVersion();
            }
            return null;
        }

        boolean hasProcessedVersionCondition(String requiredVersionCondition) {
            return this.groups.containsKey(requiredVersionCondition);
        }
    }
}

