/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.pentaho.requirejs.IRequireJsPackage;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;
import org.pentaho.requirejs.impl.utils.JsonMerger;

public class RequireJsPackageConfigurationImpl
implements IRequireJsPackageConfiguration {
    private final JsonMerger merger = new JsonMerger();
    private final IRequireJsPackage requireJsPackage;
    private Map<String, String> baseModuleIdsMappings;
    private Map<String, String> baseModuleIdsMappingsWithDependencies;
    private String simplePackageOrganization;
    private String simplePackageName;
    private Map<String, String> paths;
    private List<Object> packages;
    private Map<String, Map<String, ?>> shim;
    private Map<String, IRequireJsPackageConfiguration> dependencyCache;

    public RequireJsPackageConfigurationImpl(IRequireJsPackage requireJsPackage) {
        if (requireJsPackage == null) {
            throw new IllegalArgumentException("requireJsPackage is mandatory");
        }
        this.requireJsPackage = requireJsPackage;
        this.processRequireJsPackage();
    }

    public void processRequireJsPackage() {
        Map shim;
        this.dependencyCache = null;
        this.baseModuleIdsMappingsWithDependencies = null;
        String name = this.getName();
        if (name.startsWith("@")) {
            int slashIndex = name.indexOf(47);
            this.simplePackageOrganization = name.substring(1, slashIndex);
            this.simplePackageName = name.substring(slashIndex + 1);
        } else {
            this.simplePackageOrganization = null;
            this.simplePackageName = name;
        }
        this.paths = new HashMap<String, String>();
        this.packages = new ArrayList<Object>();
        this.baseModuleIdsMappings = new HashMap<String, String>();
        this.shim = new HashMap();
        Map modules = this.requireJsPackage.getModules();
        if (modules != null) {
            modules.forEach((moduleId, path) -> {
                String moduleMainFile;
                String versionedModuleId = this.initVersionedModuleId((String)moduleId);
                if (path != null) {
                    String versionedPath = this.getVersionedPath((String)path);
                    this.paths.put(versionedModuleId, versionedPath);
                }
                if ((moduleMainFile = this.requireJsPackage.getModuleMainFile(moduleId)) != null) {
                    if (!moduleMainFile.equals("main")) {
                        HashMap<String, String> packageDefinition = new HashMap<String, String>();
                        packageDefinition.put("name", versionedModuleId);
                        packageDefinition.put("main", moduleMainFile);
                        this.packages.add(packageDefinition);
                    } else {
                        this.packages.add(versionedModuleId);
                    }
                }
            });
        }
        if ((shim = this.requireJsPackage.getShim()) != null) {
            shim.forEach((moduleId, configuration) -> this.shim.put(this.getVersionedModuleId((String)moduleId, this.baseModuleIdsMappings), this.merger.clone((Map<String, ?>)configuration)));
        }
    }

    public void processDependencies(BiFunction<String, String, IRequireJsPackageConfiguration> dependencyResolver) {
        this.dependencyCache = new HashMap<String, IRequireJsPackageConfiguration>();
        this.baseModuleIdsMappingsWithDependencies = new HashMap<String, String>();
        Map<String, String> dependencies = this.getDependencies();
        for (String dependencyPackageName : dependencies.keySet()) {
            String dependencyPackageVersion;
            IRequireJsPackageConfiguration dependencyResolvedVersion = dependencyResolver.apply(dependencyPackageName, dependencyPackageVersion = dependencies.get(dependencyPackageName));
            if (dependencyResolvedVersion == null) continue;
            Map dependencyBaseModuleIds = dependencyResolvedVersion.getBaseModuleIdsMapping();
            dependencyBaseModuleIds.forEach(this.baseModuleIdsMappingsWithDependencies::put);
            this.dependencyCache.put(dependencyPackageName, dependencyResolvedVersion);
        }
        this.baseModuleIdsMappings.forEach(this.baseModuleIdsMappingsWithDependencies::put);
    }

    public Map<String, Object> getRequireConfig(List<IRequireJsPackageConfigurationPlugin> plugins) {
        HashMap<String, Object> requireConfig = new HashMap<String, Object>();
        requireConfig.put("paths", Collections.unmodifiableMap(this.paths));
        requireConfig.put("packages", Collections.unmodifiableList(this.packages));
        HashMap topMap = new HashMap();
        if (!this.baseModuleIdsMappingsWithDependencies.isEmpty()) {
            this.requireJsPackage.getModules().forEach((moduleId, path) -> {
                String versionedModuleId = this.getVersionedModuleId((String)moduleId, this.baseModuleIdsMappings);
                HashMap mappings = new HashMap();
                this.baseModuleIdsMappingsWithDependencies.forEach(mappings::put);
                topMap.put(versionedModuleId, mappings);
            });
        }
        this.requireJsPackage.getMap().forEach((moduleId, localMappings) -> {
            String versionedModuleId = this.getVersionedModuleId((String)moduleId, this.baseModuleIdsMappings);
            Map mappings = topMap.computeIfAbsent(versionedModuleId, m -> new HashMap());
            localMappings.forEach((key, value) -> {
                String versionedValue = this.getVersionedModuleId((String)value, this.baseModuleIdsMappingsWithDependencies);
                mappings.put(key, versionedValue);
            });
        });
        requireConfig.put("map", Collections.unmodifiableMap(topMap));
        HashMap config = new HashMap();
        this.requireJsPackage.getConfig().forEach((moduleId, configuration) -> config.put(moduleId, this.merger.clone((Map<String, ?>)configuration)));
        requireConfig.put("config", config);
        HashMap concreteShim = new HashMap();
        this.shim.forEach((moduleId, configuration) -> {
            HashMap shimConfig = new HashMap();
            Map<String, ?> originalModuleShimConfiguration = this.shim.get(moduleId);
            for (String key : originalModuleShimConfiguration.keySet()) {
                Object originalValue;
                Object convertedValue = originalValue = originalModuleShimConfiguration.get(key);
                if (key.equals("deps")) {
                    List originalDeps = (List)originalValue;
                    ArrayList<String> convertedDeps = new ArrayList<String>();
                    for (String depModuleId : originalDeps) {
                        String versionedDepModuleId = this.getVersionedModuleId(depModuleId, this.baseModuleIdsMappingsWithDependencies);
                        convertedDeps.add(versionedDepModuleId);
                    }
                    convertedValue = convertedDeps;
                }
                shimConfig.put(key, convertedValue);
            }
            concreteShim.put(moduleId, shimConfig);
        });
        requireConfig.put("shim", concreteShim);
        if (plugins != null) {
            plugins.forEach(plugin -> {
                try {
                    plugin.apply((IRequireJsPackageConfiguration)this, this.dependencyCache::get, moduleId -> this.getVersionedModuleId((String)moduleId, this.baseModuleIdsMappingsWithDependencies), Collections.unmodifiableMap(requireConfig));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        HashMap mappedConfig = new HashMap();
        ((Map)requireConfig.get("config")).forEach((moduleId, configuration) -> mappedConfig.put(this.getVersionedModuleId((String)moduleId, this.baseModuleIdsMappingsWithDependencies), configuration));
        requireConfig.put("config", Collections.unmodifiableMap(mappedConfig));
        requireConfig.put("shim", Collections.unmodifiableMap((Map)requireConfig.get("shim")));
        return Collections.unmodifiableMap(requireConfig);
    }

    private String initVersionedModuleId(String moduleId) {
        if (!this.preferGlobal()) {
            String versionedName = this.getName() + "_" + this.getVersion();
            String versionedModuleId = versionedName + "_" + moduleId;
            if (moduleId.equals(this.simplePackageName) || moduleId.startsWith(this.simplePackageName + "/")) {
                versionedModuleId = versionedName + moduleId.substring(this.simplePackageName.length());
            } else if (moduleId.equals(this.simplePackageOrganization + "/" + this.simplePackageName) || moduleId.startsWith(this.simplePackageOrganization + "/" + this.simplePackageName + "/")) {
                versionedModuleId = versionedName + moduleId.substring(this.simplePackageOrganization.length() + this.simplePackageName.length() + 1);
            } else {
                String noSlashModuleId = moduleId.replaceAll("/", "-");
                if (this.simplePackageOrganization == null && (noSlashModuleId.equals(this.simplePackageName) || noSlashModuleId.startsWith(this.simplePackageName + "-"))) {
                    versionedModuleId = versionedName + moduleId.substring(this.simplePackageName.length());
                } else if (noSlashModuleId.equals(this.simplePackageOrganization + "-" + this.simplePackageName) || noSlashModuleId.startsWith(this.simplePackageOrganization + "-" + this.simplePackageName + "-")) {
                    versionedModuleId = versionedName + moduleId.substring(this.simplePackageOrganization.length() + this.simplePackageName.length() + 1);
                }
            }
            this.baseModuleIdsMappings.put(moduleId, versionedModuleId);
            return versionedModuleId;
        }
        return moduleId;
    }

    private String getVersionedModuleId(String moduleId, Map<String, String> moduleIdsMappings) {
        if (moduleId.contains("!")) {
            List<String> parts = Arrays.asList(moduleId.split("!", 2));
            return this.getVersionedModuleId(parts.get(0), moduleIdsMappings) + "!" + this.getVersionedModuleId(parts.get(1), moduleIdsMappings);
        }
        try {
            String baseModuleId = moduleId;
            if (!moduleIdsMappings.containsKey(moduleId)) {
                baseModuleId = moduleIdsMappings.keySet().stream().filter(moduleId::startsWith).max(Comparator.comparingInt(String::length)).get();
            }
            String versionedBaseModuleId = moduleIdsMappings.get(baseModuleId);
            String moduleIdLeaf = moduleId.substring(baseModuleId.length());
            if (!moduleIdLeaf.isEmpty() && !moduleIdLeaf.startsWith("/")) {
                return moduleId;
            }
            return versionedBaseModuleId + moduleIdLeaf;
        }
        catch (NoSuchElementException e) {
            return moduleId;
        }
    }

    private String getVersionedPath(String path) {
        if (path.equals("/")) {
            return this.getWebRootPath();
        }
        if (!path.startsWith("/")) {
            return this.getWebRootPath() + "/" + path;
        }
        return this.getWebRootPath() + path;
    }

    public Map<String, String> getBaseModuleIdsMapping() {
        return Collections.unmodifiableMap(this.baseModuleIdsMappings);
    }

    public Map<String, String> getModuleIdsMapping() {
        if (this.baseModuleIdsMappingsWithDependencies == null) {
            throw new IllegalStateException("Configuration wasn't yet initialized with processDependencies");
        }
        return Collections.unmodifiableMap(this.baseModuleIdsMappingsWithDependencies);
    }

    public IRequireJsPackage getRequireJsPackage() {
        return this.requireJsPackage;
    }

    public String getName() {
        String name = this.requireJsPackage.getName();
        return name != null ? name : "";
    }

    public String getVersion() {
        String version = this.requireJsPackage.getVersion();
        return version != null ? version : "";
    }

    private boolean preferGlobal() {
        return this.requireJsPackage.preferGlobal();
    }

    public Map<String, String> getDependencies() {
        Map dependencies = this.requireJsPackage.getDependencies();
        return dependencies != null ? Collections.unmodifiableMap(dependencies) : Collections.EMPTY_MAP;
    }

    public boolean hasScript(String name) {
        return this.requireJsPackage.hasScript(name);
    }

    public URL getScriptResource(String name) {
        return this.requireJsPackage.getScriptResource(name);
    }

    public String getWebRootPath() {
        String webRootPath = this.requireJsPackage.getWebRootPath();
        return webRootPath != null ? webRootPath.replaceAll("^/+", "") : "";
    }
}

