/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.extension;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.extension.ExtensionPointPluginType;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;

public class ExtensionPointMap {
    private static LogChannelInterface log = new LogChannel("ExtensionPointMap");
    private static ExtensionPointMap INSTANCE = new ExtensionPointMap(PluginRegistry.getInstance());
    private final PluginRegistry registry;
    private Table<String, String, Supplier<ExtensionPointInterface>> extensionPointPluginMap;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private ExtensionPointMap(PluginRegistry pluginRegistry) {
        this.registry = pluginRegistry;
        this.extensionPointPluginMap = HashBasedTable.create();
        this.registry.addPluginListener(ExtensionPointPluginType.class, new PluginTypeListener(){

            @Override
            public void pluginAdded(Object serviceObject) {
                ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
            }

            @Override
            public void pluginRemoved(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
            }

            @Override
            public void pluginChanged(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
                ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
            }
        });
        List extensionPointPlugins = this.registry.getPlugins(ExtensionPointPluginType.class);
        for (PluginInterface extensionPointPlugin : extensionPointPlugins) {
            this.addExtensionPoint(extensionPointPlugin);
        }
    }

    public static ExtensionPointMap getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionPoint(PluginInterface extensionPointPlugin) {
        this.lock.writeLock().lock();
        try {
            for (String id : extensionPointPlugin.getIds()) {
                this.extensionPointPluginMap.put((Object)extensionPointPlugin.getName(), (Object)id, this.createLazyLoader(extensionPointPlugin));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionPoint(PluginInterface extensionPointPlugin) {
        this.lock.writeLock().lock();
        try {
            for (String id : extensionPointPlugin.getIds()) {
                this.extensionPointPluginMap.remove((Object)extensionPointPlugin.getName(), (Object)id);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitialize() {
        this.lock.writeLock().lock();
        try {
            this.extensionPointPluginMap = HashBasedTable.create();
            PluginRegistry registry = PluginRegistry.getInstance();
            List extensionPointPlugins = registry.getPlugins(ExtensionPointPluginType.class);
            for (PluginInterface extensionPointPlugin : extensionPointPlugins) {
                this.addExtensionPoint(extensionPointPlugin);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Supplier<ExtensionPointInterface> createLazyLoader(PluginInterface extensionPointPlugin) {
        return Suppliers.memoize((Supplier)new ExtensionPointLoader(extensionPointPlugin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callExtensionPoint(LogChannelInterface log, String id, Object object) throws KettleException {
        this.lock.readLock().lock();
        try {
            if (this.extensionPointPluginMap.containsRow((Object)id) && !((Map)this.extensionPointPluginMap.rowMap().get(id)).values().isEmpty()) {
                for (Supplier extensionPoint : this.extensionPointPluginMap.row((Object)id).values()) {
                    ((ExtensionPointInterface)extensionPoint.get()).callExtensionPoint(log, object);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointInterface getTableValue(String rowId, String columnId) {
        this.lock.readLock().lock();
        try {
            ExtensionPointInterface extensionPointInterface = this.extensionPointPluginMap.contains((Object)rowId, (Object)columnId) ? (ExtensionPointInterface)((Supplier)this.extensionPointPluginMap.get((Object)rowId, (Object)columnId)).get() : null;
            return extensionPointInterface;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    int getNumberOfRows() {
        this.lock.readLock().lock();
        try {
            int n = this.extensionPointPluginMap.rowMap().size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static LogChannelInterface getLog() {
        if (log == null) {
            log = new LogChannel("ExtensionPointMap");
        }
        return log;
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.extensionPointPluginMap.clear();
            this.registry.addPluginListener(ExtensionPointPluginType.class, new PluginTypeListener(){

                @Override
                public void pluginAdded(Object serviceObject) {
                    ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
                }

                @Override
                public void pluginRemoved(Object serviceObject) {
                    ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
                }

                @Override
                public void pluginChanged(Object serviceObject) {
                    ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
                    ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class ExtensionPointLoader
    implements Supplier<ExtensionPointInterface> {
        private final PluginInterface extensionPointPlugin;

        private ExtensionPointLoader(PluginInterface extensionPointPlugin) {
            this.extensionPointPlugin = extensionPointPlugin;
        }

        public ExtensionPointInterface get() {
            try {
                return ExtensionPointMap.this.registry.loadClass(this.extensionPointPlugin, ExtensionPointInterface.class);
            }
            catch (Exception e) {
                ExtensionPointMap.getLog().logError("Unable to load extension point for name = [" + (this.extensionPointPlugin != null ? this.extensionPointPlugin.getName() : "null") + "]", e);
                return null;
            }
        }
    }
}

