/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.pentaho.marketplace.util.XmlParserFactoryProducer;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.telemetry.ITelemetryHandler;
import org.pentaho.telemetry.TelemetryService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BaPluginTelemetry
extends TelemetryService {
    private static Log logger = LogFactory.getLog(BaPluginTelemetry.class);
    private static String UNKNOWN = "unknown";

    public BaPluginTelemetry(String pluginName, String telemetryUrl, boolean telemetryEnabled, ITelemetryHandler telemetryHandler) {
        super(pluginName, BaPluginTelemetry.getPluginVersion(pluginName), BaPluginTelemetry.getBaVersion(), telemetryUrl, telemetryEnabled, telemetryHandler);
    }

    public BaPluginTelemetry(Bundle bundle, String telemetryUrl, boolean telemetryEnabled, ITelemetryHandler telemetryHandler) {
        super(bundle.getSymbolicName(), BaPluginTelemetry.getPluginVersion(bundle), BaPluginTelemetry.getBaVersion(), telemetryUrl, telemetryEnabled, telemetryHandler);
    }

    private static String getPluginVersion(String pluginName) {
        try {
            String versionPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + pluginName + "/version.xml");
            FileInputStream versionFile = new FileInputStream(new File(versionPath));
            return BaPluginTelemetry.parsePluginVersion(versionFile);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug((Object)"Could not find file version.xml", (Throwable)fnfe);
            return UNKNOWN;
        }
    }

    private static String getPluginVersion(Bundle bundle) {
        try {
            URL versionFileUrl = bundle.getResource("version.xml");
            InputStream versionFile = versionFileUrl.openConnection().getInputStream();
            return BaPluginTelemetry.parsePluginVersion(versionFile);
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"Could not find resource file version.xml", (Throwable)npe);
        }
        catch (IOException ioe) {
            logger.debug((Object)"Could not open file version.xml", (Throwable)ioe);
        }
        return UNKNOWN;
    }

    private static String parsePluginVersion(InputStream versionFile) {
        try {
            DocumentBuilderFactory dbf = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(versionFile);
            NodeList nodes = doc.getElementsByTagName("version");
            if (nodes.getLength() >= 1) {
                Element versionElement = (Element)nodes.item(0);
                return versionElement.getAttribute("branch") + "-" + versionElement.getTextContent();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Could not parse plugin version from version.xml", (Throwable)e);
        }
        return UNKNOWN;
    }

    private static String getBaVersion() {
        IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
        VersionInfo versionInfo = versionHelper != null ? VersionHelper.getVersionInfo(versionHelper.getClass()) : VersionHelper.getVersionInfo(PentahoSystem.class);
        String platformVersion = versionInfo.getProductID() + "-" + versionInfo.getVersionNumber();
        return platformVersion;
    }
}

