/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.serial.ArrayAccess;
import de.simplicit.vjdbc.serial.ArrayAccessors;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

class FlattenedColumnValues
implements Externalizable {
    private static final long serialVersionUID = 3691039872299578672L;
    private Object _arrayOfValues;
    private boolean[] _nullFlags;
    private transient ArrayAccess _arrayAccessor;

    public FlattenedColumnValues() {
    }

    FlattenedColumnValues(Class clazz, int size) {
        if (clazz.isPrimitive()) {
            this._arrayOfValues = Array.newInstance(clazz, size);
            this._nullFlags = new boolean[size];
            this._arrayAccessor = ArrayAccessors.getArrayAccessorForPrimitiveType(clazz);
        } else {
            this._arrayOfValues = Array.newInstance(clazz, size);
            this._nullFlags = null;
            this._arrayAccessor = ArrayAccessors.getObjectArrayAccessor();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._arrayOfValues = in.readObject();
        this._nullFlags = (boolean[])in.readObject();
        Class<?> componentType = this._arrayOfValues.getClass().getComponentType();
        this._arrayAccessor = componentType.isPrimitive() ? ArrayAccessors.getArrayAccessorForPrimitiveType(componentType) : ArrayAccessors.getObjectArrayAccessor();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._arrayOfValues);
        out.writeObject(this._nullFlags);
    }

    void setObject(int index, Object value) {
        this.ensureCapacity(index + 1);
        Array.set(this._arrayOfValues, index, value);
    }

    void setBoolean(int index, boolean value) {
        this.ensureCapacity(index + 1);
        Array.setBoolean(this._arrayOfValues, index, value);
    }

    void setByte(int index, byte value) {
        this.ensureCapacity(index + 1);
        Array.setByte(this._arrayOfValues, index, value);
    }

    void setShort(int index, short value) {
        this.ensureCapacity(index + 1);
        Array.setShort(this._arrayOfValues, index, value);
    }

    void setInt(int index, int value) {
        this.ensureCapacity(index + 1);
        Array.setInt(this._arrayOfValues, index, value);
    }

    void setLong(int index, long value) {
        this.ensureCapacity(index + 1);
        Array.setLong(this._arrayOfValues, index, value);
    }

    void setFloat(int index, float value) {
        this.ensureCapacity(index + 1);
        Array.setFloat(this._arrayOfValues, index, value);
    }

    void setDouble(int index, double value) {
        this.ensureCapacity(index + 1);
        Array.setDouble(this._arrayOfValues, index, value);
    }

    void setIsNull(int index) {
        this.ensureCapacity(index + 1);
        if (this._nullFlags != null) {
            this._nullFlags[index] = true;
        }
    }

    Object getValue(int index) {
        return this._arrayAccessor.getValue(this._arrayOfValues, index, this._nullFlags);
    }

    void ensureCapacity(int minCapacity) {
        int oldCapacity = Array.getLength(this._arrayOfValues);
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object tmpArrayOfValues = this._arrayOfValues;
            this._arrayOfValues = Array.newInstance(tmpArrayOfValues.getClass().getComponentType(), newCapacity);
            System.arraycopy(tmpArrayOfValues, 0, this._arrayOfValues, 0, Array.getLength(tmpArrayOfValues));
            if (this._nullFlags != null) {
                boolean[] tmpNullFlags = this._nullFlags;
                this._nullFlags = new boolean[newCapacity];
                System.arraycopy(tmpNullFlags, 0, this._nullFlags, 0, tmpNullFlags.length);
            }
        }
    }
}

