/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc;

import de.simplicit.vjdbc.ProxyFactory;
import de.simplicit.vjdbc.VirtualBase;
import de.simplicit.vjdbc.VirtualCallableStatement;
import de.simplicit.vjdbc.VirtualDatabaseMetaData;
import de.simplicit.vjdbc.VirtualPreparedStatement;
import de.simplicit.vjdbc.VirtualSavepoint;
import de.simplicit.vjdbc.VirtualStatement;
import de.simplicit.vjdbc.cache.TableCache;
import de.simplicit.vjdbc.command.CommandPool;
import de.simplicit.vjdbc.command.ConnectionCommitCommand;
import de.simplicit.vjdbc.command.ConnectionPrepareCallCommand;
import de.simplicit.vjdbc.command.ConnectionPrepareStatementCommand;
import de.simplicit.vjdbc.command.ConnectionPrepareStatementExtendedCommand;
import de.simplicit.vjdbc.command.ConnectionReleaseSavepointCommand;
import de.simplicit.vjdbc.command.ConnectionRollbackWithSavepointCommand;
import de.simplicit.vjdbc.command.DecoratedCommandSink;
import de.simplicit.vjdbc.command.DestroyCommand;
import de.simplicit.vjdbc.serial.SerialArray;
import de.simplicit.vjdbc.serial.SerialBlob;
import de.simplicit.vjdbc.serial.SerialClob;
import de.simplicit.vjdbc.serial.SerialNClob;
import de.simplicit.vjdbc.serial.SerialSQLXML;
import de.simplicit.vjdbc.serial.SerialStruct;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.util.ClientInfo;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualConnection
extends VirtualBase
implements Connection {
    private static Log _logger = LogFactory.getLog(VirtualConnection.class);
    private static TableCache s_tableCache;
    private boolean _cachingEnabled = false;
    private Boolean _isAutoCommit = null;
    private Properties _connectionProperties;
    protected DatabaseMetaData _databaseMetaData;
    protected boolean _isClosed = false;
    protected ProxyFactory proxyFactory = null;

    public VirtualConnection(UIDEx reg, DecoratedCommandSink sink, Properties props, boolean cachingEnabled) {
        super(reg, sink);
        this._connectionProperties = props;
        this._cachingEnabled = cachingEnabled;
    }

    public void setProxyFactory(ProxyFactory factory) {
        this.proxyFactory = factory;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this._isClosed) {
            this.close();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        Object result = this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "createStatement"), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualStatement(reg, this, this._sink, 1003);
        }
        return (Statement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = null;
        if (this._cachingEnabled) {
            String cachedTables;
            if (s_tableCache == null && (cachedTables = this._connectionProperties.getProperty("vjdbc.cache.tables")) != null) {
                try {
                    s_tableCache = new TableCache(this, cachedTables);
                }
                catch (SQLException e) {
                    _logger.error((Object)"Creation of table cache failed, disable caching", (Throwable)e);
                    this._cachingEnabled = false;
                }
            }
            if (s_tableCache != null) {
                pstmt = s_tableCache.getPreparedStatement(sql);
            }
        }
        if (pstmt == null) {
            Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementCommand(sql), true);
            if (result instanceof UIDEx) {
                UIDEx reg = (UIDEx)result;
                pstmt = new VirtualPreparedStatement(reg, this, sql, this._sink, 1003);
            } else {
                pstmt = (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
            }
        }
        return pstmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareCallCommand(sql), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualCallableStatement(reg, this, sql, this._sink, 1003);
        }
        return (CallableStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return (String)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "nativeSQL", new Object[]{sql}, 3));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setAutoCommit", new Object[]{autoCommit ? Boolean.TRUE : Boolean.FALSE}, 1));
        this._isAutoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this._isAutoCommit == null) {
            boolean autoCommit = this._sink.processWithBooleanResult(this._objectUid, CommandPool.getReflectiveCommand(2, "getAutoCommit"));
            this._isAutoCommit = autoCommit;
        }
        return this._isAutoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this._sink.processWithBooleanResult(this._objectUid, new ConnectionCommitCommand());
    }

    @Override
    public void rollback() throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "rollback"));
    }

    @Override
    public void close() throws SQLException {
        if (this._databaseMetaData != null && this._databaseMetaData instanceof VirtualDatabaseMetaData) {
            UIDEx metadataId = ((VirtualDatabaseMetaData)this._databaseMetaData)._objectUid;
            this._sink.process(metadataId, new DestroyCommand(metadataId, 3));
            this._databaseMetaData = null;
        }
        this._sink.process(this._objectUid, new DestroyCommand(this._objectUid, 2));
        this._sink.close();
        this._isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this._databaseMetaData == null) {
            Object result = this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "getMetaData"), true);
            if (result instanceof UIDEx) {
                UIDEx reg = (UIDEx)result;
                this._databaseMetaData = new VirtualDatabaseMetaData(this, reg, this._sink);
            } else {
                this._databaseMetaData = (DatabaseMetaData)this.proxyFactory.makeJdbcObject(result);
            }
        }
        return this._databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setReadOnly", new Object[]{readOnly ? Boolean.TRUE : Boolean.FALSE}, 1));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, CommandPool.getReflectiveCommand(2, "isReadOnly"));
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setCatalog", new Object[]{catalog}, 3));
    }

    @Override
    public String getCatalog() throws SQLException {
        return (String)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "getCatalog"));
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setTransactionIsolation", new Object[]{new Integer(level)}, 2));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(2, "getTransactionIsolation"));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Object result = this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "createStatement", new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)}, 5), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualStatement(reg, this, this._sink, resultSetType);
        }
        return (Statement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementCommand(sql, resultSetType, resultSetConcurrency), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualPreparedStatement(reg, this, sql, this._sink, resultSetType);
        }
        return (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareCallCommand(sql, resultSetType, resultSetConcurrency), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualCallableStatement(reg, this, sql, this._sink, resultSetType);
        }
        return (CallableStatement)this.proxyFactory.makeJdbcObject(result);
    }

    public Map getTypeMap() throws SQLException {
        return (Map)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "getTypeMap"));
    }

    public void setTypeMap(Map map) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setTypeMap", new Object[]{map}, 4));
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setHoldability", new Object[]{new Integer(holdability)}, 2));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(2, "getHoldability"));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        UIDEx reg = (UIDEx)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setSavepoint"), true);
        return new VirtualSavepoint(reg, this._sink);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        UIDEx reg = (UIDEx)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setSavepoint", new Object[]{name}, 3), true);
        return new VirtualSavepoint(reg, this._sink);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        VirtualSavepoint vsp = (VirtualSavepoint)savepoint;
        this._sink.process(this._objectUid, new ConnectionRollbackWithSavepointCommand(vsp.getObjectUID().getUID()));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        VirtualSavepoint vsp = (VirtualSavepoint)savepoint;
        this._sink.process(this._objectUid, new ConnectionReleaseSavepointCommand(vsp.getObjectUID().getUID()));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object result = this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "createStatement", new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency), new Integer(resultSetHoldability)}, 24), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualStatement(reg, this, this._sink, resultSetType);
        }
        return (Statement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementCommand(sql, resultSetType, resultSetConcurrency, resultSetHoldability), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualPreparedStatement(reg, this, sql, this._sink, resultSetType);
        }
        return (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareCallCommand(sql, resultSetType, resultSetConcurrency, resultSetHoldability), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualCallableStatement(reg, this, sql, this._sink, resultSetType);
        }
        return (CallableStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementExtendedCommand(sql, autoGeneratedKeys), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualPreparedStatement(reg, this, sql, this._sink, 1003);
        }
        return (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementExtendedCommand(sql, columnIndexes), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualPreparedStatement(reg, this, sql, this._sink, 1003);
        }
        return (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        Object result = this._sink.process(this._objectUid, new ConnectionPrepareStatementExtendedCommand(sql, columnNames), true);
        if (result instanceof UIDEx) {
            UIDEx reg = (UIDEx)result;
            return new VirtualPreparedStatement(reg, this, sql, this._sink, 1003);
        }
        return (PreparedStatement)this.proxyFactory.makeJdbcObject(result);
    }

    @Override
    public Clob createClob() throws SQLException {
        return new SerialClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new SerialBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new SerialNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new SerialSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout <= 0) {
            throw new SQLException("invalid timeout value " + timeout);
        }
        ValidRunnable task = new ValidRunnable();
        Thread t = new Thread(task);
        long end = System.currentTimeMillis() + (long)timeout;
        long diff = timeout;
        t.start();
        while (!task.finished && diff > 0L) {
            try {
                Thread.sleep(diff);
            }
            catch (Exception e) {
                // empty catch block
            }
            diff = end - System.currentTimeMillis();
        }
        return !task.finished;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties clientProps = ClientInfo.getProperties(null);
        clientProps.put(name, value);
        try {
            this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "setClientInfo", new Object[]{name, value}, 14), true);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException sqle) {
            throw new SQLClientInfoException(null, (Throwable)sqle);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Properties clientProps = ClientInfo.getProperties(null);
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            this.setClientInfo(string, value);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        Properties clientProps = ClientInfo.getProperties(null);
        String value = clientProps.getProperty(name);
        if (value != null) {
            return value;
        }
        String ret = (String)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "getClientInfo", new Object[]{name}, 3), true);
        if (ret != null) {
            clientProps.setProperty(name, ret);
        }
        return ret;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties clientProps = ClientInfo.getProperties(null);
        if (clientProps != null && clientProps.size() > 1) {
            return clientProps;
        }
        Properties ret = (Properties)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(2, "getClientInfo"));
        for (String string : ret.keySet()) {
            String value = ret.getProperty(string);
            clientProps.setProperty(string, value);
        }
        return ret;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new SerialArray(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new SerialStruct(typeName, attributes);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(VirtualConnection.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    class ValidRunnable
    implements Runnable {
        public volatile boolean finished = false;

        ValidRunnable() {
        }

        @Override
        public void run() {
            try {
                VirtualConnection.this._sink.processWithBooleanResult(VirtualConnection.this._objectUid, CommandPool.getReflectiveCommand(2, "isValid"));
                this.finished = true;
            }
            catch (SQLException sqle) {
                _logger.info((Object)sqle.getMessage(), (Throwable)sqle);
            }
        }
    }
}

