/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase;

import com.pentaho.big.data.bundles.impl.shim.hbase.ByteConversionUtilImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.FilePathModifierUtil;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.ResultFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.mapping.ColumnFilterFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.mapping.MappingFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import java.io.IOException;
import java.util.Properties;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.ResultFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HBaseServiceImpl
implements HBaseService {
    private final NamedCluster namedCluster;
    private final HBaseShim hBaseShim;
    private final HBaseBytesUtilShim bytesUtil;
    private final String shimVersion;

    public HBaseServiceImpl(NamedCluster namedCluster, HadoopConfiguration hadoopConfiguration) throws ConfigurationException {
        this.namedCluster = namedCluster;
        this.hBaseShim = hadoopConfiguration.getHBaseShim();
        this.shimVersion = hadoopConfiguration.getIdentifier() != null ? hadoopConfiguration.getIdentifier() : "";
        try {
            this.bytesUtil = this.hBaseShim.getHBaseConnection().getBytesUtil();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public HBaseConnectionImpl getHBaseConnection(VariableSpace variableSpace, String siteConfig, String defaultConfig, LogChannelInterface logChannelInterface) throws IOException {
        Properties connProps = new Properties();
        String zooKeeperHost = null;
        String zooKeeperPort = null;
        if (this.namedCluster != null) {
            zooKeeperHost = variableSpace.environmentSubstitute(this.namedCluster.getZooKeeperHost());
            zooKeeperPort = variableSpace.environmentSubstitute(this.namedCluster.getZooKeeperPort());
        }
        if (!Const.isEmpty(zooKeeperHost)) {
            connProps.setProperty("hbase.zookeeper.quorum", zooKeeperHost);
        }
        if (!Const.isEmpty(zooKeeperPort)) {
            connProps.setProperty("hbase.zookeeper.property.clientPort", zooKeeperPort);
        }
        if (!Const.isEmpty((String)siteConfig)) {
            connProps.setProperty("hbase.site", FilePathModifierUtil.modifyPathToConfigFileIfNecessary(siteConfig));
        }
        if (!Const.isEmpty((String)defaultConfig)) {
            connProps.setProperty("hbase.default", FilePathModifierUtil.modifyPathToConfigFileIfNecessary(defaultConfig));
        }
        connProps.setProperty("ACTIVE_SHIM_VERSION", this.shimVersion);
        return new HBaseConnectionImpl(this, this.hBaseShim, this.bytesUtil, connProps, logChannelInterface);
    }

    public ColumnFilterFactoryImpl getColumnFilterFactory() {
        return new ColumnFilterFactoryImpl();
    }

    public MappingFactoryImpl getMappingFactory() {
        return new MappingFactoryImpl(this.bytesUtil, this.getHBaseValueMetaInterfaceFactory());
    }

    public HBaseValueMetaInterfaceFactoryImpl getHBaseValueMetaInterfaceFactory() {
        return new HBaseValueMetaInterfaceFactoryImpl(this.bytesUtil);
    }

    public ByteConversionUtil getByteConversionUtil() {
        return new ByteConversionUtilImpl(this.bytesUtil);
    }

    public ResultFactory getResultFactory() {
        return new ResultFactoryImpl(this.bytesUtil);
    }
}

