/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.DefaultSwagger2Serializers;
import org.apache.cxf.jaxrs.swagger.Swagger2Serializers;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class Swagger2Feature
extends AbstractSwaggerFeature {
    private String host;
    private String[] schemes;
    private boolean prettyPrint;
    private boolean scanAllResources;
    private String ignoreRoutes;
    private Swagger2Serializers swagger2Serializers;
    private boolean dynamicBasePath;

    @Override
    protected void calculateDefaultBasePath(Server server) {
        this.dynamicBasePath = true;
        super.calculateDefaultBasePath(server);
    }

    @Override
    protected void addSwaggerResource(Server server) {
        ApiListingResource apiListingResource = new ApiListingResource();
        JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        sfb.setResourceClassesFromBeans(Collections.singletonList(apiListingResource));
        List cris = sfb.getClassResourceInfo();
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.runAsFilter) {
            providers.add((Object)new SwaggerContainerRequestFilter());
        } else {
            for (ClassResourceInfo cri : cris) {
                if (ApiListingResource.class != cri.getResourceClass()) continue;
                InjectionUtils.injectContextProxies((AbstractResourceInfo)cri, (Object)apiListingResource);
            }
        }
        if (this.swagger2Serializers == null) {
            this.swagger2Serializers = new DefaultSwagger2Serializers();
        }
        this.swagger2Serializers.setClassResourceInfos(cris);
        this.swagger2Serializers.setDynamicBasePath(this.dynamicBasePath);
        providers.add(this.swagger2Serializers);
        providers.add(new ReaderConfigFilter());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setHost(this.getHost());
        beanConfig.setSchemes(this.getSchemes());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setTermsOfServiceUrl(this.getTermsOfServiceUrl());
        beanConfig.setScan(this.isScan());
        beanConfig.setPrettyPrint(this.isPrettyPrint());
        beanConfig.setFilterClass(this.getFilterClass());
        this.swagger2Serializers.setBeanConfig(beanConfig);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isScanAllResources() {
        return this.scanAllResources;
    }

    public void setScanAllResources(boolean scanAllResources) {
        this.scanAllResources = scanAllResources;
    }

    public String getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public void setIgnoreRoutes(String ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    public void setSwagger2Serializers(Swagger2Serializers swagger2Serializers) {
        this.swagger2Serializers = swagger2Serializers;
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            URI u = URI.create(address);
            this.setBasePath(u.getPath());
            this.setHost(u.getPort() < 0 ? u.getHost() : u.getHost() + ":" + u.getPort());
        } else {
            this.setBasePath(address);
        }
    }

    protected class ReaderConfigFilter
    implements ContainerRequestFilter {
        @Context
        protected MessageContext mc;

        protected ReaderConfigFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ServletContext servletContext = this.mc.getServletContext();
            if (servletContext != null && servletContext.getAttribute(ReaderConfig.class.getName()) == null) {
                if (this.mc.getServletConfig() != null && Boolean.valueOf(this.mc.getServletConfig().getInitParameter("scan.all.resources")).booleanValue()) {
                    this.addReaderConfig(this.mc.getServletConfig().getInitParameter("ignore.routes"));
                } else if (Swagger2Feature.this.isScanAllResources()) {
                    this.addReaderConfig(Swagger2Feature.this.getIgnoreRoutes());
                }
            }
        }

        protected void addReaderConfig(String ignoreRoutesParam) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            if (ignoreRoutesParam != null) {
                LinkedHashSet<String> routes = new LinkedHashSet<String>();
                for (String route : StringUtils.split((String)ignoreRoutesParam, (String)",")) {
                    routes.add(route.trim());
                }
                rc.setIgnoredRoutes(routes);
            }
            this.mc.getServletContext().setAttribute(ReaderConfig.class.getName(), (Object)rc);
        }
    }

    @PreMatching
    protected static class SwaggerContainerRequestFilter
    extends ApiListingResource
    implements ContainerRequestFilter {
        protected static final MediaType APPLICATION_YAML_TYPE = JAXRSUtils.toMediaType((String)"application/yaml");
        protected static final String APIDOCS_LISTING_PATH = "swagger";
        protected static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        protected static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        protected MessageContext mc;

        protected SwaggerContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            List mediaTypes = this.mc.getHttpHeaders().getAcceptableMediaTypes();
            Response response = null;
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH) && !JAXRSUtils.intersectMimeTypes((List)mediaTypes, (MediaType)MediaType.APPLICATION_JSON_TYPE).isEmpty() || ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                response = this.getListingJsonResponse(null, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH) && !JAXRSUtils.intersectMimeTypes((List)mediaTypes, (MediaType)APPLICATION_YAML_TYPE).isEmpty() || ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                response = this.getListingYamlResponse(null, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            }
            if (response != null) {
                requestContext.abortWith(response);
            }
        }
    }
}

