/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.proxy.spring4.security;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.proxy.spring4.security.UserDetailsImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.core.userdetails.memory.UserAttributeEditor;

public class UserDetailsServiceImpl
implements UserDetailsService {
    HashMap<String, UserDetailsImpl> userDetailsList = new HashMap();
    ITenantedPrincipleNameResolver tenantedPrincipleNameResolver;

    public UserDetailsServiceImpl(ITenantedPrincipleNameResolver tenantedPrincipleNameResolver, Map<String, String> userDefMap) {
        this.tenantedPrincipleNameResolver = tenantedPrincipleNameResolver;
        for (String username : userDefMap.keySet()) {
            UserAttributeEditor userAttributeEditor = new UserAttributeEditor();
            userAttributeEditor.setAsText(userDefMap.get(username));
            this.userDetailsList.put(username, new UserDetailsImpl(username, (UserAttribute)userAttributeEditor.getValue()));
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        String principalId = this.tenantedPrincipleNameResolver.getPrincipleName(username);
        if (this.userDetailsList.get(principalId) == null) {
            throw new UsernameNotFoundException("user not found");
        }
        return this.userDetailsList.get(principalId);
    }
}

