/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.ui.datasources.jdbc.Messages;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.ConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcPreviewWorker;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcQueryDesignerDialog;
import org.pentaho.reporting.ui.datasources.jdbc.ui.LimitRowsCheckBoxActionListener;
import org.pentaho.reporting.ui.datasources.jdbc.ui.NamedDataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.QueryLanguageListCellRenderer;
import org.pentaho.reporting.ui.datasources.jdbc.ui.SchemaSelectionDialog;

public class JdbcDataSourceDialog
extends CommonDialog {
    protected static final Log logger = LogFactory.getLog(JdbcDataSourceDialog.class);
    private JTextField queryNameTextField;
    private RSyntaxTextArea queryTextArea;
    private JList queryNameList;
    private NamedDataSourceDialogModel dialogModel;
    private JdbcConnectionPanel connectionComponent;
    private DesignTimeContext designTimeContext;
    private JSpinner maxPreviewRowsSpinner;
    private RSyntaxTextArea globalScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> globalLanguageField;
    private RSyntaxTextArea queryScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> queryLanguageField;
    private QueryLanguageListCellRenderer queryLanguageListCellRenderer;
    private GlobalTemplateAction globalTemplateAction;
    private QueryTemplateAction queryTemplateAction;

    public JdbcDataSourceDialog(DesignTimeContext designTimeContext) {
        this.initDialog(designTimeContext);
    }

    public JdbcDataSourceDialog(DesignTimeContext designTimeContext, JDialog parent) {
        super((Dialog)parent);
        this.initDialog(designTimeContext);
    }

    public JdbcDataSourceDialog(DesignTimeContext designTimeContext, JFrame parent) {
        super((Frame)parent);
        this.initDialog(designTimeContext);
    }

    public SQLReportDataFactory performConfiguration(SQLReportDataFactory dataFactory, String selectedQueryName) {
        this.dialogModel.clear();
        if (dataFactory != null) {
            DataSetQuery query;
            this.dialogModel.setJdbcPasswordField(dataFactory.getPasswordField());
            this.dialogModel.setJdbcUserField(dataFactory.getUserField());
            this.setGlobalScriptingLanguage(dataFactory.getGlobalScriptLanguage());
            this.globalScriptTextArea.setText(dataFactory.getGlobalScript());
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query2 = dataFactory.getQuery(queryName);
                String scriptLanguage = dataFactory.getScriptingLanguage(queryName);
                String script = dataFactory.getScript(queryName);
                this.dialogModel.addQuery(queryName, query2, scriptLanguage, script);
                this.queryNameList.setSelectedValue(queryName, true);
                this.queryNameList.setSelectedIndex(i);
            }
            ConnectionProvider currentConnectionProvider = dataFactory.getConnectionProvider();
            JdbcConnectionDefinition definition = this.connectionComponent.createConnectionDefinition(currentConnectionProvider);
            this.dialogModel.addConnection(definition);
            this.dialogModel.getConnections().setSelectedItem(definition);
            String selectedQuery = selectedQueryName;
            if (StringUtils.isEmpty((String)selectedQuery) && (query = this.dialogModel.getFirstQueryName()) != null) {
                selectedQuery = query.getQueryName();
            }
            if (!StringUtils.isEmpty((String)selectedQuery)) {
                this.dialogModel.setSelectedQuery(selectedQuery);
                this.queryNameList.setSelectedIndex(this.dialogModel.getQueries().getIndexForQuery(selectedQuery));
            }
        }
        if (!this.performEdit()) {
            return null;
        }
        JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)this.dialogModel.getConnections().getSelectedItem();
        if (connectionDefinition == null) {
            return null;
        }
        return this.createDataFactory(connectionDefinition);
    }

    private void setGlobalScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.globalLanguageField);
    }

    protected void setScriptingLanguage(String lang, JComboBox languageField) {
        if (lang == null) {
            languageField.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = languageField.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptEngineFactory elementAt = (ScriptEngineFactory)model.getElementAt(i);
            if (elementAt == null || !elementAt.getNames().contains(lang)) continue;
            languageField.setSelectedItem(elementAt);
            return;
        }
    }

    private String getGlobalScriptingLanguage() {
        ScriptEngineFactory selectedValue = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        if (selectedValue == null) {
            return null;
        }
        return selectedValue.getLanguageName();
    }

    private SQLReportDataFactory createDataFactory(JdbcConnectionDefinition connectionDefinition) {
        JndiConnectionProvider connectionProvider;
        JndiConnectionProvider provider;
        if (connectionDefinition instanceof JndiConnectionDefinition) {
            JndiConnectionDefinition jcd = (JndiConnectionDefinition)connectionDefinition;
            provider = new JndiConnectionProvider();
            provider.setConnectionPath(jcd.getJndiName());
            provider.setUsername(jcd.getUsername());
            provider.setPassword(jcd.getPassword());
            connectionProvider = provider;
        } else if (connectionDefinition instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition dcd = (DriverConnectionDefinition)connectionDefinition;
            provider = new DriverConnectionProvider();
            provider.setDriver(dcd.getDriverClass());
            provider.setUrl(dcd.getConnectionString());
            Properties properties = dcd.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                provider.setProperty(key, properties.getProperty(key));
            }
            connectionProvider = provider;
        } else {
            return null;
        }
        SQLReportDataFactory newDataFactory = new SQLReportDataFactory((ConnectionProvider)connectionProvider);
        newDataFactory.setPasswordField(this.dialogModel.getJdbcPasswordField());
        newDataFactory.setUserField(this.dialogModel.getJdbcUserField());
        newDataFactory.setGlobalScriptLanguage(this.getGlobalScriptingLanguage());
        if (!StringUtils.isEmpty((String)this.globalScriptTextArea.getText())) {
            newDataFactory.setGlobalScript(this.globalScriptTextArea.getText());
        }
        DataSetComboBoxModel<String> queries = this.dialogModel.getQueries();
        for (int i = 0; i < queries.getSize(); ++i) {
            DataSetQuery query = queries.getQuery(i);
            newDataFactory.setQuery(query.getQueryName(), (String)query.getQuery(), query.getScriptLanguage(), query.getScript());
        }
        return newDataFactory;
    }

    private void initDialog(DesignTimeContext designTimeContext) {
        this.designTimeContext = designTimeContext;
        this.setTitle(Messages.getString("JdbcDataSourceDialog.Title", new Object[0]));
        this.setModal(true);
        this.globalTemplateAction = new GlobalTemplateAction();
        this.queryTemplateAction = new QueryTemplateAction();
        this.dialogModel = new NamedDataSourceDialogModel();
        this.dialogModel.addPropertyChangeListener(new ConfirmValidationHandler());
        this.connectionComponent = new JdbcConnectionPanel(this.dialogModel, designTimeContext);
        this.maxPreviewRowsSpinner = new JSpinner(new SpinnerNumberModel(10000, 1, Integer.MAX_VALUE, 1));
        QueryNameTextFieldDocumentListener updateHandler = new QueryNameTextFieldDocumentListener();
        this.dialogModel.getQueries().addListDataListener((ListDataListener)updateHandler);
        this.queryNameList = new JList<String>((ListModel<String>)this.dialogModel.getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QuerySelectedHandler());
        this.queryNameTextField = new JTextField();
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.setEnabled(this.dialogModel.isQuerySelected());
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)updateHandler));
        this.queryTextArea = new RSyntaxTextArea();
        this.queryTextArea.setSyntaxEditingStyle("text/sql");
        this.queryTextArea.setEnabled(this.dialogModel.isQuerySelected());
        this.queryTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryDocumentListener()));
        this.globalScriptTextArea = new RSyntaxTextArea();
        this.globalScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.globalLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.globalLanguageField.setRenderer((ListCellRenderer)new QueryLanguageListCellRenderer());
        this.globalLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        this.queryScriptTextArea = new RSyntaxTextArea();
        this.queryScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.queryScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryScriptDocumentListener()));
        this.queryLanguageListCellRenderer = new QueryLanguageListCellRenderer();
        this.queryLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.queryLanguageField.setRenderer((ListCellRenderer)this.queryLanguageListCellRenderer);
        this.queryLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        super.init();
    }

    protected String getDialogId() {
        return "JdbcDataSourceEditor";
    }

    private void updateComponents() {
        ScriptEngineFactory globalLanguage = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        this.globalScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)globalLanguage));
        this.queryLanguageListCellRenderer.setDefaultValue(globalLanguage);
        ScriptEngineFactory queryScriptLanguage = (ScriptEngineFactory)this.queryLanguageField.getSelectedItem();
        if (queryScriptLanguage == null) {
            this.queryScriptTextArea.setSyntaxEditingStyle(this.globalScriptTextArea.getSyntaxEditingStyle());
        } else {
            this.queryScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)queryScriptLanguage));
        }
        boolean querySelected = this.dialogModel.isQuerySelected();
        this.queryScriptTextArea.setEnabled(querySelected);
        this.queryLanguageField.setEnabled(querySelected);
        this.queryTemplateAction.update();
        if (!querySelected) {
            this.queryTemplateAction.setEnabled(false);
        }
        this.globalTemplateAction.update();
    }

    private JPanel createQueryScriptTab() {
        JPanel queryHeader2 = new JPanel(new BorderLayout());
        queryHeader2.add((Component)new JLabel(Messages.getString("JdbcDataSourceDialog.QueryScript", new Object[0])), "Center");
        queryHeader2.add((Component)new JButton(this.queryTemplateAction), "East");
        JPanel queryScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        queryScriptHeader.add(new JLabel(Messages.getString("JdbcDataSourceDialog.QueryScriptLanguage", new Object[0])));
        queryScriptHeader.add((Component)this.queryLanguageField);
        queryScriptHeader.add(queryHeader2);
        JPanel queryScriptContentHolder = new JPanel(new BorderLayout());
        queryScriptContentHolder.add((Component)queryScriptHeader, "North");
        queryScriptContentHolder.add((Component)new RTextScrollPane(700, 300, (RTextArea)this.queryScriptTextArea, true), "Center");
        return queryScriptContentHolder;
    }

    private JPanel createGlobalScriptTab() {
        JPanel globalHeader2 = new JPanel(new BorderLayout());
        globalHeader2.add((Component)new JLabel(Messages.getString("JdbcDataSourceDialog.GlobalScript", new Object[0])), "Center");
        globalHeader2.add((Component)new JButton(this.globalTemplateAction), "East");
        JPanel globalScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        globalScriptHeader.add(new JLabel(Messages.getString("JdbcDataSourceDialog.GlobalScriptLanguage", new Object[0])));
        globalScriptHeader.add((Component)this.globalLanguageField);
        globalScriptHeader.add(globalHeader2);
        JPanel globalScriptContentHolder = new JPanel(new BorderLayout());
        globalScriptContentHolder.add((Component)globalScriptHeader, "North");
        globalScriptContentHolder.add((Component)new RTextScrollPane(700, 600, (RTextArea)this.globalScriptTextArea, true), "Center");
        return globalScriptContentHolder;
    }

    protected Component createContentPane() {
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", this.createQueryDetailsPanel());
        JPanel dialogContent = new JPanel(new BorderLayout());
        dialogContent.add("West", this.connectionComponent);
        dialogContent.add("Center", queryContentPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("JdbcDataSourceDialog.DataSource", new Object[0]), dialogContent);
        tabbedPane.addTab(Messages.getString("JdbcDataSourceDialog.GlobalScripting", new Object[0]), this.createGlobalScriptTab());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add("South", this.createPreviewButtonsPanel());
        contentPane.add("Center", tabbedPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPane;
    }

    private JPanel createPreviewButtonsPanel() {
        JPanel previewButtonsPanel = new JPanel(new FlowLayout(2));
        previewButtonsPanel.add(new JCheckBox(new LimitRowsCheckBoxActionListener(this.maxPreviewRowsSpinner)));
        previewButtonsPanel.add(this.maxPreviewRowsSpinner);
        PreviewAction thePreviewAction = new PreviewAction();
        this.dialogModel.addPropertyChangeListener(thePreviewAction);
        previewButtonsPanel.add(new JButton(thePreviewAction));
        return previewButtonsPanel;
    }

    private JPanel createQueryDetailsPanel() {
        JPanel queryNamePanel = new JPanel(new BorderLayout());
        queryNamePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        queryNamePanel.add((Component)new JLabel(Messages.getString("JdbcDataSourceDialog.QueryStringLabel", new Object[0])), "North");
        queryNamePanel.add((Component)this.queryNameTextField, "South");
        InvokeQueryDesignerAction queryDesignerAction = new InvokeQueryDesignerAction();
        this.dialogModel.addPropertyChangeListener(queryDesignerAction);
        JPanel queryButtonsPanel = new JPanel(new FlowLayout(2, 5, 5));
        queryButtonsPanel.add((Component)new BorderlessButton((Action)queryDesignerAction));
        JPanel queryControlsPanel = new JPanel(new BorderLayout());
        queryControlsPanel.add((Component)new JLabel(Messages.getString("JdbcDataSourceDialog.QueryDetailsLabel", new Object[0])), "West");
        queryControlsPanel.add((Component)queryButtonsPanel, "East");
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.add((Component)queryControlsPanel, "North");
        queryPanel.add((Component)new RTextScrollPane(500, 300, (RTextArea)this.queryTextArea, true), "Center");
        queryPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        JTabbedPane queryScriptTabPane = new JTabbedPane();
        queryScriptTabPane.addTab(Messages.getString("JdbcDataSourceDialog.StaticQuery", new Object[0]), queryPanel);
        queryScriptTabPane.addTab(Messages.getString("JdbcDataSourceDialog.QueryScripting", new Object[0]), this.createQueryScriptTab());
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.add("North", queryNamePanel);
        queryDetailsPanel.add("Center", queryScriptTabPane);
        return queryDetailsPanel;
    }

    private JPanel createQueryListPanel() {
        QueryRemoveAction queryRemoveAction = new QueryRemoveAction();
        this.dialogModel.addPropertyChangeListener(queryRemoveAction);
        JPanel theQueryButtonsPanel = new JPanel(new FlowLayout(2, 5, 5));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction()));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)queryRemoveAction));
        JPanel theQueryControlsPanel = new JPanel(new BorderLayout());
        theQueryControlsPanel.add((Component)new JLabel(Messages.getString("JdbcDataSourceDialog.AvailableQueries", new Object[0])), "West");
        theQueryControlsPanel.add((Component)theQueryButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", theQueryControlsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    protected NamedDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected String getQueryName() {
        return this.queryNameTextField.getText();
    }

    protected void setQueryName(String queryName) {
        this.queryNameTextField.setText(queryName);
    }

    protected boolean validateInputs(boolean onConfirm) {
        NamedDataSourceDialogModel dialogModel = this.getDialogModel();
        return dialogModel.isConnectionSelected();
    }

    private class QueryScriptDocumentListener
    extends DocumentChangeHandler {
        private QueryScriptDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            DataSetQuery query = JdbcDataSourceDialog.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                String text = JdbcDataSourceDialog.this.queryScriptTextArea.getText();
                query.setScript(text);
            }
        }
    }

    private class UpdateScriptLanguageHandler
    implements ActionListener,
    ListSelectionListener {
        private UpdateScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = JdbcDataSourceDialog.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                ScriptEngineFactory selectedItem = (ScriptEngineFactory)JdbcDataSourceDialog.this.queryLanguageField.getSelectedItem();
                if (selectedItem != null) {
                    query.setScriptLanguage(selectedItem.getLanguageName());
                } else {
                    query.setScriptLanguage(null);
                }
            }
            JdbcDataSourceDialog.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JdbcDataSourceDialog.this.updateComponents();
        }
    }

    private class QueryTemplateAction
    extends AbstractAction {
        private URL resource;

        private QueryTemplateAction() {
            this.putValue("Name", Messages.getString("JdbcDataSourceDialog.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)JdbcDataSourceDialog.this.queryScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)JdbcDataSourceDialog.this), Messages.getString("JdbcDataSourceDialog.OverwriteScript", new Object[0]), Messages.getString("JdbcDataSourceDialog.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try (InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");){
                StringWriter w = new StringWriter();
                IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                JdbcDataSourceDialog.this.queryScriptTextArea.insert(w.toString(), 0);
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = JdbcDataSourceDialog.this.queryScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = JdbcDataSourceDialog.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/query-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class GlobalTemplateAction
    extends AbstractAction {
        private URL resource;

        private GlobalTemplateAction() {
            this.putValue("Name", Messages.getString("JdbcDataSourceDialog.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)JdbcDataSourceDialog.this.globalScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)JdbcDataSourceDialog.this), Messages.getString("JdbcDataSourceDialog.OverwriteScript", new Object[0]), Messages.getString("JdbcDataSourceDialog.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try (InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");){
                StringWriter w = new StringWriter();
                IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                JdbcDataSourceDialog.this.globalScriptTextArea.setText(w.toString());
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = JdbcDataSourceDialog.this.globalScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = JdbcDataSourceDialog.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/global-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class QueryDocumentListener
    extends DocumentChangeHandler {
        private QueryDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            DataSetQuery item = dialogModel.getQueries().getSelectedQuery();
            if (item == null) {
                return;
            }
            item.setQuery((Object)JdbcDataSourceDialog.this.queryTextArea.getText());
            dialogModel.getQueries().fireItemChanged((Object)item);
        }
    }

    private class QueryNameTextFieldDocumentListener
    extends DocumentChangeHandler
    implements ListDataListener {
        private boolean inUpdate;

        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (this.inUpdate) {
                return;
            }
            if (e.getIndex0() != -1) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            try {
                this.inUpdate = true;
                DataSetQuery selectedQuery = dialogModel.getQueries().getSelectedQuery();
                if (selectedQuery == null) {
                    JdbcDataSourceDialog.this.setQueryName(null);
                    JdbcDataSourceDialog.this.queryTextArea.setText(null);
                    JdbcDataSourceDialog.this.queryTextArea.setEnabled(false);
                    JdbcDataSourceDialog.this.queryLanguageField.setSelectedItem(null);
                    JdbcDataSourceDialog.this.queryScriptTextArea.setText(null);
                    return;
                }
                JdbcDataSourceDialog.this.setQueryName(selectedQuery.getQueryName());
                JdbcDataSourceDialog.this.setEnabled(true);
                JdbcDataSourceDialog.this.queryTextArea.setText((String)selectedQuery.getQuery());
                JdbcDataSourceDialog.this.queryScriptTextArea.setText(selectedQuery.getScript());
                JdbcDataSourceDialog.this.setScriptingLanguage(selectedQuery.getScriptLanguage(), (JComboBox)JdbcDataSourceDialog.this.queryLanguageField);
            }
            finally {
                this.inUpdate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleChange(DocumentEvent e) {
            if (this.inUpdate) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            DataSetQuery item = dialogModel.getQueries().getSelectedQuery();
            if (item == null) {
                return;
            }
            try {
                this.inUpdate = true;
                item.setQueryName(JdbcDataSourceDialog.this.getQueryName());
                dialogModel.getQueries().fireItemChanged((Object)item);
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    private class QueryRemoveAction
    extends AbstractAction
    implements PropertyChangeListener {
        private QueryRemoveAction() {
            URL resource = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("JdbcDataSourceDialog.Remove.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("JdbcDataSourceDialog.Remove.Description", new Object[0]));
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.setEnabled(dialogModel.isQuerySelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.setEnabled(dialogModel.isQuerySelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            DataSetComboBoxModel<String> queries = dialogModel.getQueries();
            queries.removeElement(queries.getSelectedItem());
            if (JdbcDataSourceDialog.this.queryNameList.getLastVisibleIndex() != -1) {
                JdbcDataSourceDialog.this.queryNameList.setSelectedValue(dialogModel.getQueries().getQuery(JdbcDataSourceDialog.this.queryNameList.getLastVisibleIndex()), true);
                JdbcDataSourceDialog.this.queryNameList.setSelectedIndex(JdbcDataSourceDialog.this.queryNameList.getLastVisibleIndex());
                queries.setSelectedItem(dialogModel.getQueries().getQuery(JdbcDataSourceDialog.this.queryNameList.getLastVisibleIndex()));
                JdbcDataSourceDialog.this.queryTextArea.setEnabled(true);
            } else {
                queries.setSelectedItem(null);
                JdbcDataSourceDialog.this.queryNameList.clearSelection();
                JdbcDataSourceDialog.this.queryTextArea.setEnabled(false);
            }
        }
    }

    private class QueryAddAction
    extends AbstractAction {
        private QueryAddAction() {
            URL location = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Add.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getString("JdbcDataSourceDialog.Add.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("JdbcDataSourceDialog.Add.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = JdbcDataSourceDialog.this.dialogModel.generateQueryName();
            JdbcDataSourceDialog.this.dialogModel.addQuery(queryName, "", null, null);
            JdbcDataSourceDialog.this.queryNameList.setSelectedValue(queryName, true);
            JdbcDataSourceDialog.this.queryNameList.setSelectedIndex(JdbcDataSourceDialog.this.queryNameList.getLastVisibleIndex());
        }
    }

    private class ConfirmValidationHandler
    implements PropertyChangeListener {
        private ConfirmValidationHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JdbcDataSourceDialog.this.validateInputs(false);
        }
    }

    private class QuerySelectedHandler
    implements ListSelectionListener {
        private QuerySelectedHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JdbcDataSourceDialog.this.getDialogModel().getQueries().setSelectedItem(JdbcDataSourceDialog.this.queryNameList.getSelectedValue());
            boolean querySelected = JdbcDataSourceDialog.this.queryNameList.getSelectedIndex() != -1;
            JdbcDataSourceDialog.this.queryNameTextField.setEnabled(querySelected);
            JdbcDataSourceDialog.this.queryTextArea.setEnabled(JdbcDataSourceDialog.this.dialogModel.isQuerySelected());
            JdbcDataSourceDialog.this.queryScriptTextArea.setEnabled(JdbcDataSourceDialog.this.dialogModel.isQuerySelected());
            JdbcDataSourceDialog.this.queryLanguageField.setEnabled(JdbcDataSourceDialog.this.dialogModel.isQuerySelected());
        }
    }

    private class InvokeQueryDesignerAction
    extends AbstractAction
    implements PropertyChangeListener {
        private InvokeQueryDesignerAction() {
            URL location = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Edit.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            }
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.enable(dialogModel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.enable(dialogModel);
        }

        private void enable(NamedDataSourceDialogModel dialogModel) {
            boolean enable = true;
            if (!dialogModel.isConnectionSelected() || !dialogModel.isQuerySelected()) {
                enable = false;
            } else {
                DriverConnectionDefinition dcd;
                Object connection = dialogModel.getConnections().getSelectedItem();
                if (connection instanceof DriverConnectionDefinition && (dcd = (DriverConnectionDefinition)connection).getDatabaseType() != null && dcd.getDatabaseType().equalsIgnoreCase("HIVE")) {
                    enable = false;
                }
            }
            this.setEnabled(enable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)dialogModel.getConnections().getSelectedItem();
            if (connectionDefinition == null) {
                return;
            }
            Connection conn = null;
            try {
                SQLReportDataFactory factory = JdbcDataSourceDialog.this.createDataFactory(connectionDefinition);
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)factory, (DesignTimeContext)JdbcDataSourceDialog.this.designTimeContext);
                conn = factory.getConnectionProvider().createConnection(null, null);
                if (conn == null) {
                    JOptionPane.showMessageDialog((Component)((Object)JdbcDataSourceDialog.this), Messages.getString("JdbcDataSourceDialog.InvokeQueryDesignerError", new Object[0]), Messages.getString("JdbcDataSourceDialog.InvokeQueryDesignerError.Title", new Object[0]), 0);
                    return;
                }
                String schema = this.performQuerySchema(conn);
                QueryBuilder queryBuilder = new QueryBuilder(conn);
                QueryBuilder.autoAlias = false;
                JdbcQueryDesignerDialog queryDesigner = new JdbcQueryDesignerDialog((JDialog)((Object)JdbcDataSourceDialog.this), queryBuilder);
                String query = queryDesigner.designQuery(JdbcDataSourceDialog.this.designTimeContext, factory.getConnectionProvider(), schema, JdbcDataSourceDialog.this.queryTextArea.getText());
                if (query != null) {
                    JdbcDataSourceDialog.this.queryTextArea.setText(query);
                }
            }
            catch (Exception e1) {
                logger.warn((Object)"Invoking the query designer failed", (Throwable)e1);
                ExceptionDialog.showExceptionDialog((Component)((Object)JdbcDataSourceDialog.this), (String)Messages.getString("JdbcDataSourceDialog.QueryDesignerFailed.Title", new Object[0]), (String)Messages.getString("JdbcDataSourceDialog.QueryDesignerFailed.Message", new Object[0]), (Exception)e1);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqle) {
                        logger.warn((Object)"Could not close database connection", (Throwable)sqle);
                    }
                }
            }
        }

        private String performQuerySchema(Connection conn) {
            String schema = null;
            try {
                DatabaseMetaData data = conn.getMetaData();
                boolean isHsql = "HSQL Database Engine".equals(data.getDatabaseProductName());
                if (data.supportsSchemasInTableDefinitions()) {
                    LinkedMap schemas = new LinkedMap();
                    ResultSet rs = data.getSchemas();
                    while (rs.next()) {
                        String schemaName = rs.getString(1).trim();
                        if (isHsql && "INFORMATION_SCHEMA".equals(schemaName)) continue;
                        schemas.put((Object)schemaName, (Object)Boolean.TRUE);
                    }
                    rs.close();
                    String[] schemasArray = (String[])schemas.keys((Object[])new String[schemas.size()]);
                    if (schemas.size() > 1) {
                        Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/ui/datasources/jdbc/Settings");
                        if (properties.getBoolean("show-schema-dialog", false)) {
                            SchemaSelectionDialog schemaSelectionDialog = new SchemaSelectionDialog((JDialog)((Object)JdbcDataSourceDialog.this), schemasArray);
                            schema = schemaSelectionDialog.getSchema();
                        }
                    } else if (schemas.size() == 1) {
                        schema = schemasArray[0];
                    }
                }
            }
            catch (Exception ex) {
                logger.warn((Object)"Error on InvokeQueryDesignerAction.performQuerySchema()", (Throwable)ex);
            }
            return schema;
        }
    }

    private class PreviewAction
    extends AbstractAction
    implements PropertyChangeListener {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("JdbcDataSourceDialog.Preview", new Object[0]));
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.setEnabled(dialogModel.isConnectionSelected() && dialogModel.isQuerySelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
            this.setEnabled(dialogModel.isConnectionSelected() && dialogModel.isQuerySelected());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block7: {
                NamedDataSourceDialogModel dialogModel = JdbcDataSourceDialog.this.getDialogModel();
                JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)dialogModel.getConnections().getSelectedItem();
                if (connectionDefinition == null) {
                    return;
                }
                try {
                    String query = JdbcDataSourceDialog.this.getQueryName();
                    DataPreviewDialog dialog = new DataPreviewDialog((Dialog)((Object)JdbcDataSourceDialog.this));
                    Integer maxRows = 0;
                    if (JdbcDataSourceDialog.this.maxPreviewRowsSpinner.isEnabled()) {
                        maxRows = (Integer)JdbcDataSourceDialog.this.maxPreviewRowsSpinner.getValue();
                    }
                    if (maxRows == null) {
                        maxRows = 0;
                    }
                    SQLReportDataFactory dataFactory = JdbcDataSourceDialog.this.createDataFactory(connectionDefinition);
                    DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)JdbcDataSourceDialog.this.designTimeContext);
                    MasterReport report = (MasterReport)JdbcDataSourceDialog.this.designTimeContext.getReport();
                    ReportParameterDefinition parameters = null;
                    if (report != null) {
                        parameters = report.getParameterDefinition();
                    }
                    JdbcPreviewWorker previewWorker = new JdbcPreviewWorker((DataFactory)dataFactory, query, 0, maxRows, parameters);
                    dialog.showData((PreviewWorker)previewWorker);
                    ReportDataFactoryException theException = previewWorker.getException();
                    if (theException != null) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)JdbcDataSourceDialog.this), (String)Messages.getString("PreviewDialog.PreviewError.Title", new Object[0]), (String)Messages.getString("PreviewDialog.PreviewError.Message", new Object[0]), (Exception)((Object)theException));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Preview failed:", (Throwable)e);
                    if (JdbcDataSourceDialog.this.designTimeContext == null) break block7;
                    JdbcDataSourceDialog.this.designTimeContext.userError(e);
                }
            }
        }
    }
}

