/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.ConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcSecurityDialog;

public class JdbcConnectionPanel
extends ConnectionPanel {
    private JdbcSecurityDialog securityDialog;

    public JdbcConnectionPanel(DataSourceDialogModel aDialogModel, DesignTimeContext designTimeContext) {
        super(aDialogModel, designTimeContext);
        this.initPanel();
    }

    @Override
    protected Action createEditSecurityAction() {
        return new EditSecurityAction();
    }

    public JdbcConnectionDefinition createConnectionDefinition(ConnectionProvider currentJNDISource) {
        DataSourceDialogModel dialogModel = this.getDialogModel();
        if (currentJNDISource instanceof DriverConnectionProvider) {
            DriverConnectionProvider dcp = (DriverConnectionProvider)currentJNDISource;
            DefaultComboBoxModel model = dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                DriverConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof DriverConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (DriverConnectionDefinition)definition).getDriverClass(), (Object)dcp.getDriver()) || !ObjectUtilities.equal((Object)dcd.getUsername(), (Object)dcp.getProperty("user")) || !ObjectUtilities.equal((Object)dcd.getPassword(), (Object)dcp.getProperty("password")) || !ObjectUtilities.equal((Object)dcd.getConnectionString(), (Object)dcp.getUrl()) || !ObjectUtilities.equal((Object)dcd.getName(), (Object)dcp.getProperty("::pentaho-reporting::name"))) continue;
                return definition;
            }
            String customName = dcp.getProperty("::pentaho-reporting::name");
            if (customName == null) {
                customName = this.getBundleSupport().getString("JdbcConnectionPanel.CustomConnection");
            }
            String[] strings = dcp.getPropertyNames();
            Properties p = new Properties();
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                p.put(string, dcp.getProperty(string));
            }
            return new DriverConnectionDefinition(customName, dcp.getDriver(), dcp.getUrl(), dcp.getProperty("user"), dcp.getProperty("password"), dcp.getProperty("::pentaho-reporting::hostname"), dcp.getProperty("::pentaho-reporting::database-name"), dcp.getProperty("::pentaho-reporting::database-type"), dcp.getProperty("::pentaho-reporting::port"), p);
        }
        if (currentJNDISource instanceof JndiConnectionProvider) {
            JndiConnectionProvider jcp = (JndiConnectionProvider)currentJNDISource;
            DefaultComboBoxModel model = dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                JndiConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof JndiConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (JndiConnectionDefinition)definition).getJndiName(), (Object)jcp.getConnectionPath())) continue;
                return dcd;
            }
            return new JndiConnectionDefinition(this.getBundleSupport().getString("JdbcConnectionPanel.CustomConnection"), jcp.getConnectionPath(), null, jcp.getUsername(), jcp.getPassword());
        }
        return null;
    }

    private class EditSecurityAction
    extends AbstractAction {
        private EditSecurityAction() {
            this.putValue("Name", JdbcConnectionPanel.this.getBundleSupport().getString("ConnectionPanel.EditSecurityAction.Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTimeContext designTimeContext = JdbcConnectionPanel.this.getDesignTimeContext();
            DataSourceDialogModel dialogModel = JdbcConnectionPanel.this.getDialogModel();
            if (JdbcConnectionPanel.this.securityDialog == null) {
                Window window = LibSwingUtil.getWindowAncestor((Component)JdbcConnectionPanel.this);
                if (window instanceof Frame) {
                    JdbcConnectionPanel.this.securityDialog = new JdbcSecurityDialog((Frame)window, designTimeContext);
                } else if (window instanceof Dialog) {
                    JdbcConnectionPanel.this.securityDialog = new JdbcSecurityDialog((Dialog)window, designTimeContext);
                } else {
                    JdbcConnectionPanel.this.securityDialog = new JdbcSecurityDialog(designTimeContext);
                }
            }
            JdbcConnectionPanel.this.securityDialog.setJdbcPasswordField(dialogModel.getJdbcPasswordField());
            JdbcConnectionPanel.this.securityDialog.setJdbcUserField(dialogModel.getJdbcUserField());
            if (JdbcConnectionPanel.this.securityDialog.performEdit()) {
                dialogModel.setJdbcUserField(JdbcConnectionPanel.this.securityDialog.getJdbcUserField());
                dialogModel.setJdbcPasswordField(JdbcConnectionPanel.this.securityDialog.getJdbcPasswordField());
            }
        }
    }
}

