/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc;

import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.GenericDatabaseMeta;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class DatabaseMapping {
    private DatabaseMapping() {
    }

    public static DatabaseInterface getMappingForDriver(String driverClass) {
        if (driverClass == null || driverClass.length() == 0) {
            return DatabaseMapping.getGenericInterface();
        }
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        String mappedInstance = configuration.getConfigProperty("org.pentaho.reporting.ui.datasources.jdbc.driver-mapping." + driverClass);
        DatabaseInterface[] interfaces = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            DatabaseInterface databaseInterface = interfaces[i];
            if (!databaseInterface.getClass().getName().equals(mappedInstance)) continue;
            return databaseInterface;
        }
        return DatabaseMapping.mapTypeFromDriver(driverClass);
    }

    public static DatabaseInterface getGenericInterface() {
        DatabaseInterface[] interfaces = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            DatabaseInterface anInterface = interfaces[i];
            if (!"GENERIC".equals(anInterface.getPluginId())) continue;
            return anInterface;
        }
        return null;
    }

    private static DatabaseInterface mapTypeFromDriver(String driverClass) {
        if (driverClass == null) {
            return new GenericDatabaseMeta();
        }
        DatabaseInterface[] interfaces = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            DatabaseInterface dbi = interfaces[i];
            int[] accessTypeList = dbi.getAccessTypeList();
            for (int j = 0; j < accessTypeList.length; ++j) {
                int al = accessTypeList[j];
                if (al == 1) continue;
                dbi.setAccessType(al);
                if (!driverClass.equals(dbi.getDriverClass())) continue;
                return dbi;
            }
        }
        return new GenericDatabaseMeta();
    }
}

