/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobsToBeMaterializedJPAExecutor
implements JPAExecutor<List<CoordinatorJobBean>> {
    private Date dateInput;
    private int limit;
    private List<CoordinatorJobBean> jobList;

    public CoordJobsToBeMaterializedJPAExecutor(Date date, int limit) {
        ParamChecker.notNull(date, "Coord Job Materialization Date");
        this.dateInput = date;
        this.limit = limit;
        this.jobList = new ArrayList<CoordinatorJobBean>();
    }

    @Override
    public List<CoordinatorJobBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_JOBS_OLDER_THAN");
            q.setParameter("matTime", (Object)new Timestamp(this.dateInput.getTime()));
            if (this.limit > 0) {
                q.setMaxResults(this.limit);
            }
            List cjBeans = q.getResultList();
            for (CoordinatorJobBean j : cjBeans) {
                this.jobList.add(j);
            }
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
        return this.jobList;
    }

    @Override
    public String getName() {
        return "CoordJobsToBeMaterializedJPAExecutor";
    }

    public Date getDateInput() {
        return this.dateInput;
    }

    public void setDateInput(Date dateInput) {
        this.dateInput = dateInput;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

