/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.NodeHandler;

public class ReRunCommand
extends WorkflowCommand<Void> {
    private String jobId;
    private Configuration conf;
    private String authToken;
    private Set<String> nodesToSkip = new HashSet<String>();
    public static final String TO_SKIP = "TO_SKIP";
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();

    public ReRunCommand(String jobId, Configuration conf, String authToken) {
        super("rerun", "rerun", 1, 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.conf = ParamChecker.notNull(conf, "conf");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    private void checkPreConditions(WorkflowJobBean wfBean, List<WorkflowActionBean> actions) throws CommandException {
        if (!(wfBean.getStatus().equals((Object)WorkflowJob.Status.FAILED) || wfBean.getStatus().equals((Object)WorkflowJob.Status.KILLED) || wfBean.getStatus().equals((Object)WorkflowJob.Status.SUCCEEDED))) {
            throw new CommandException(ErrorCode.E0805, wfBean.getStatus());
        }
        HashSet<String> unmachedNodes = new HashSet<String>(this.nodesToSkip);
        for (WorkflowActionBean action : actions) {
            if (!this.nodesToSkip.contains(action.getName())) continue;
            if (!action.getStatus().equals((Object)WorkflowAction.Status.OK) && !action.getStatus().equals((Object)WorkflowAction.Status.ERROR)) {
                throw new CommandException(ErrorCode.E0806, action.getName());
            }
            unmachedNodes.remove(action.getName());
        }
        if (unmachedNodes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String s : unmachedNodes) {
                sb.append(separator).append(s);
                separator = ",";
            }
            throw new CommandException(ErrorCode.E0807, sb);
        }
    }

    private void parseSkippedNodeConf() {
        if (this.conf != null) {
            Collection skipNodes = this.conf.getStringCollection("oozie.wf.rerun.skip.nodes");
            for (String str : skipNodes) {
                this.nodesToSkip.add(str.trim());
            }
        }
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        WorkflowInstance newWfInstance;
        this.incrJobCounter(1);
        WorkflowJobBean wfBean = store.getWorkflow(this.jobId, false);
        this.setLogInfo(wfBean);
        List<WorkflowActionBean> actions = store.getActionsForWorkflow(this.jobId, false);
        WorkflowInstance oldWfInstance = wfBean.getWorkflowInstance();
        XLog log = XLog.getLog(this.getClass());
        this.parseSkippedNodeConf();
        this.checkPreConditions(wfBean, actions);
        WorkflowAppService wps = Services.get().get(WorkflowAppService.class);
        try {
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            WorkflowApp app = wps.parseDef(this.conf, this.authToken);
            XConfiguration protoActionConf = wps.createProtoActionConf(this.conf, this.authToken, true);
            WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
            Path configDefault = new Path(new Path(this.conf.get("oozie.wf.application.path")).getParent(), "config-default.xml");
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(wfBean.getUser(), wfBean.getGroup(), configDefault.toUri(), protoActionConf);
            if (fs.exists(configDefault)) {
                XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                XConfiguration.injectDefaults(defaultConf, this.conf);
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            try {
                newWfInstance = workflowLib.createInstance(app, this.conf, this.jobId);
            }
            catch (WorkflowException e) {
                throw new StoreException(e);
            }
            wfBean.setAppName(app.getName());
            wfBean.setProtoActionConf(protoActionConf.toXmlString());
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (IOException ex) {
            throw new CommandException(ErrorCode.E0803, ex);
        }
        catch (HadoopAccessorException e) {
            throw new CommandException(e);
        }
        for (int i = 0; i < actions.size(); ++i) {
            if (!this.nodesToSkip.contains(actions.get(i).getName())) {
                store.deleteAction(actions.get(i).getId());
                log.info("Deleting Action[{0}] for re-run", actions.get(i).getId());
                continue;
            }
            this.copyActionData(newWfInstance, oldWfInstance);
        }
        wfBean.setAppPath(this.conf.get("oozie.wf.application.path"));
        wfBean.setConf(XmlUtils.prettyPrint(this.conf).toString());
        wfBean.setLogToken(this.conf.get("oozie.wf.log.token", ""));
        wfBean.setUser(this.conf.get("user.name"));
        wfBean.setGroup(this.conf.get("group.name"));
        wfBean.setExternalId(this.conf.get("oozie.wf.external.id"));
        wfBean.setEndTime(null);
        wfBean.setRun(wfBean.getRun() + 1);
        wfBean.setStatus(WorkflowJob.Status.PREP);
        wfBean.setWorkflowInstance(newWfInstance);
        store.updateWorkflow(wfBean);
        return null;
    }

    private void copyActionData(WorkflowInstance newWfInstance, WorkflowInstance oldWfInstance) {
        Map<Object, Object> oldVars = new HashMap();
        HashMap<String, String> newVars = new HashMap<String, String>();
        oldVars = oldWfInstance.getAllVars();
        for (String string : oldVars.keySet()) {
            String actionName = string.split("#")[0];
            if (!this.nodesToSkip.contains(actionName)) continue;
            newVars.put(string, (String)oldVars.get(string));
        }
        for (String string : this.nodesToSkip) {
            newVars.put(string + "#" + TO_SKIP, "true");
            String visitedFlag = NodeHandler.getLoopFlag(string);
            if (!newVars.containsKey(visitedFlag)) continue;
            newVars.remove(visitedFlag);
        }
        newWfInstance.setAllVars(newVars);
    }

    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        try {
            XLog.getLog(this.getClass()).debug("STARTED ReRunCommand for job " + this.jobId);
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new ReRunCommand(this.jobId, this.conf, this.authToken), 30000L);
                XLog.getLog(this.getClass()).warn("ReRunCommand lock was not acquired - failed {0}", this.jobId);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new ReRunCommand(this.jobId, this.conf, this.authToken), 30000L);
            XLog.getLog(this.getClass()).warn("ReRunCommand lock was not acquired - interrupted exception failed {0}", this.jobId);
        }
        XLog.getLog(this.getClass()).debug("ENDED ReRunCommand for job " + this.jobId);
        return null;
    }

    static {
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name", "hadoop.job.ugi", "mapreduce.jobtracker.kerberos.principal", "dfs.namenode.kerberos.principal"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

