/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;

public class JobCommand
extends WorkflowCommand<WorkflowJobBean> {
    private String id;
    private int start = 1;
    private int len = Integer.MAX_VALUE;

    public JobCommand(String id) {
        this(id, 1, Integer.MAX_VALUE);
    }

    public JobCommand(String id, int start, int length) {
        super("job.info", "job.info", 1, 4, true);
        this.id = ParamChecker.notEmpty(id, "id");
        this.start = start;
        this.len = length;
    }

    @Override
    protected WorkflowJobBean call(WorkflowStore store) throws StoreException {
        WorkflowJobBean workflow = store.getWorkflowInfoWithActionsSubset(this.id, this.start, this.len);
        workflow.setConsoleUrl(JobCommand.getJobConsoleUrl(this.id));
        return workflow;
    }

    static String getJobConsoleUrl(String jobId) {
        String consoleUrl = Services.get().getConf().get("oozie.JobCommand.job.console.url", null);
        return consoleUrl != null ? consoleUrl + jobId : null;
    }
}

