/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.SignalCommand;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.SLADbOperations;
import org.apache.oozie.workflow.WorkflowInstance;

public class ActionEndCommand
extends ActionCommand<Void> {
    public static final String COULD_NOT_END = "COULD_NOT_END";
    public static final String END_DATA_MISSING = "END_DATA_MISSING";
    private String id;
    private String jobId = null;

    public ActionEndCommand(String id, String type) {
        super("action.end", type, 0);
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        WorkflowJobBean workflow = store.getWorkflow(this.jobId, false);
        this.setLogInfo(workflow);
        WorkflowActionBean action = store.getAction(this.id, false);
        this.setLogInfo(action);
        if (action.isPending() && (action.getStatus() == WorkflowAction.Status.DONE || action.getStatus() == WorkflowAction.Status.END_RETRY || action.getStatus() == WorkflowAction.Status.END_MANUAL)) {
            if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
                ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(action.getType());
                Configuration conf = workflow.getWorkflowInstance().getConf();
                int maxRetries = conf.getInt("oozie.wf.action.max.retries", executor.getMaxRetries());
                long retryInterval = conf.getLong("oozie.wf.action.retry.interval", executor.getRetryInterval());
                executor.setMaxRetries(maxRetries);
                executor.setRetryInterval(retryInterval);
                if (executor == null) throw new CommandException(ErrorCode.E0802, action.getType());
                boolean isRetry = false;
                if (action.getStatus() == WorkflowAction.Status.END_RETRY || action.getStatus() == WorkflowAction.Status.END_MANUAL) {
                    isRetry = true;
                }
                ActionCommand.ActionExecutorContext context = new ActionCommand.ActionExecutorContext(workflow, action, isRetry);
                try {
                    XLog.getLog(this.getClass()).debug("End, name [{0}] type [{1}] status[{2}] external status [{3}] signal value [{4}]", action.getName(), action.getType(), action.getStatus(), action.getExternalStatus(), action.getSignalValue());
                    Instrumentation.Cron cron = new Instrumentation.Cron();
                    cron.start();
                    executor.end(context, action);
                    cron.stop();
                    this.addActionCron(action.getType(), cron);
                    WorkflowInstance wfInstance = workflow.getWorkflowInstance();
                    DagELFunctions.setActionInfo(wfInstance, action);
                    workflow.setWorkflowInstance(wfInstance);
                    this.incrActionCounter(action.getType(), 1);
                    if (!context.isEnded()) {
                        XLog.getLog(this.getClass()).warn(4, "Action Ended, ActionExecutor [{0}] must call setEndData()", executor.getType());
                        action.setErrorInfo(END_DATA_MISSING, "Execution Ended, but End Data Missing from Action");
                        this.failJob(context);
                        store.updateAction(action);
                        store.updateWorkflow(workflow);
                        return null;
                    }
                    action.setRetries(0);
                    action.setEndTime(new Date());
                    store.updateAction(action);
                    store.updateWorkflow(workflow);
                    SLAEvent.Status slaStatus = null;
                    switch (action.getStatus()) {
                        case OK: {
                            slaStatus = SLAEvent.Status.SUCCEEDED;
                            break;
                        }
                        case KILLED: {
                            slaStatus = SLAEvent.Status.KILLED;
                            break;
                        }
                        case FAILED: {
                            slaStatus = SLAEvent.Status.FAILED;
                            break;
                        }
                        case ERROR: {
                            XLog.getLog(this.getClass()).info("ERROR is considered as FAILED for SLA");
                            slaStatus = SLAEvent.Status.KILLED;
                            break;
                        }
                        default: {
                            slaStatus = SLAEvent.Status.FAILED;
                        }
                    }
                    SLADbOperations.writeStausEvent(action.getSlaXml(), action.getId(), store, slaStatus, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                    this.queueCallable(new NotificationCommand(workflow, action));
                    XLog.getLog(this.getClass()).debug("Queuing commands for action=" + this.id + ", status=" + action.getStatus() + ", Set pending=" + action.getPending());
                    this.queueCallable(new SignalCommand(workflow.getId(), this.id));
                    return null;
                }
                catch (ActionExecutorException ex) {
                    XLog.getLog(this.getClass()).warn("Error ending action [{0}]. ErrorType [{1}], ErrorCode [{2}], Message [{3}]", new Object[]{action.getName(), ex.getErrorType(), ex.getErrorCode(), ex.getMessage()});
                    action.setErrorInfo(ex.getErrorCode(), ex.getMessage());
                    action.setEndTime(null);
                    switch (ex.getErrorType()) {
                        case TRANSIENT: {
                            if (!this.handleTransient(context, executor, WorkflowAction.Status.END_RETRY)) {
                                this.handleNonTransient(store, context, executor, WorkflowAction.Status.END_MANUAL);
                                action.setPendingAge(new Date());
                                action.setRetries(0);
                            }
                            action.setEndTime(null);
                            break;
                        }
                        case NON_TRANSIENT: {
                            this.handleNonTransient(store, context, executor, WorkflowAction.Status.END_MANUAL);
                            action.setEndTime(null);
                            break;
                        }
                        case ERROR: {
                            this.handleError(context, executor, COULD_NOT_END, false, WorkflowAction.Status.ERROR);
                            this.queueCallable(new SignalCommand(workflow.getId(), this.id));
                            break;
                        }
                        case FAILED: {
                            this.failJob(context);
                        }
                    }
                    store.updateAction(action);
                    store.updateWorkflow(workflow);
                }
                return null;
            } else {
                XLog.getLog(this.getClass()).warn("Job state is not {0}. Skipping ActionEnd Execution", WorkflowJob.Status.RUNNING.toString());
            }
            return null;
        } else {
            XLog.getLog(this.getClass()).debug("Action pending={0}, status={1}. Skipping ActionEnd Execution", action.getPending(), action.getStatusStr());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        XLog.getLog(this.getClass()).debug("STARTED ActionEndCommand for action " + this.id);
        try {
            this.jobId = Services.get().get(UUIDService.class).getId(this.id);
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new ActionEndCommand(this.id, this.getType()), 30000L);
                XLog.getLog(this.getClass()).warn("ActionEnd lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new ActionEndCommand(this.id, this.getType()), 30000L);
            XLog.getLog(this.getClass()).warn("ActionEnd lock was not acquired - interrupted exception failed {0}", this.id);
        }
        finally {
            XLog.getLog(this.getClass()).debug("ENDED ActionEndCommand for action " + this.id);
        }
        return null;
    }
}

