/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowInstance;
import org.jdom.JDOMException;

public class DagELFunctions {
    private static final String WORKFLOW = "oozie.el.workflow.bean";
    private static final String ACTION = "oozie.el.action.bean";
    private static final String ACTION_PROTO_CONF = "oozie.el.action.proto.conf";
    private static final String LAST_ACTION_IN_ERROR = "oozie.el.last.action.in.error";
    private static final String ACTION_DATA = "action.data";
    private static final String ACTION_ERROR_CODE = "action.error.code";
    private static final String ACTION_ERROR_MESSAGE = "action.error.message";
    private static final String ACTION_EXTERNAL_ID = "action.external.id";
    private static final String ACTION_TRACKER_URI = "action.tracker.uri";
    private static final String ACTION_EXTERNAL_STATUS = "action.external.status";

    public static void configureEvaluator(ELEvaluator evaluator, WorkflowJobBean workflow, WorkflowActionBean action) {
        evaluator.setVariable(WORKFLOW, workflow);
        evaluator.setVariable(ACTION, action);
        for (Map.Entry entry : workflow.getWorkflowInstance().getConf()) {
            if (!ParamChecker.isValidIdentifier((String)entry.getKey())) continue;
            String value = ((String)entry.getValue()).trim();
            try {
                String valueElem = "<value>" + value + "</value>";
                XmlUtils.parseXml(valueElem);
            }
            catch (JDOMException ex) {
                value = XmlUtils.escapeCharsForXML(value);
            }
            evaluator.setVariable(((String)entry.getKey()).trim(), value);
        }
        try {
            evaluator.setVariable(ACTION_PROTO_CONF, (Object)new XConfiguration(new StringReader(workflow.getProtoActionConf())));
        }
        catch (IOException ex) {
            throw new RuntimeException("It should not happen", ex);
        }
    }

    public static WorkflowActionBean getAction() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (WorkflowActionBean)eval.getVariable(ACTION);
    }

    public static WorkflowJobBean getWorkflow() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (WorkflowJobBean)eval.getVariable(WORKFLOW);
    }

    public static Configuration getProtoActionConf() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (Configuration)eval.getVariable(ACTION_PROTO_CONF);
    }

    public static void setActionInfo(WorkflowInstance workflowInstance, WorkflowAction action) {
        if (action.getExternalId() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_EXTERNAL_ID, action.getExternalId());
        }
        if (action.getTrackerUri() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_TRACKER_URI, action.getTrackerUri());
        }
        if (action.getExternalStatus() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_EXTERNAL_STATUS, action.getExternalStatus());
        }
        if (action.getData() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_DATA, action.getData());
        }
        if (action.getErrorCode() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_ERROR_CODE, action.getErrorCode());
        }
        if (action.getErrorMessage() != null) {
            workflowInstance.setVar(action.getName() + "#" + ACTION_ERROR_MESSAGE, action.getErrorMessage());
        }
        if (action.getStatus() == WorkflowAction.Status.ERROR) {
            workflowInstance.setVar(LAST_ACTION_IN_ERROR, action.getName());
        }
    }

    public static String wf_id() {
        return DagELFunctions.getWorkflow().getId();
    }

    public static String wf_name() {
        return DagELFunctions.getWorkflow().getAppName();
    }

    public static String wf_appPath() {
        return DagELFunctions.getWorkflow().getAppPath();
    }

    public static String wf_conf(String property) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getConf().get(property);
    }

    public static String wf_user() {
        return DagELFunctions.getWorkflow().getUser();
    }

    public static String wf_group() {
        return DagELFunctions.getWorkflow().getGroup();
    }

    public static String wf_callback(String externalStatusVar) {
        return Services.get().get(CallbackService.class).createCallBackUrl(DagELFunctions.getAction().getId(), externalStatusVar);
    }

    public static String wf_transition(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getTransition(actionName);
    }

    public static String wf_lastErrorNode() {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(LAST_ACTION_IN_ERROR);
    }

    public static String wf_errorCode(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_ERROR_CODE);
    }

    public static String wf_errorMessage(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_ERROR_MESSAGE);
    }

    public static int wf_run() {
        return DagELFunctions.getWorkflow().getRun();
    }

    public static Map<String, String> wf_actionData(String actionName) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        Properties props = (Properties)eval.getVariable(actionName + ACTION_ERROR_MESSAGE);
        if (props == null) {
            String data = DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_DATA);
            props = data != null ? PropertiesUtils.stringToProperties(data) : new Properties();
            eval.setVariable(actionName + ACTION_ERROR_MESSAGE, props);
        }
        return props;
    }

    public static String wf_actionExternalId(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_EXTERNAL_ID);
    }

    public static String wf_actionTrackerUri(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_TRACKER_URI);
    }

    public static String wf_actionExternalStatus(String actionName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + ACTION_EXTERNAL_STATUS);
    }

    public static String getActionVar(String actionName, String varName) {
        return DagELFunctions.getWorkflow().getWorkflowInstance().getVar(actionName + "#" + varName);
    }
}

