/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class SqlConnectionAction
extends ActionDefinition {
    public static final String QUERY_RESULT_OUTPUT_NAME = "query-result";
    public static final String COMPONENT_NAME = "org.pentaho.component.SQLLookupRule";
    public static final String DRIVER_ELEMENT = "driver";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String DEFAULT_CONNECTION_NAME = "shared_sql_connection";
    public static final String DB_URL_NAME = "db-url";
    public static final String OUTPUT_CONNECTION = "output-connection";
    protected static final String[] EXPECTED_INPUTS = new String[]{"driver", "connection", "user-id", "password", "jndi"};

    public SqlConnectionAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public SqlConnectionAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setJndi(new ActionInputConstant("", this.actionParameterMgr));
        this.setOutputConnection(DEFAULT_CONNECTION_NAME);
    }

    public static boolean accepts(Element element) {
        boolean result = false;
        if (ActionDefinition.accepts(element) && SqlConnectionAction.hasComponentName(element, COMPONENT_NAME)) {
            Element connectionOutput = (Element)element.selectSingleNode("action-outputs/prepared_component");
            result = connectionOutput != null && "sql-connection".equals(connectionOutput.attributeValue("type"));
        }
        return result;
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    @Override
    public String[] getReservedOutputNames() {
        return new String[]{PREPARED_COMPONENT_ELEMENT};
    }

    public void setDbUrl(IActionInputSource value) {
        this.setActionInputValue(CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getDbUrl() {
        return this.getInput(CONNECTION_ELEMENT);
    }

    public void setUserId(IActionInputSource value) {
        this.setActionInputValue(USER_ID_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getUserId() {
        return this.getInput(USER_ID_ELEMENT);
    }

    public void setDriver(IActionInputSource value) {
        this.setActionInputValue(DRIVER_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getDriver() {
        return this.getInput(DRIVER_ELEMENT);
    }

    public void setPassword(IActionInputSource value) {
        this.setActionInputValue(PASSWORD_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getPassword() {
        return this.getInput(PASSWORD_ELEMENT);
    }

    public void setJndi(IActionInputSource value) {
        this.setActionInputValue(JNDI_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDriver(null);
            this.setDbUrl(null);
            this.setUserId(null);
            this.setPassword(null);
        }
    }

    public IActionInput getJndi() {
        return this.getInput(JNDI_ELEMENT);
    }

    public void setOutputConnection(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "sql-connection");
    }

    public IActionOutput getOutputConnection() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public ActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(CONNECTION_ELEMENT);
        if (validationError == null) {
            validationError = this.validateInput(DRIVER_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database driver input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database driver input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database driver input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
            if ((validationError = this.validateInput(USER_ID_ELEMENT)) != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database login input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database login input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database login input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput(JNDI_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database connection input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database connection input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Database connection input parameter references unknown variable.";
            errors.add(validationError);
        } else if (validationError.errorCode == 3) {
            validationError.errorMsg = "Database connection input parameter is uninitialized.";
            errors.add(validationError);
        }
        if ((validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing output connection name.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

