/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class PrintMapValsAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.UtilityComponent";
    public static final String PRINT_MAP_VALS_COMMAND = "getmapvalues";
    public static final String TARGET_MAP_XPATH = "getmapvalues/property-map";
    public static final String PROPERTY_MAP_ELEMENT = "property-map";
    public static final String MAP_KEY_XPATH = "getmapvalues/arg";
    public static final String KEY_PARAM_PREFIX = "key";

    public PrintMapValsAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public PrintMapValsAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(PRINT_MAP_VALS_COMMAND, "");
    }

    public static boolean accepts(Element element) {
        boolean accepts = false;
        if (ActionDefinition.accepts(element) && PrintMapValsAction.hasComponentName(element, COMPONENT_NAME)) {
            accepts = element.selectNodes("component-definition/getmapvalues").size() == 1 && element.selectSingleNode("component-definition/format") == null && element.selectSingleNode("component-definition/print") == null && element.selectSingleNode("component-definition/copy") == null;
        }
        return accepts;
    }

    public void setPropertyMap(IActionInputVariable value) {
        String mapParamName = this.getComponentDefinitionValue(TARGET_MAP_XPATH);
        if (value == null) {
            this.setActionInputValue(mapParamName, (IActionInputSource)null);
            this.setComponentDefinition(TARGET_MAP_XPATH, "", false);
        } else {
            if (!PROPERTY_MAP_ELEMENT.equals(mapParamName)) {
                this.setComponentDefinition(TARGET_MAP_XPATH, PROPERTY_MAP_ELEMENT, false);
            }
            this.setActionInputValue(PROPERTY_MAP_ELEMENT, value);
        }
    }

    public IActionInput getPropertyMap() {
        String mapParamName = this.getComponentDefinitionValue(TARGET_MAP_XPATH);
        IActionInput actionInput = IActionInput.NULL_INPUT;
        if (mapParamName != null && mapParamName.trim().length() > 0) {
            actionInput = this.getInput(mapParamName);
        }
        return actionInput;
    }

    public IActionInput[] getKeys() {
        ArrayList<ActionInputConstant> keys = new ArrayList<ActionInputConstant>();
        Element[] elements = this.getComponentDefElements(MAP_KEY_XPATH);
        for (int i = 0; i < elements.length; ++i) {
            keys.add(new ActionInputConstant(elements[i].getText(), this.actionParameterMgr));
        }
        return keys.toArray(new IActionInput[0]);
    }

    public void setKeys(ActionInputConstant[] keys) {
        IActionInput[] oldKeys = this.getKeys();
        for (int i = 0; i < oldKeys.length; ++i) {
            if (!(oldKeys[i] instanceof ActionInput)) continue;
            ((ActionInput)oldKeys[i]).delete();
        }
        IActionOutput[] oldOutputs = this.getOutputs();
        for (int i = 0; i < oldOutputs.length; ++i) {
            oldOutputs[i].delete();
        }
        this.setComponentDefinition(MAP_KEY_XPATH, new String[0]);
        ArrayList<String> keyParamNames = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            String keyParamName = keys[i].getStringValue();
            if (keyParamName == null) continue;
            keyParamNames.add(keyParamName);
            this.setOutput(keyParamName, keyParamName, "string");
        }
        if (keyParamNames.size() > 0) {
            this.setComponentDefinition(MAP_KEY_XPATH, keyParamNames.toArray(new String[0]));
        }
    }
}

