/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class PentahoReportAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.reporting.platform.plugin.SimpleReportingComponent";
    public static final String REPORT_DEFINITION_ELEMENT = "report-definition";
    public static final String REPORT_DEFINITION_INPUT_STREAM_ELEMENT = "reportDefinitionInputStream";
    public static final String REPORT_DEFINITION_PATH_ELEMENT = "reportDefinitionPath";
    public static final String USE_CONTENT_REPOSITORY_ELEMENT = "useContentRepository";
    public static final String PAGINATE_OUTPUT_ELEMENT = "paginate";
    public static final String OUTPUT_TYPE_ELEMENT = "outputType";
    public static final String REPORTHTML_CONTENTHANDLER_PATTERN_ELEMENT = "content-handler-pattern";
    public static final String REPORTGENERATE_YIELDRATE_ELEMENT = "yield-rate";
    public static final String ACCEPTED_PAGE_ELEMENT = "accepted-page";
    public static final String REPORT_OUTPUT_ELEMENT = "outputstream";
    protected static final String[] EXPECTED_RESOURCES = new String[]{"report-definition"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"reportDefinitionPath", "report-definition", "useContentRepository", "paginate", "outputType", "yield-rate", "accepted-page"};

    public PentahoReportAction(Element actionDefElement, IActionParameterMgr actionParameterMgr) {
        super(actionDefElement, actionParameterMgr);
    }

    public PentahoReportAction() {
        super(COMPONENT_NAME);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && PentahoReportAction.hasComponentName(element, COMPONENT_NAME);
    }

    public IActionResource getReportDefinitionResource() {
        return this.getResource(REPORT_DEFINITION_ELEMENT);
    }

    public IActionResource setReportDefinitionResource(URI uri, String mimeType) {
        IActionResource actionResource = null;
        if (uri == null) {
            this.setResourceUri(REPORT_DEFINITION_ELEMENT, null, mimeType);
        } else {
            actionResource = this.setResourceUri(REPORT_DEFINITION_ELEMENT, uri, mimeType);
            this.setReportDefinition(null);
        }
        return actionResource;
    }

    public void setReportDefinition(IActionInputSource value) {
        if (value instanceof IActionInputVariable) {
            IActionInputVariable variable = (IActionInputVariable)value;
            if (variable.getType().equals("inputstream")) {
                this.setActionInputValue(REPORT_DEFINITION_INPUT_STREAM_ELEMENT, value);
            } else {
                this.setActionInputValue(REPORT_DEFINITION_PATH_ELEMENT, value);
            }
            this.setReportDefinitionResource(null, null);
        } else if (value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setActionInputValue(REPORT_DEFINITION_PATH_ELEMENT, value);
            this.setReportDefinitionResource(null, null);
        } else {
            this.setActionInputValue(REPORT_DEFINITION_INPUT_STREAM_ELEMENT, (IActionInputSource)null);
            this.setActionInputValue(REPORT_DEFINITION_PATH_ELEMENT, (IActionInputSource)null);
        }
    }

    public IActionInput getReportDefinition() {
        return this.getInput(REPORT_DEFINITION_PATH_ELEMENT);
    }

    public void setUseContentRepository(IActionInputSource value) {
        this.setActionInputValue(USE_CONTENT_REPOSITORY_ELEMENT, value);
    }

    public IActionInput getUseContentRepository() {
        return this.getInput(USE_CONTENT_REPOSITORY_ELEMENT);
    }

    public void setPaginate(IActionInputSource value) {
        this.setActionInputValue(PAGINATE_OUTPUT_ELEMENT, value);
    }

    public IActionInput getPaginate() {
        return this.getInput(PAGINATE_OUTPUT_ELEMENT);
    }

    public void setOutputType(IActionInputSource value) {
        this.setActionInputValue(OUTPUT_TYPE_ELEMENT, value);
    }

    public IActionInput getOutputType() {
        return this.getInput(OUTPUT_TYPE_ELEMENT);
    }

    public void setAcceptedPage(IActionInputSource value) {
        this.setActionInputValue(ACCEPTED_PAGE_ELEMENT, value);
    }

    public IActionInput getAcceptedPage() {
        return this.getInput(ACCEPTED_PAGE_ELEMENT);
    }

    public void setYieldRate(IActionInputSource value) {
        this.setActionInputValue(REPORTGENERATE_YIELDRATE_ELEMENT, value);
    }

    public IActionInput getYieldRate() {
        return this.getInput(REPORTGENERATE_YIELDRATE_ELEMENT);
    }

    public void setReportHtmlContentHandlerPattern(IActionInputSource value) {
        this.setActionInputValue(REPORTHTML_CONTENTHANDLER_PATTERN_ELEMENT, value);
    }

    public IActionInput getReportHtmlContentHandlerPattern() {
        return this.getInput(REPORTHTML_CONTENTHANDLER_PATTERN_ELEMENT);
    }

    public List<IActionInput> getReportParameters() {
        ArrayList<String> knownInputs = new ArrayList<String>(Arrays.asList(EXPECTED_INPUTS));
        ArrayList<IActionInput> reportParameters = new ArrayList<IActionInput>();
        for (IActionInput input : this.getInputs()) {
            if (input instanceof ActionInputConstant && !knownInputs.contains(((ActionInputConstant)input).getName())) {
                reportParameters.add(input);
                continue;
            }
            if (!(input instanceof IActionInputVariable) || knownInputs.contains(((IActionInputVariable)((Object)input)).getVariableName())) continue;
            reportParameters.add(input);
        }
        return reportParameters;
    }

    public void setReportParameters(List<IActionInputSource> reportParameters) {
        List<IActionInput> existingReportParameters = this.getReportParameters();
        for (IActionInput existingReportParameter : existingReportParameters) {
            if (existingReportParameter instanceof ActionInputConstant) {
                this.setActionInputValue(((ActionInputConstant)existingReportParameter).getName(), (IActionInputSource)null);
                continue;
            }
            if (!(existingReportParameter instanceof IActionInputVariable)) continue;
            this.setActionInputValue(((IActionInputVariable)((Object)existingReportParameter)).getVariableName(), (IActionInputSource)null);
        }
        for (IActionInputSource reportParam : reportParameters) {
            if (reportParam instanceof ActionInputConstant) {
                this.setActionInputValue(((ActionInputConstant)reportParam).getName(), reportParam);
                continue;
            }
            if (!(reportParam instanceof IActionInputVariable)) continue;
            this.setActionInputValue(((IActionInputVariable)reportParam).getVariableName(), reportParam);
        }
    }

    public IActionOutput setOutputReport(String publicOutputName) {
        IActionOutput actionOutput = this.setOutput(REPORT_OUTPUT_ELEMENT, publicOutputName, "content");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (!actionOutputs[i].getType().equals("content") || actionOutputs[i].getName().equals(REPORT_OUTPUT_ELEMENT)) continue;
                actionOutputs[i].delete();
            }
        }
        return actionOutput;
    }

    public IActionOutput getOutputReport() {
        IActionOutput[] actionOutputs;
        String privateOutputName = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(privateOutputName) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            privateOutputName = actionOutputs[0].getName();
        }
        return this.getOutput(REPORT_OUTPUT_ELEMENT);
    }
}

