/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class KettleTransformAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "KettleComponent";
    @Deprecated
    protected static final String TRANSFORMATION_STEP_ELEMENT_OLD = "importstep";
    public static final String TRANSFORMATION_STEP_ELEMENT = "monitor-step";
    public static final String TRANSFORMATION_FILE_ELEMENT = "transformation-file";
    @Deprecated
    public static final String TRANSFORMATION_OUTPUT_ELEMENT = "transformation-output";
    public static final String EXECUTION_STATUS_OUTPUT_ELEMENT = "kettle-execution-status";
    public static final String EXECUTION_LOG_OUTPUT_ELEMENT = "kettle-execution-log";
    public static final String TRANSFORM_SUCCESS_OUTPUT_ELEMENT = "transformation-output-rows";
    public static final String TRANSFORM_ERROR_OUTPUT_ELEMENT = "transformation-output-error-rows";
    public static final String TRANSFORM_SUCCESS_COUNT_OUTPUT_ELEMENT = "transformation-output-rows-count";
    public static final String TRANSFORM_ERROR_COUNT_OUTPUT_ELEMENT = "transformation-output-error-rows-count";
    public static final String REPOSITORY_DIRECTORY = "directory";
    public static final String REPOSITORY_TRANSFORMATION = "transformation";
    public static final String[] EXPECTED_RESOURCES = new String[]{"transformation-file"};
    @Deprecated
    public static final String OUTPUT_RESULT_SET = "output-result-set";
    public static final String OUTPUT_SUCCESS_RESULT_SET = "output-success-result-set";
    public static final String OUTPUT_ERROR_RESULT_SET = "output-error-result-set";
    public static final String OUTPUT_SUCCESS_COUNT = "output-success-count";
    public static final String OUTPUT_ERROR_COUNT = "output-error-count";
    public static final String OUTPUT_EXECUTION_LOG = "output-execution-log";
    public static final String OUTPUT_EXECUTION_STATUS = "output-execution-status";
    public static final String NULL_MAPPING = "NULL_MAPPING";
    public static final String LOGGING_LEVEL = "logging-level";
    public static final String KETTLE_LOGGING_LEVEL = "kettle-logging-level";
    public static final String[] LOGGING_LEVEL_VALUES = new String[]{"minimal", "basic", "detail", "error", "rowlevel", "debug", "none"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"importstep", "monitor-step", "directory", "transformation", "logging-level", "kettle-logging-level"};
    protected static final String[] EXPECTED_OUTPUTS = new String[]{"transformation-output", "kettle-execution-status", "kettle-execution-log", "transformation-output-rows", "transformation-output-error-rows", "transformation-output-rows-count", "transformation-output-error-rows-count"};

    public KettleTransformAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public KettleTransformAction() {
        super(COMPONENT_NAME);
    }

    @Override
    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.addResource(TRANSFORMATION_FILE_ELEMENT);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public static boolean accepts(Element element) {
        boolean result = false;
        if (ActionDefinition.accepts(element) && KettleTransformAction.hasComponentName(element, COMPONENT_NAME)) {
            result = element.selectSingleNode("action-resources/transformation-file") != null || element.selectSingleNode("action-inputs/transformation") != null || element.selectSingleNode("component-definition/transformation") != null;
        }
        return result;
    }

    @Override
    public String[] getReservedOutputNames() {
        return EXPECTED_OUTPUTS;
    }

    @Override
    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setTransformation(IActionInputSource value) {
        this.setActionInputValue(REPOSITORY_TRANSFORMATION, value);
    }

    public IActionInput getTransformation() {
        return this.getInput(REPOSITORY_TRANSFORMATION);
    }

    public void setLoggingLevel(IActionInputSource value) {
        this.setActionInputValue(LOGGING_LEVEL, value);
    }

    public IActionInput getLoggingLevel() {
        return this.getInput(LOGGING_LEVEL);
    }

    public void setKettleLoggingLevel(IActionInputSource value) {
        this.setActionInputValue(KETTLE_LOGGING_LEVEL, value);
    }

    public IActionInput getKettleLoggingLevel() {
        return this.getInput(KETTLE_LOGGING_LEVEL);
    }

    public void setDirectory(IActionInputSource value) {
        this.setActionInputValue(REPOSITORY_DIRECTORY, value);
    }

    public IActionInput getDirectory() {
        return this.getInput(REPOSITORY_DIRECTORY);
    }

    @Deprecated
    public void setImportstep(IActionInputSource value) {
        this.setMonitorStep(value);
    }

    @Deprecated
    public IActionInput getImportstep() {
        return this.getMonitorStep();
    }

    public void setMonitorStep(IActionInputSource value) {
        this.setActionInputValue(TRANSFORMATION_STEP_ELEMENT_OLD, ActionInputConstant.NULL_INPUT);
        this.setActionInputValue(TRANSFORMATION_STEP_ELEMENT, value);
    }

    public IActionInput getMonitorStep() {
        IActionInput input = this.getInput(TRANSFORMATION_STEP_ELEMENT_OLD);
        if (input == ActionInput.NULL_INPUT) {
            input = this.getInput(TRANSFORMATION_STEP_ELEMENT);
        }
        return input;
    }

    @Deprecated
    public void setOutputResultSet(String publicOutputName) {
        this.setOutputSuccessResultSet(publicOutputName);
    }

    @Deprecated
    public IActionOutput getOutputResultSet() {
        return this.getOutputSuccessResultSet();
    }

    public void setOutputSuccessResultSet(String publicOutputName) {
        this.setOutput(TRANSFORMATION_OUTPUT_ELEMENT, null, "result-set");
        this.setOutput(TRANSFORM_SUCCESS_OUTPUT_ELEMENT, publicOutputName, "result-set");
    }

    public IActionOutput getOutputSuccessResultSet() {
        IActionOutput output = this.getOutput(TRANSFORMATION_OUTPUT_ELEMENT);
        if (output == null) {
            output = this.getOutput(TRANSFORM_SUCCESS_OUTPUT_ELEMENT);
        }
        return output;
    }

    public void setOutputErrorResultSet(String publicOutputName) {
        this.setOutput(TRANSFORM_ERROR_OUTPUT_ELEMENT, publicOutputName, "result-set");
    }

    public IActionOutput getOutputErrorResultSet() {
        return this.getOutput(TRANSFORM_ERROR_OUTPUT_ELEMENT);
    }

    public void setOutputSuccessCount(String publicOutputName) {
        this.setOutput(TRANSFORM_SUCCESS_COUNT_OUTPUT_ELEMENT, publicOutputName, "integer");
    }

    public IActionOutput getOutputSuccessCount() {
        return this.getOutput(TRANSFORM_SUCCESS_COUNT_OUTPUT_ELEMENT);
    }

    public void setOutputErrorCount(String publicOutputName) {
        this.setOutput(TRANSFORM_ERROR_COUNT_OUTPUT_ELEMENT, publicOutputName, "integer");
    }

    public IActionOutput getOutputErrorCount() {
        return this.getOutput(TRANSFORM_ERROR_COUNT_OUTPUT_ELEMENT);
    }

    public void setOutputExecutionLog(String publicOutputName) {
        this.setOutput(EXECUTION_LOG_OUTPUT_ELEMENT, publicOutputName, "string");
    }

    public IActionOutput getOutputExecutionLog() {
        return this.getOutput(EXECUTION_LOG_OUTPUT_ELEMENT);
    }

    public void setOutputExecutionStatus(String publicOutputName) {
        this.setOutput(EXECUTION_STATUS_OUTPUT_ELEMENT, publicOutputName, "string");
    }

    public IActionOutput getOutputExecutionStatus() {
        return this.getOutput(EXECUTION_STATUS_OUTPUT_ELEMENT);
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(REPOSITORY_DIRECTORY);
        if (validationError == null) {
            validationError = this.validateResource(TRANSFORMATION_FILE_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing transformation file location input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Transformation file location input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Transformation file location input parameter is unitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput(TRANSFORMATION_FILE_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing transformation file location input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Transformation file location input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Transformation file location input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Repository directory input parameter references unknown variable.";
            errors.add(validationError);
        } else if (validationError.errorCode == 3) {
            validationError.errorMsg = "Repository directory input parameter is uninitialized.";
            errors.add(validationError);
        } else {
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionResource setTransformationFile(URI uri, String mimeType) {
        IActionResource actionResource = this.getResource(TRANSFORMATION_FILE_ELEMENT);
        if (uri == null) {
            actionResource = this.getResource(TRANSFORMATION_FILE_ELEMENT);
            if (actionResource != null) {
                IActionSequenceResource actionSequenceResource;
                IActionSequenceDocument actionSequenceDocument = this.getDocument();
                IActionResource[] actionResources = actionSequenceDocument.getReferencesTo(actionSequenceResource = actionSequenceDocument.getResource(actionResource.getPublicName()));
                if (actionResources.length == 1 && actionResources[0].equals(actionResource)) {
                    actionSequenceResource.delete();
                } else {
                    actionResource.setMapping(NULL_MAPPING);
                }
            }
            actionResource = null;
        } else {
            actionResource = this.setResourceUri(TRANSFORMATION_FILE_ELEMENT, uri, mimeType);
        }
        return actionResource;
    }

    public IActionResource getTransformationFile() {
        IActionResource actionResource = this.getResource(TRANSFORMATION_FILE_ELEMENT);
        if (actionResource != null && NULL_MAPPING.equals(actionResource.getMapping())) {
            actionResource = null;
        }
        return actionResource;
    }
}

