/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.hadoop.security.http.XFrameOptionsFilter;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XLog;

public class OozieXFrameOptionsFilter
extends XFrameOptionsFilter {
    private static final XLog LOG = XLog.getLog(OozieXFrameOptionsFilter.class);

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean isXFrameEnable = ConfigurationService.getBoolean("oozie.service.ConfigurationService.xframe.filter.enabled");
        LOG.debug("Oozie XFrame-Option filter enabled status: " + isXFrameEnable);
        if (isXFrameEnable) {
            super.doFilter(req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

