/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event;

import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.util.XLog;

public class WorkflowActionEvent
extends JobEvent {
    private WorkflowAction.Status status;
    private String hadoopId;
    private String errorCode;
    private String errorMessage;

    public WorkflowActionEvent(String id, String parentId, WorkflowAction.Status status, String user, String appName, Date startTime, Date endTime) {
        super(id, parentId, user, AppType.WORKFLOW_ACTION, appName);
        this.setStatus(status);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        XLog.getLog(EventHandlerService.class).trace("Event generated - " + this.toString());
    }

    public WorkflowAction.Status getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowAction.Status actionStatus) {
        this.status = actionStatus;
        switch (actionStatus) {
            case OK: {
                this.setEventStatus(JobEvent.EventStatus.SUCCESS);
                break;
            }
            case RUNNING: {
                this.setEventStatus(JobEvent.EventStatus.STARTED);
                break;
            }
            case ERROR: 
            case KILLED: 
            case FAILED: {
                this.setEventStatus(JobEvent.EventStatus.FAILURE);
                break;
            }
            case START_MANUAL: 
            case END_MANUAL: {
                this.setEventStatus(JobEvent.EventStatus.SUSPEND);
            }
        }
    }

    public String getHadoopId() {
        return this.hadoopId;
    }

    public void setHadoopId(String id) {
        this.hadoopId = id;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String code) {
        this.errorCode = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }
}

