/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish;

import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;

public class RunInPluginClassLoader {
    public static void run(PluginInterface plugin, Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (plugin == null) {
            runnable.run();
            return;
        }
        ClassLoader origClassLoader = null;
        try {
            origClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader pluginClassLoader = PluginRegistry.getInstance().getClassLoader(plugin);
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            if (runnable != null) {
                runnable.run();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (origClassLoader != null) {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
    }
}

