/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.namedcluster.NamedClusterDialog;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoerCollection;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UINamedCluster;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UINamedClusterObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UINamedClusters;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class NamedClustersController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorer.class;
    private XulTree namedClustersTable = null;
    protected BindingFactory bf = null;
    private boolean isRepReadOnly = true;
    private Binding bindButtonNew = null;
    private Binding bindButtonEdit = null;
    private Binding bindButtonRemove = null;
    private Shell shell = null;
    private UINamedClusters namedClustersList = new UINamedClusters();
    private NamedClusterDialog namedClusterDialog;
    private MainController mainController;
    protected ContextChangeVetoerCollection contextChangeVetoers;
    protected List<UINamedCluster> selectedNamedClusters;
    protected List<UINamedCluster> repositoryNamedClusters;
    private Repository diRepository;

    public String getName() {
        return "namedClustersController";
    }

    public void init(Repository repository) throws ControllerInitializationException {
        this.diRepository = repository;
    }

    private NamedClusterDialog getNamedClusterDialog() {
        if (this.namedClusterDialog == null) {
            this.namedClusterDialog = NamedClusterUIHelper.getNamedClusterUIFactory().createNamedClusterDialog(this.shell);
        }
        return this.namedClusterDialog;
    }

    private void createBindings() {
        block3: {
            this.refreshNamedClustersList();
            this.namedClustersTable = (XulTree)this.document.getElementById("named-clusters-table");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            try {
                this.bf.createBinding((Object)this.namedClustersList, "children", (Object)this.namedClustersTable, "elements", new BindingConvertor[0]).fireSourceChanged();
                this.bindButtonNew = this.bf.createBinding((Object)this, "repReadOnly", "named-clusters-new", "disabled", new BindingConvertor[0]);
                this.bindButtonNew.fireSourceChanged();
                this.bindButtonEdit = this.bf.createBinding((Object)this, "repReadOnly", "named-clusters-edit", "disabled", new BindingConvertor[0]);
                this.bindButtonEdit.fireSourceChanged();
                this.bindButtonRemove = this.bf.createBinding((Object)this, "repReadOnly", "named-clusters-remove", "disabled", new BindingConvertor[0]);
                this.bindButtonRemove.fireSourceChanged();
                if (this.diRepository != null) {
                    this.bf.createBinding((Object)this.namedClustersTable, "selectedItems", (Object)this, "selectedNamedClusters", new BindingConvertor[0]);
                }
            }
            catch (Exception ex) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)ex)) break block3;
                throw new RuntimeException(ex);
            }
        }
    }

    protected boolean doLazyInit() {
        try {
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
        }
        catch (XulException e) {
            return false;
        }
        try {
            this.setRepReadOnly(this.diRepository.getRepositoryMeta().getRepositoryCapabilities().isReadOnly());
            this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
            this.bf = new DefaultBindingFactory();
            this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
            if (this.bf != null) {
                this.createBindings();
            }
            this.enableButtons(true, false, false);
            return true;
        }
        catch (Exception e) {
            if (this.mainController == null || !this.mainController.handleLostRepository((Throwable)e)) {
                return false;
            }
            return false;
        }
    }

    public Repository getRepository() {
        return this.diRepository;
    }

    public void setRepReadOnly(boolean isRepReadOnly) {
        block4: {
            try {
                if (this.isRepReadOnly != isRepReadOnly) {
                    this.isRepReadOnly = isRepReadOnly;
                    if (this.initialized) {
                        this.bindButtonNew.fireSourceChanged();
                        this.bindButtonEdit.fireSourceChanged();
                        this.bindButtonRemove.fireSourceChanged();
                    }
                }
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isRepReadOnly() {
        return this.isRepReadOnly;
    }

    private void refreshNamedClustersList() {
        final ArrayList tmpList = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        for (NamedCluster namedCluster : NamedClusterManager.getInstance().list(NamedClustersController.this.diRepository.getMetaStore())) {
                            try {
                                tmpList.add(UINamedClusterObjectRegistry.getInstance().constructUINamedCluster(namedCluster, NamedClustersController.this.diRepository));
                            }
                            catch (UIObjectCreationException uoe) {
                                tmpList.add(new UINamedCluster(namedCluster, NamedClustersController.this.diRepository));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (NamedClustersController.this.mainController != null && NamedClustersController.this.mainController.handleLostRepository((Throwable)e)) break block5;
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.doWithBusyIndicator(r);
        this.namedClustersList.setChildren(tmpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNamedCluster() {
        try {
            NamedCluster namedCluterTemplate = NamedClusterManager.getInstance().getClusterTemplate();
            namedCluterTemplate.initializeVariablesFrom(null);
            this.getNamedClusterDialog().setNamedCluster(namedCluterTemplate);
            this.getNamedClusterDialog().setNewClusterCheck(true);
            String namedClusterName = this.getNamedClusterDialog().open();
            if (namedClusterName != null && !namedClusterName.equals("")) {
                NamedCluster namedCluster = NamedClusterManager.getInstance().read(namedClusterName, (IMetaStore)Spoon.getInstance().getMetaStore());
                if (namedCluster == null) {
                    NamedClusterManager.getInstance().create(this.getNamedClusterDialog().getNamedCluster(), (IMetaStore)Spoon.getInstance().getMetaStore());
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (Exception e) {
            if (this.mainController == null || !this.mainController.handleLostRepository((Throwable)e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Create.UnexpectedError.Message", (String[])new String[0]), e);
            }
        }
        finally {
            this.refreshNamedClustersList();
        }
    }

    List<ContextChangeVetoer.TYPE> pollContextChangeVetoResults() {
        if (this.contextChangeVetoers != null) {
            return this.contextChangeVetoers.fireContextChange();
        }
        ArrayList<ContextChangeVetoer.TYPE> returnValue = new ArrayList<ContextChangeVetoer.TYPE>();
        returnValue.add(ContextChangeVetoer.TYPE.NO_OP);
        return returnValue;
    }

    public void addContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers == null) {
            this.contextChangeVetoers = new ContextChangeVetoerCollection();
        }
        this.contextChangeVetoers.add((Object)listener);
    }

    public void removeContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers != null) {
            this.contextChangeVetoers.remove((Object)listener);
        }
    }

    private boolean contains(ContextChangeVetoer.TYPE type, List<ContextChangeVetoer.TYPE> typeList) {
        for (ContextChangeVetoer.TYPE t : typeList) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    boolean compareNamedClusters(List<UINamedCluster> ro1, List<UINamedCluster> ro2) {
        if (ro1 != null && ro2 != null) {
            if (ro1.size() != ro2.size()) {
                return false;
            }
            for (int i = 0; i < ro1.size(); ++i) {
                if (ro1.get(i) == null || ro2.get(i) == null || ro1.get(i).getName().equals(ro2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editNamedCluster() {
        try {
            Collection namedClusters = this.namedClustersTable.getSelectedItems();
            if (namedClusters != null && !namedClusters.isEmpty()) {
                NamedCluster original = ((UINamedCluster)((Object)namedClusters.toArray()[0])).getNamedCluster();
                NamedCluster namedCluster = original.clone();
                if (NamedClusterManager.getInstance().read(namedCluster.getName(), (IMetaStore)Spoon.getInstance().getMetaStore()) == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.DoesNotExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.DoesNotExists.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    this.getNamedClusterDialog().setNamedCluster(namedCluster);
                    this.getNamedClusterDialog().setNewClusterCheck(false);
                    String namedClusterName = this.getNamedClusterDialog().open();
                    if (namedClusterName != null && !namedClusterName.equals("")) {
                        NamedClusterManager.getInstance().delete(original.getName(), (IMetaStore)Spoon.getInstance().getMetaStore());
                        NamedClusterManager.getInstance().create(namedCluster, (IMetaStore)Spoon.getInstance().getMetaStore());
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.NoItemSelected.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (Exception e) {
            if (this.mainController == null || !this.mainController.handleLostRepository((Throwable)e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Edit.UnexpectedError.Message", (String[])new String[0]), e);
            }
        }
        finally {
            this.refreshNamedClustersList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamedCluster() {
        try {
            Collection namedClusters = this.namedClustersTable.getSelectedItems();
            if (namedClusters != null && !namedClusters.isEmpty()) {
                for (Object obj : namedClusters) {
                    if (obj == null || !(obj instanceof UINamedCluster)) continue;
                    UINamedCluster uiNamedCluster = (UINamedCluster)((Object)obj);
                    NamedCluster namedCluster = uiNamedCluster.getNamedCluster();
                    if (NamedClusterManager.getInstance().read(namedCluster.getName(), this.diRepository.getMetaStore()) == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.DoesNotExists.Message", (String[])new String[]{namedCluster.getName()}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.DoesNotExists.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    NamedClusterManager.getInstance().delete(namedCluster.getName(), this.diRepository.getMetaStore());
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.NoItemSelected.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (Exception e) {
            if (this.mainController == null || !this.mainController.handleLostRepository((Throwable)e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.NamedCluster.Delete.UnexpectedError.Message", (String[])new String[0]), e);
            }
        }
        finally {
            this.refreshNamedClustersList();
        }
    }

    public void setSelectedNamedClusters(List<UINamedCluster> namedClusters) {
        if (!this.compareNamedClusters(namedClusters, this.selectedNamedClusters)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedNamedClusters = namedClusters;
                this.setRepositoryNamedClusters(namedClusters);
            } else {
                this.namedClustersTable.setSelectedItems(this.selectedNamedClusters);
                return;
            }
        }
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (namedClusters != null && namedClusters.size() > 0) {
            enableRemove = true;
            if (namedClusters.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public List<UINamedCluster> getRepositoryNamedClusters() {
        return this.repositoryNamedClusters;
    }

    public void setRepositoryNamedClusters(List<UINamedCluster> repositoryNamedClusters) {
        this.repositoryNamedClusters = repositoryNamedClusters;
        this.firePropertyChange("repositoryNamedClusters", null, repositoryNamedClusters);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("named-clusters-new");
        XulButton bEdit = (XulButton)this.document.getElementById("named-clusters-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("named-clusters-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

