/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.fieldtype;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.pms.messages.Messages;

public class FieldTypeSettings {
    public static final int TYPE_OTHER = 0;
    public static final int TYPE_DIMENSION = 1;
    public static final int TYPE_FACT = 2;
    public static final int TYPE_KEY = 3;
    public static final int TYPE_ATTRIBUTE = 4;
    public static final FieldTypeSettings OTHER = new FieldTypeSettings(0);
    public static final FieldTypeSettings DIMENSION = new FieldTypeSettings(1);
    public static final FieldTypeSettings FACT = new FieldTypeSettings(2);
    public static final FieldTypeSettings KEY = new FieldTypeSettings(3);
    public static final FieldTypeSettings ATTRIBUTE = new FieldTypeSettings(4);
    public static final FieldTypeSettings[] types = new FieldTypeSettings[]{OTHER, DIMENSION, FACT, KEY, ATTRIBUTE};
    private static final String[] typeCodes = new String[]{"Other", "Dimension", "Fact", "Key", "Attribute"};
    private static final String[] typeDescriptions = new String[]{Messages.getString("FieldTypeSettings.USER_OTHER_DESC"), Messages.getString("FieldTypeSettings.USER_DIMENSION_DESC"), Messages.getString("FieldTypeSettings.USER_FACT_DESC"), Messages.getString("FieldTypeSettings.USER_KEY_DESC"), Messages.getString("FieldTypeSettings.USER_ATTRIBUTE_DESC")};
    private int type;

    public FieldTypeSettings(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isFact() {
        return this.type == 2;
    }

    public boolean isDimension() {
        return this.type == 1;
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldTypeSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FieldTypeSettings rhs = (FieldTypeSettings)obj;
        return new EqualsBuilder().append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(83, 151).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.type).toString();
    }

    public static FieldTypeSettings getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return OTHER;
    }

    public static FieldTypeSettings guessFieldType(String name) {
        String fieldname = name.toLowerCase();
        String[] ids = new String[]{"id", "pk", "tk", "sk"};
        boolean isKey = false;
        for (int i = 0; i < ids.length && !isKey; ++i) {
            if (!fieldname.startsWith(ids[i] + "_") && !fieldname.endsWith("_" + ids[i])) continue;
            isKey = true;
        }
        if (isKey) {
            return KEY;
        }
        return DIMENSION;
    }

    public static String[] getTypeDescriptions() {
        return (String[])typeDescriptions.clone();
    }
}

