/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.automodel;

import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;
import org.pentaho.pms.schema.concept.types.tabletype.TableTypeSettings;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;
import org.pentaho.pms.util.UniqueArrayList;

public class PhysicalTableImporter {
    public static PhysicalTable importTableDefinition(Database database, String schemaName, String tableName, String locale) throws KettleException {
        String upper;
        UniqueArrayList<PhysicalColumn> fields = new UniqueArrayList<PhysicalColumn>();
        String id = tableName;
        String tablename = tableName;
        id = Const.toID(tableName);
        id = Settings.getPhysicalTableIDPrefix() + id;
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        PhysicalTable physicalTable = new PhysicalTable(id, schemaName, tableName, database.getDatabaseMeta(), fields);
        String niceName = PhysicalTableImporter.beautifyName(tablename);
        physicalTable.getConcept().setName(locale, niceName);
        DatabaseMeta dbMeta = database.getDatabaseMeta();
        String schemaTableCombination = dbMeta.getSchemaTableCombination(dbMeta.quoteField(schemaName), dbMeta.quoteField(tableName));
        RowMetaInterface row = database.getTableFields(schemaTableCombination);
        if (row != null && row.size() > 0) {
            for (int i = 0; i < row.size(); ++i) {
                ValueMetaInterface v = row.getValueMeta(i);
                PhysicalColumn physicalColumn = PhysicalTableImporter.importPhysicalColumnDefinition(v, physicalTable, locale);
                try {
                    fields.add(physicalColumn);
                    continue;
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    // empty catch block
                }
            }
        }
        if ((upper = tablename.toUpperCase()).startsWith("D_") || upper.startsWith("DIM") || upper.endsWith("DIM")) {
            physicalTable.setTableType(TableTypeSettings.DIMENSION);
        }
        if (upper.startsWith("F_") || upper.startsWith("FACT") || upper.endsWith("FACT")) {
            physicalTable.setTableType(TableTypeSettings.FACT);
        }
        return physicalTable;
    }

    public static String beautifyName(String name) {
        return StringUtils.capitalize((String)name.replaceAll("[\"`'\\\\]", "").replace("_", " "));
    }

    private static PhysicalColumn importPhysicalColumnDefinition(ValueMetaInterface v, PhysicalTable physicalTable, String locale) {
        String id = Settings.getPhysicalColumnIDPrefix() + v.getName();
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        String dbname = v.getName();
        FieldTypeSettings fieldType = FieldTypeSettings.guessFieldType(v.getName());
        PhysicalColumn physicalColumn = new PhysicalColumn(v.getName(), dbname, fieldType, AggregationSettings.NONE, physicalTable);
        String niceName = PhysicalTableImporter.beautifyName(v.getName());
        physicalColumn.setName(locale, niceName);
        DataTypeSettings dataTypeSettings = PhysicalTableImporter.getDataTypeSettings(v);
        physicalColumn.setDataType(dataTypeSettings);
        return physicalColumn;
    }

    private static DataTypeSettings getDataTypeSettings(ValueMetaInterface v) {
        DataTypeSettings dataTypeSettings = new DataTypeSettings(1);
        switch (v.getType()) {
            case 1: 
            case 5: 
            case 6: {
                dataTypeSettings.setType(4);
                break;
            }
            case 8: {
                dataTypeSettings.setType(5);
                break;
            }
            case 4: {
                dataTypeSettings.setType(3);
                break;
            }
            case 3: {
                dataTypeSettings.setType(2);
                break;
            }
            case 2: {
                dataTypeSettings.setType(1);
                break;
            }
            case 0: {
                dataTypeSettings.setType(0);
                break;
            }
        }
        dataTypeSettings.setLength(v.getLength());
        dataTypeSettings.setPrecision(v.getPrecision());
        return dataTypeSettings;
    }
}

