/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.thin;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.datatable.DataTable;
import org.pentaho.metadata.model.thin.Model;
import org.pentaho.metadata.model.thin.ModelInfo;
import org.pentaho.metadata.model.thin.ModelProvider;
import org.pentaho.metadata.model.thin.Query;

public class MetadataModelsService
implements ModelProvider {
    public static final String PROVIDER_ID = "modelservice";
    private static final List<ModelProvider> modelProviders = new ArrayList<ModelProvider>();

    public static final void addProvider(ModelProvider provider) {
        modelProviders.add(provider);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    protected String getProviderId(String modelId) {
        if (modelId == null) {
            return null;
        }
        int pos = modelId.indexOf("~");
        if (pos != -1) {
            return modelId.substring(0, pos);
        }
        return null;
    }

    @Override
    public ModelInfo[] getModelList(String providerId, String groupId, String match) {
        ArrayList<ModelInfo> infoList = new ArrayList<ModelInfo>();
        for (ModelProvider provider : modelProviders) {
            ModelInfo[] providerInfos;
            if (providerId != null && !providerId.equals(provider.getId())) continue;
            for (ModelInfo info : providerInfos = provider.getModelList(providerId, groupId, match)) {
                infoList.add(info);
            }
        }
        ModelInfo[] infos = infoList.toArray(new ModelInfo[infoList.size()]);
        return infos;
    }

    @Override
    public Model getModel(String id) {
        String providerId = this.getProviderId(id);
        for (ModelProvider provider : modelProviders) {
            Model model;
            if (!provider.getId().equals(providerId) || (model = provider.getModel(id)) == null) continue;
            return model;
        }
        return null;
    }

    @Override
    public DataTable executeQuery(Query query, int rowLimit) {
        String id = query.getSourceId();
        String providerId = this.getProviderId(id);
        for (ModelProvider provider : modelProviders) {
            Model model;
            if (!provider.getId().equals(providerId) || (model = provider.getModel(id)) == null) continue;
            return provider.executeQuery(query, rowLimit);
        }
        return null;
    }
}

