/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;

public class AvailableSpaceBlockPlacementPolicy
extends BlockPlacementPolicyDefault {
    private static final Log LOG = LogFactory.getLog(AvailableSpaceBlockPlacementPolicy.class);
    private static final Random RAND = new Random();
    private int balancedPreference = 60;

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        super.initialize(conf, stats, clusterMap, host2datanodeMap);
        float balancedPreferencePercent = conf.getFloat("dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction", 0.6f);
        LOG.info((Object)("Available space block placement policy initialized: dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction = " + balancedPreferencePercent));
        if ((double)balancedPreferencePercent > 1.0) {
            LOG.warn((Object)"The value of dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction is greater than 1.0 but should be in the range 0.0 - 1.0");
        }
        if ((double)balancedPreferencePercent < 0.5) {
            LOG.warn((Object)"The value of dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction is less than 0.5 so datanodes with more used percent will receive  more block allocations.");
        }
        this.balancedPreference = (int)(100.0f * balancedPreferencePercent);
    }

    @Override
    protected DatanodeDescriptor chooseDataNode(String scope, Collection<Node> excludedNode) {
        DatanodeDescriptor a = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope, excludedNode);
        DatanodeDescriptor b = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope, excludedNode);
        if (a != null && b != null) {
            int ret = this.compareDataNode(a, b);
            if (ret == 0) {
                return a;
            }
            if (ret < 0) {
                return RAND.nextInt(100) < this.balancedPreference ? a : b;
            }
            return RAND.nextInt(100) < this.balancedPreference ? b : a;
        }
        return a == null ? b : a;
    }

    protected int compareDataNode(DatanodeDescriptor a, DatanodeDescriptor b) {
        if (a.equals(b) || Math.abs(a.getDfsUsedPercent() - b.getDfsUsedPercent()) < 5.0f) {
            return 0;
        }
        return a.getDfsUsedPercent() < b.getDfsUsedPercent() ? -1 : 1;
    }
}

