/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.PersistenceAdapterSupport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTPacketIdGenerator;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LRUCache;
import org.apache.activemq.util.LongSequenceGenerator;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBACK;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTProtocolConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTProtocolConverter.class);
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    private static final MQTTFrame PING_RESP_FRAME = new PINGRESP().encode();
    private static final double MQTT_KEEP_ALIVE_GRACE_PERIOD = 0.5;
    static final int DEFAULT_CACHE_SIZE = 5000;
    private static final byte SUBSCRIBE_ERROR = -128;
    private final ConnectionId connectionId = new ConnectionId(CONNECTION_ID_GENERATOR.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator publisherIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap<Integer, ResponseHandler> resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConsumerId, MQTTSubscription> subscriptionsByConsumerId = new ConcurrentHashMap();
    private final ConcurrentHashMap<UTF8Buffer, MQTTSubscription> mqttSubscriptionByTopic = new ConcurrentHashMap();
    private final Map<UTF8Buffer, ActiveMQTopic> activeMQTopicMap = new LRUCache<UTF8Buffer, ActiveMQTopic>(5000);
    private final Map<Destination, UTF8Buffer> mqttTopicMap = new LRUCache<Destination, UTF8Buffer>(5000);
    private final Set<String> restoredSubs = Collections.synchronizedSet(new HashSet());
    private final Map<Short, MessageAck> consumerAcks = new LRUCache<Short, MessageAck>(5000);
    private final Map<Short, PUBREC> publisherRecs = new LRUCache<Short, PUBREC>(5000);
    private final MQTTTransport mqttTransport;
    private final BrokerService brokerService;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final ConnectionInfo connectionInfo = new ConnectionInfo();
    private CONNECT connect;
    private String clientId;
    private long defaultKeepAlive;
    private int activeMQSubscriptionPrefetch = 1;
    protected static final String QOS_PROPERTY_NAME = "ActiveMQ.MQTT.QoS";
    private final MQTTPacketIdGenerator packetIdGenerator;
    boolean willSent = false;

    public MQTTProtocolConverter(MQTTTransport mqttTransport, BrokerService brokerService) {
        this.mqttTransport = mqttTransport;
        this.brokerService = brokerService;
        this.packetIdGenerator = MQTTPacketIdGenerator.getMQTTPacketIdGenerator(brokerService);
        this.defaultKeepAlive = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    void sendToActiveMQ(Command command, ResponseHandler handler) {
        ActiveMQMessage msg;
        if (command instanceof ActiveMQMessage && (msg = (ActiveMQMessage)command).getDestination().getPhysicalName().startsWith("$")) {
            if (handler != null) {
                try {
                    handler.onResponse(this, new Response());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put(command.getCommandId(), handler);
        }
        this.getMQTTTransport().sendToActiveMQ(command);
    }

    void sendToMQTT(MQTTFrame frame) {
        try {
            this.mqttTransport.sendToMQTT(frame);
        }
        catch (IOException e) {
            LOG.warn("Failed to send frame " + frame, (Throwable)e);
        }
    }

    public void onMQTTCommand(MQTTFrame frame) throws IOException, JMSException {
        switch (frame.messageType()) {
            case 12: {
                LOG.debug("Received a ping from client: " + this.getClientId());
                this.sendToMQTT(PING_RESP_FRAME);
                LOG.debug("Sent Ping Response to " + this.getClientId());
                break;
            }
            case 1: {
                CONNECT connect = new CONNECT().decode(frame);
                this.onMQTTConnect(connect);
                LOG.debug("MQTT Client {} connected. (version: {})", (Object)this.getClientId(), (Object)connect.version());
                break;
            }
            case 14: {
                LOG.debug("MQTT Client {} disconnecting", (Object)this.getClientId());
                this.onMQTTDisconnect();
                break;
            }
            case 8: {
                this.onSubscribe(new SUBSCRIBE().decode(frame));
                break;
            }
            case 10: {
                this.onUnSubscribe(new UNSUBSCRIBE().decode(frame));
                break;
            }
            case 3: {
                this.onMQTTPublish(new PUBLISH().decode(frame));
                break;
            }
            case 4: {
                this.onMQTTPubAck(new PUBACK().decode(frame));
                break;
            }
            case 5: {
                this.onMQTTPubRec(new PUBREC().decode(frame));
                break;
            }
            case 6: {
                this.onMQTTPubRel(new PUBREL().decode(frame));
                break;
            }
            case 7: {
                this.onMQTTPubComp(new PUBCOMP().decode(frame));
                break;
            }
            default: {
                this.handleException(new MQTTProtocolException("Unknown MQTTFrame type: " + frame.messageType(), true), frame);
            }
        }
    }

    void onMQTTConnect(final CONNECT connect) throws MQTTProtocolException {
        if (this.connected.get()) {
            throw new MQTTProtocolException("Already connected.");
        }
        this.connect = connect;
        String clientId = "";
        if (connect.clientId() != null) {
            clientId = connect.clientId().toString();
        }
        String userName = null;
        if (connect.userName() != null) {
            userName = connect.userName().toString();
        }
        String passswd = null;
        if (connect.password() != null) {
            passswd = connect.password().toString();
        }
        this.configureInactivityMonitor(connect.keepAlive());
        this.connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null && !clientId.isEmpty()) {
            this.connectionInfo.setClientId(clientId);
        } else {
            if (!connect.cleanSession()) {
                CONNACK ack = new CONNACK();
                ack.code(CONNACK.Code.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
                try {
                    this.getMQTTTransport().sendToMQTT(ack.encode());
                    this.getMQTTTransport().onException(IOExceptionSupport.create("Invalid Client ID", null));
                }
                catch (IOException e) {
                    this.getMQTTTransport().onException(IOExceptionSupport.create(e));
                }
                return;
            }
            this.connectionInfo.setClientId("" + this.connectionInfo.getConnectionId().toString());
        }
        this.connectionInfo.setResponseRequired(true);
        this.connectionInfo.setUserName(userName);
        this.connectionInfo.setPassword(passswd);
        this.connectionInfo.setTransportContext(this.mqttTransport.getPeerCertificates());
        this.sendToActiveMQ(this.connectionInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable exception = ((ExceptionResponse)response).getException();
                    CONNACK ack = new CONNACK();
                    ack.code(CONNACK.Code.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
                    MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                    MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                    return;
                }
                SessionInfo sessionInfo = new SessionInfo(MQTTProtocolConverter.this.sessionId);
                MQTTProtocolConverter.this.sendToActiveMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(MQTTProtocolConverter.this.producerId);
                MQTTProtocolConverter.this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            CONNACK ack = new CONNACK();
                            ack.code(CONNACK.Code.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD);
                            MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                            MQTTProtocolConverter.this.getMQTTTransport().onException(IOExceptionSupport.create(exception));
                            return;
                        }
                        CONNACK ack = new CONNACK();
                        ack.code(CONNACK.Code.CONNECTION_ACCEPTED);
                        MQTTProtocolConverter.this.connected.set(true);
                        MQTTProtocolConverter.this.getMQTTTransport().sendToMQTT(ack.encode());
                        List<SubscriptionInfo> subs = PersistenceAdapterSupport.listSubscriptions(MQTTProtocolConverter.this.brokerService.getPersistenceAdapter(), MQTTProtocolConverter.this.connectionInfo.getClientId());
                        if (connect.cleanSession()) {
                            MQTTProtocolConverter.this.packetIdGenerator.stopClientSession(MQTTProtocolConverter.this.getClientId());
                            MQTTProtocolConverter.this.deleteDurableSubs(subs);
                        } else {
                            MQTTProtocolConverter.this.packetIdGenerator.startClientSession(MQTTProtocolConverter.this.getClientId());
                            MQTTProtocolConverter.this.restoreDurableSubs(subs);
                        }
                    }
                });
            }
        });
    }

    public void deleteDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.connectionId);
                rsi.setSubscriptionName(sub.getSubcriptionName());
                rsi.setClientId(sub.getClientId());
                this.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT durable subs.", e);
        }
    }

    public void restoreDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                String name = sub.getSubcriptionName();
                String[] split = name.split(":", 2);
                QoS qoS = QoS.valueOf(split[0]);
                this.onSubscribe(new Topic(split[1], qoS));
                this.restoredSubs.add(split[1]);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT durable subs.", (Throwable)e);
        }
    }

    void onMQTTDisconnect() throws MQTTProtocolException {
        if (this.connected.get()) {
            this.connected.set(false);
            this.sendToActiveMQ(this.connectionInfo.createRemoveCommand(), null);
            this.sendToActiveMQ(new ShutdownInfo(), null);
        }
        this.stopTransport();
    }

    void onSubscribe(SUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        Topic[] topics = command.topics();
        if (topics != null) {
            byte[] qos = new byte[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                qos[i] = this.onSubscribe(topics[i]);
            }
            SUBACK ack = new SUBACK();
            ack.messageId(command.messageId());
            ack.grantedQos(qos);
            try {
                this.getMQTTTransport().sendToMQTT(ack.encode());
            }
            catch (IOException e) {
                LOG.warn("Couldn't send SUBACK for " + command, (Throwable)e);
            }
        } else {
            LOG.warn("No topics defined for Subscription " + command);
        }
    }

    byte onSubscribe(Topic topic) throws MQTTProtocolException {
        final UTF8Buffer topicName = topic.name();
        final QoS topicQoS = topic.qos();
        ActiveMQTopic destination = new ActiveMQTopic(this.convertMQTTToActiveMQ(topicName.toString()));
        if (this.mqttSubscriptionByTopic.containsKey(topicName)) {
            MQTTSubscription mqttSubscription = this.mqttSubscriptionByTopic.get(topicName);
            if (topicQoS == mqttSubscription.qos()) {
                this.resendRetainedMessages(topicName, destination, mqttSubscription);
                return (byte)topicQoS.ordinal();
            }
            this.onUnSubscribe(topicName);
            this.onUnSubscribe(topicName);
        }
        ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setDestination(destination);
        consumerInfo.setPrefetchSize(this.getActiveMQSubscriptionPrefetch());
        consumerInfo.setRetroactive(true);
        consumerInfo.setDispatchAsync(true);
        if (!this.connect.cleanSession() && this.connect.clientId() != null && topicQoS.ordinal() >= QoS.AT_LEAST_ONCE.ordinal()) {
            consumerInfo.setSubscriptionName((Object)((Object)topicQoS) + ":" + topicName.toString());
        }
        MQTTSubscription mqttSubscription = new MQTTSubscription(this, topicQoS, consumerInfo);
        this.subscriptionsByConsumerId.put(id, mqttSubscription);
        this.mqttSubscriptionByTopic.put(topicName, mqttSubscription);
        final byte[] qos = new byte[]{-1};
        this.sendToActiveMQ(consumerInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable throwable = ((ExceptionResponse)response).getException();
                    LOG.warn("Error subscribing to " + topicName, throwable);
                    qos[0] = -128;
                } else {
                    qos[0] = (byte)topicQoS.ordinal();
                }
            }
        });
        if (qos[0] == -128) {
            this.subscriptionsByConsumerId.remove(id);
            this.mqttSubscriptionByTopic.remove(topicName);
        }
        return qos[0];
    }

    private void resendRetainedMessages(UTF8Buffer topicName, ActiveMQDestination destination, MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        RegionBroker regionBroker;
        if (this.restoredSubs.remove(destination.getPhysicalName())) {
            return;
        }
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error subscribing to " + topicName + ": " + e.getMessage(), false, e);
        }
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        ConsumerInfo consumerInfo = mqttSubscription.getConsumerInfo();
        ConsumerId consumerId = consumerInfo.getConsumerId();
        String connectionInfoClientId = this.connectionInfo.getClientId();
        ConnectionContext connectionContext = regionBroker.getConnectionContext(connectionInfoClientId);
        Set<org.apache.activemq.broker.region.Destination> matchingDestinations = topicRegion.getDestinations(destination);
        block4: for (org.apache.activemq.broker.region.Destination dest : matchingDestinations) {
            for (Subscription subscription : dest.getConsumers()) {
                if (!subscription.getConsumerInfo().getConsumerId().equals(consumerId)) continue;
                try {
                    ((org.apache.activemq.broker.region.Topic)dest).recoverRetroactiveMessages(connectionContext, subscription);
                    if (!(subscription instanceof PrefetchSubscription)) continue block4;
                    PrefetchSubscription prefetchSubscription = (PrefetchSubscription)subscription;
                    prefetchSubscription.dispatchPending();
                    continue block4;
                }
                catch (Exception e) {
                    throw new MQTTProtocolException("Error recovering retained messages for " + dest.getName() + ": " + e.getMessage(), false, e);
                }
            }
        }
    }

    void onUnSubscribe(UNSUBSCRIBE command) throws MQTTProtocolException {
        this.checkConnected();
        UTF8Buffer[] topics = command.topics();
        if (topics != null) {
            for (UTF8Buffer topic : topics) {
                this.onUnSubscribe(topic);
            }
        }
        UNSUBACK ack = new UNSUBACK();
        ack.messageId(command.messageId());
        this.sendToMQTT(ack.encode());
    }

    void onUnSubscribe(UTF8Buffer topicName) {
        MQTTSubscription subs = this.mqttSubscriptionByTopic.remove(topicName);
        if (subs != null) {
            ConsumerInfo info = subs.getConsumerInfo();
            if (info != null) {
                this.subscriptionsByConsumerId.remove(info.getConsumerId());
            }
            RemoveInfo removeInfo = null;
            if (info != null) {
                removeInfo = info.createRemoveCommand();
            }
            this.sendToActiveMQ(removeInfo, null);
            if (subs.getConsumerInfo().getSubscriptionName() != null) {
                this.restoredSubs.remove(this.convertMQTTToActiveMQ(topicName.toString()));
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.connectionId);
                rsi.setSubscriptionName(subs.getConsumerInfo().getSubscriptionName());
                rsi.setClientId(this.connectionInfo.getClientId());
                this.sendToActiveMQ(rsi, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActiveMQCommand(Command command) throws Exception {
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = this.resposeHandlers.remove(response.getCorrelationId());
            if (rh != null) {
                rh.onResponse(this, response);
            } else if (response.isException()) {
                Throwable exception = ((ExceptionResponse)response).getException();
                this.handleException(exception, null);
            }
        } else if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            MQTTSubscription sub = this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                MessageAck ack = sub.createMessageAck(md);
                PUBLISH publish = sub.createPublish((ActiveMQMessage)md.getMessage());
                switch (publish.qos()) {
                    case AT_LEAST_ONCE: 
                    case EXACTLY_ONCE: {
                        publish.dup(publish.dup() ? true : md.getMessage().isRedelivered());
                    }
                }
                if (ack != null && sub.expectAck(publish)) {
                    Map<Short, MessageAck> map2 = this.consumerAcks;
                    synchronized (map2) {
                        this.consumerAcks.put(publish.messageId(), ack);
                    }
                }
                this.getMQTTTransport().sendToMQTT(publish.encode());
                if (ack != null && !sub.expectAck(publish)) {
                    this.getMQTTTransport().sendToActiveMQ(ack);
                }
            }
        } else if (command.getDataStructureType() == 16) {
            Throwable exception = ((ConnectionError)command).getException();
            this.handleException(exception, null);
        } else if (!command.isBrokerInfo()) {
            LOG.debug("Do not know how to process ActiveMQ Command " + command);
        }
    }

    void onMQTTPublish(PUBLISH command) throws IOException, JMSException {
        this.checkConnected();
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        message.onSend();
        this.sendToActiveMQ(message, this.createResponseHandler(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubAck(PUBACK command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map2 = this.consumerAcks;
        synchronized (map2) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ(ack);
        }
    }

    void onMQTTPubRec(PUBREC commnand) {
        PUBREL pubrel = new PUBREL();
        pubrel.messageId(commnand.messageId());
        this.sendToMQTT(pubrel.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubRel(PUBREL command) {
        PUBREC ack;
        Map<Short, PUBREC> map2 = this.publisherRecs;
        synchronized (map2) {
            ack = this.publisherRecs.remove(command.messageId());
        }
        if (ack == null) {
            LOG.warn("Unknown PUBREL: " + command.messageId() + " received");
        }
        PUBCOMP pubcomp = new PUBCOMP();
        pubcomp.messageId(command.messageId());
        this.sendToMQTT(pubcomp.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMQTTPubComp(PUBCOMP command) {
        MessageAck ack;
        short messageId = command.messageId();
        this.packetIdGenerator.ackPacketId(this.getClientId(), messageId);
        Map<Short, MessageAck> map2 = this.consumerAcks;
        synchronized (map2) {
            ack = this.consumerAcks.remove(messageId);
        }
        if (ack != null) {
            this.getMQTTTransport().sendToActiveMQ(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveMQMessage convertMessage(PUBLISH command) throws JMSException {
        ActiveMQTopic topic;
        ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
        msg.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.publisherIdGenerator.getNextSequenceId());
        msg.setMessageId(id);
        msg.setTimestamp(System.currentTimeMillis());
        msg.setPriority((byte)4);
        msg.setPersistent(command.qos() != QoS.AT_MOST_ONCE && !command.retain());
        msg.setIntProperty(QOS_PROPERTY_NAME, command.qos().ordinal());
        if (command.retain()) {
            msg.setBooleanProperty("ActiveMQ.Retain", true);
        }
        Map<UTF8Buffer, ActiveMQTopic> map2 = this.activeMQTopicMap;
        synchronized (map2) {
            topic = this.activeMQTopicMap.get(command.topicName());
            if (topic == null) {
                String topicName = this.convertMQTTToActiveMQ(command.topicName().toString());
                topic = new ActiveMQTopic(topicName);
                this.activeMQTopicMap.put(command.topicName(), topic);
            }
        }
        msg.setJMSDestination(topic);
        msg.writeBytes(command.payload().data, command.payload().offset, command.payload().length);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PUBLISH convertMessage(ActiveMQMessage message) throws IOException, JMSException, DataFormatException {
        ActiveMQMessage msg;
        UTF8Buffer topicName;
        QoS qoS;
        PUBLISH result = new PUBLISH();
        if (message.propertyExists(QOS_PROPERTY_NAME)) {
            int ordinal = message.getIntProperty(QOS_PROPERTY_NAME);
            qoS = QoS.values()[ordinal];
        } else {
            qoS = message.isPersistent() ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE;
        }
        result.qos(qoS);
        if (message.getBooleanProperty("ActiveMQ.Retained")) {
            result.retain(true);
        }
        Map<Destination, UTF8Buffer> map2 = this.mqttTopicMap;
        synchronized (map2) {
            topicName = this.mqttTopicMap.get(message.getJMSDestination());
            if (topicName == null) {
                topicName = new UTF8Buffer(this.convertActiveMQToMQTT(message.getDestination().getPhysicalName()));
                this.mqttTopicMap.put(message.getJMSDestination(), topicName);
            }
        }
        result.topicName(topicName);
        if (message.getDataStructureType() == 28) {
            msg = (ActiveMQTextMessage)message.copy();
            msg.setReadOnlyBody(true);
            String messageText = ((ActiveMQTextMessage)msg).getText();
            if (messageText != null) {
                result.payload(new Buffer(messageText.getBytes("UTF-8")));
            }
        } else if (message.getDataStructureType() == 24) {
            msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)((ActiveMQBytesMessage)msg).getBodyLength()];
            ((ActiveMQBytesMessage)msg).readBytes(data);
            result.payload(new Buffer(data));
        } else if (message.getDataStructureType() == 25) {
            msg = (ActiveMQMapMessage)message.copy();
            msg.setReadOnlyBody(true);
            Map<String, Object> map3 = ((ActiveMQMapMessage)msg).getContentMap();
            if (map3 != null) {
                result.payload(new Buffer(map3.toString().getBytes("UTF-8")));
            }
        } else {
            ByteSequence byteSequence = message.getContent();
            if (byteSequence != null && byteSequence.getLength() > 0) {
                if (message.isCompressed()) {
                    int read2;
                    Inflater inflater = new Inflater();
                    inflater.setInput(byteSequence.data, byteSequence.offset, byteSequence.length);
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    while ((read2 = inflater.inflate(data)) != 0) {
                        bytesOut.write(data, 0, read2);
                    }
                    byteSequence = bytesOut.toByteSequence();
                    bytesOut.close();
                }
                result.payload(new Buffer(byteSequence.data, byteSequence.offset, byteSequence.length));
            }
        }
        return result;
    }

    private String convertActiveMQToMQTT(String physicalName) {
        return physicalName.replace('.', '/');
    }

    public MQTTTransport getMQTTTransport() {
        return this.mqttTransport;
    }

    public void onTransportError() {
        if (this.connect != null && this.connected.get()) {
            if (this.connect.willTopic() != null && this.connect.willMessage() != null && !this.willSent) {
                this.willSent = true;
                try {
                    PUBLISH publish = new PUBLISH();
                    publish.topicName(this.connect.willTopic());
                    publish.qos(this.connect.willQos());
                    publish.messageId(this.packetIdGenerator.getNextSequenceId(this.getClientId()));
                    publish.payload(this.connect.willMessage());
                    ActiveMQMessage message = this.convertMessage(publish);
                    message.setProducerId(this.producerId);
                    message.onSend();
                    this.sendToActiveMQ(message, null);
                }
                catch (Exception e) {
                    LOG.warn("Failed to publish Will Message " + this.connect.willMessage());
                }
            }
            this.sendToActiveMQ(this.connectionInfo.createRemoveCommand(), null);
        }
    }

    void configureInactivityMonitor(short keepAliveSeconds) {
        MQTTInactivityMonitor monitor = this.getMQTTTransport().getInactivityMonitor();
        if (monitor == null) {
            return;
        }
        long keepAliveMS = keepAliveSeconds * 1000;
        if (LOG.isDebugEnabled()) {
            LOG.debug("MQTT Client " + this.getClientId() + " requests heart beat of  " + keepAliveMS + " ms");
        }
        try {
            if (keepAliveMS == 0L && this.defaultKeepAlive > 0L) {
                keepAliveMS = this.defaultKeepAlive;
            }
            long readGracePeriod = (long)((double)keepAliveMS * 0.5);
            monitor.setProtocolConverter(this);
            monitor.setReadKeepAliveTime(keepAliveMS);
            monitor.setReadGraceTime(readGracePeriod);
            monitor.startMonitorThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("MQTT Client " + this.getClientId() + " established heart beat of  " + keepAliveMS + " ms (" + keepAliveMS + "ms + " + readGracePeriod + "ms grace period)");
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to start MQTT InactivityMonitor ", (Throwable)ex);
        }
    }

    void handleException(Throwable exception, MQTTFrame command) {
        LOG.warn("Exception occurred processing: \n" + command + ": " + exception.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception detail", exception);
        }
        if (this.connected.get() && this.connectionInfo != null) {
            this.connected.set(false);
            this.sendToActiveMQ(this.connectionInfo.createRemoveCommand(), null);
        }
        this.stopTransport();
    }

    void checkConnected() throws MQTTProtocolException {
        if (!this.connected.get()) {
            throw new MQTTProtocolException("Not connected.");
        }
    }

    String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.connect != null && this.connect.clientId() != null ? this.connect.clientId().toString() : "";
        }
        return this.clientId;
    }

    private void stopTransport() {
        try {
            this.getMQTTTransport().stop();
        }
        catch (Throwable e) {
            LOG.debug("Failed to stop MQTT transport ", e);
        }
    }

    ResponseHandler createResponseHandler(final PUBLISH command) {
        if (command != null) {
            switch (command.qos()) {
                case AT_LEAST_ONCE: {
                    return new ResponseHandler(){

                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", (Object)command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBACK ack = new PUBACK();
                                ack.messageId(command.messageId());
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
                case EXACTLY_ONCE: {
                    return new ResponseHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                            if (response.isException()) {
                                LOG.warn("Failed to send MQTT Publish: ", (Object)command, (Object)((ExceptionResponse)response).getException());
                            } else {
                                PUBREC ack = new PUBREC();
                                ack.messageId(command.messageId());
                                Map map2 = MQTTProtocolConverter.this.publisherRecs;
                                synchronized (map2) {
                                    MQTTProtocolConverter.this.publisherRecs.put(command.messageId(), ack);
                                }
                                converter.getMQTTTransport().sendToMQTT(ack.encode());
                            }
                        }
                    };
                }
            }
        }
        return null;
    }

    private String convertMQTTToActiveMQ(String name) {
        char[] chars = name.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': {
                    chars[i] = 62;
                    continue block8;
                }
                case '>': {
                    chars[i] = 35;
                    continue block8;
                }
                case '+': {
                    chars[i] = 42;
                    continue block8;
                }
                case '*': {
                    chars[i] = 43;
                    continue block8;
                }
                case '/': {
                    chars[i] = 46;
                    continue block8;
                }
                case '.': {
                    chars[i] = 47;
                }
            }
        }
        String rc = new String(chars);
        return rc;
    }

    public long getDefaultKeepAlive() {
        return this.defaultKeepAlive;
    }

    public void setDefaultKeepAlive(long keepAlive) {
        this.defaultKeepAlive = keepAlive;
    }

    public int getActiveMQSubscriptionPrefetch() {
        return this.activeMQSubscriptionPrefetch;
    }

    public void setActiveMQSubscriptionPrefetch(int activeMQSubscriptionPrefetch) {
        this.activeMQSubscriptionPrefetch = activeMQSubscriptionPrefetch;
    }

    public MQTTPacketIdGenerator getPacketIdGenerator() {
        return this.packetIdGenerator;
    }
}

