/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroTypeConverter;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.NullableValuesEnum;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.BaseAvroStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class AvroOutputDialog
extends BaseAvroStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = AvroOutputMeta.class;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private static final int H_OFFSET_DATETIME_COMBO_BOX = 15;
    private static final String[] SUPPORTED_AVRO_TYPE_NAMES = new String[]{AvroSpec.DataType.STRING.getName(), AvroSpec.DataType.INTEGER.getName(), AvroSpec.DataType.LONG.getName(), AvroSpec.DataType.FLOAT.getName(), AvroSpec.DataType.DOUBLE.getName(), AvroSpec.DataType.BOOLEAN.getName(), AvroSpec.DataType.DECIMAL.getName(), AvroSpec.DataType.DATE.getName(), AvroSpec.DataType.TIMESTAMP_MILLIS.getName(), AvroSpec.DataType.BYTES.getName()};
    private static final int COLUMNS_SEP = 75;
    private static final String SCHEMA_SCHEME_DEFAULT = "hdfs";
    private TableView wOutputFields;
    protected ComboVar wCompression;
    protected TextVar wRecordName;
    protected TextVar wDocValue;
    protected TextVar wNameSpace;
    protected TextVar wSchemaPath;
    protected Button wbSchemaBrowse;
    private Button wOverwriteExistingFile;
    private Button wDateInFileName;
    private Button wTimeInFileName;
    private Button wSpecifyDateTimeFormat;
    private ComboVar wDateTimeFormat;
    private AvroOutputMeta meta;

    public AvroOutputDialog(Shell parent, Object avroOutputMeta, TransMeta transMeta, String sname) {
        this(parent, (AvroOutputMeta)((Object)avroOutputMeta), transMeta, sname);
        this.meta = (AvroOutputMeta)((Object)avroOutputMeta);
    }

    public AvroOutputDialog(Shell parent, AvroOutputMeta avroOutputMeta, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)avroOutputMeta, transMeta, sname);
        this.meta = avroOutputMeta;
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        this.wOverwriteExistingFile = new Button(afterFile, 32);
        this.wOverwriteExistingFile.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.OverwriteFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wOverwriteExistingFile);
        new BaseAvroStepDialog.FD((Control)this.wOverwriteExistingFile).left(0, 0).top((Control)afterFile, 10).apply();
        this.wOverwriteExistingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.meta.setChanged();
            }
        });
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFieldsTab(wTabFolder);
        this.addSchemaTab(wTabFolder);
        this.addOptionsTab(wTabFolder);
        new BaseAvroStepDialog.FD((Control)wTabFolder).left(0, 0).top((Control)this.wOverwriteExistingFile, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"AvroOutputDialog.Shell.Title", (String[])new String[0]);
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AvroOutputDialog.this.getFields();
            }
        };
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseAvroStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Path", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Type", (String[])new String[0]), 2, SUPPORTED_AVRO_TYPE_NAMES), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Precision", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Scale", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Default", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Null", (String[])new String[0]), 2, NullableValuesEnum.getValuesArr(), true)};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, this.lsMod, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 30, 20, 10, 10, 10, 15, 5});
        this.wOutputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wOutputFields);
        new BaseAvroStepDialog.FD((Control)this.wOutputFields).left(0, 0).right(100, 0).top((Control)wComp, 0).bottom((Control)wGetFields, -10).apply();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        new BaseAvroStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wOutputFields.getTable());
        this.setTruncatedColumn(this.wOutputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wOutputFields.getTable(), 1);
        }
    }

    private void addSchemaTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.TabTitle", (String[])new String[0]));
        Composite wTabComposite = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wTabComposite);
        this.props.setLook((Control)wTabComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        wTabComposite.setLayout((Layout)formLayout);
        Group wSourceGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wSourceGroup);
        wSourceGroup.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.SourceTitle", (String[])new String[0]));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        wSourceGroup.setLayout((Layout)layout);
        FormData fdSource = new FormData();
        fdSource.top = new FormAttachment(0, 0);
        fdSource.right = new FormAttachment(100, -15);
        fdSource.left = new FormAttachment(0, 15);
        wSourceGroup.setLayoutData((Object)fdSource);
        Label wlSchemaPath = new Label((Composite)wSourceGroup, 131072);
        wlSchemaPath.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.FileName", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaPath);
        new BaseAvroStepDialog.FD((Control)wlSchemaPath).left(0, 0).top(0, 0).apply();
        this.wSchemaPath = new TextVar((VariableSpace)this.transMeta, (Composite)wSourceGroup, 18436);
        this.props.setLook((Control)this.wSchemaPath);
        new BaseAvroStepDialog.FD((Control)this.wSchemaPath).left(0, 0).top((Control)wlSchemaPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbSchemaBrowse = new Button((Composite)wSourceGroup, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbSchemaBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbSchemaBrowse.addListener(13, event -> this.browseForFileInputPathForSchema());
        int bOffset = (this.wbSchemaBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wSchemaPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new BaseAvroStepDialog.FD((Control)this.wbSchemaBrowse).left((Control)this.wSchemaPath, 5).top((Control)wlSchemaPath, 5 - bOffset).apply();
        Group wAvroDetailsGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wAvroDetailsGroup);
        wAvroDetailsGroup.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.AvroDetailsTitle", (String[])new String[0]));
        layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wSourceGroup.setLayout((Layout)layout);
        wAvroDetailsGroup.setLayout((Layout)layout);
        FormData fdAvroDetailsGroup = new FormData();
        fdAvroDetailsGroup.top = new FormAttachment((Control)wSourceGroup, 15);
        fdAvroDetailsGroup.right = new FormAttachment(100, -15);
        fdAvroDetailsGroup.left = new FormAttachment(0, 15);
        wAvroDetailsGroup.setLayoutData((Object)fdAvroDetailsGroup);
        Label wlNameSpace = new Label((Composite)wAvroDetailsGroup, 131072);
        wlNameSpace.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.Namespace", (String[])new String[0]));
        this.props.setLook((Control)wlNameSpace);
        new BaseAvroStepDialog.FD((Control)wlNameSpace).left(0, 0).top(0, 0).apply();
        this.wNameSpace = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wNameSpace);
        new BaseAvroStepDialog.FD((Control)this.wNameSpace).left(0, 0).top((Control)wlNameSpace, 5).width(250).rright().apply();
        this.wNameSpace.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.RequiredItem", (String[])new String[0]));
        Label wlRecordName = new Label((Composite)wAvroDetailsGroup, 131072);
        wlRecordName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.RecordName", (String[])new String[0]));
        this.props.setLook((Control)wlRecordName);
        new BaseAvroStepDialog.FD((Control)wlRecordName).left(0, 0).top((Control)this.wNameSpace, 10).apply();
        this.wRecordName = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wRecordName);
        new BaseAvroStepDialog.FD((Control)this.wRecordName).left(0, 0).top((Control)wlRecordName, 5).width(250).rright().apply();
        this.wRecordName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.RequiredItem", (String[])new String[0]));
        Label wlDocValue = new Label((Composite)wAvroDetailsGroup, 131072);
        wlDocValue.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.DocValue", (String[])new String[0]));
        this.props.setLook((Control)wlDocValue);
        new BaseAvroStepDialog.FD((Control)wlDocValue).left(0, 0).top((Control)this.wRecordName, 10).apply();
        this.wDocValue = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wDocValue);
        new BaseAvroStepDialog.FD((Control)this.wDocValue).left(0, 0).top((Control)wlDocValue, 5).width(250).rright().apply();
    }

    private void addOptionsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Options.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wComp);
        this.props.setLook((Control)wComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        wComp.setLayout((Layout)formLayout);
        Label lCompression = this.createLabel(wComp, "AvroOutputDialog.Options.Compression");
        new BaseAvroStepDialog.FD((Control)lCompression).left(0, 0).top((Control)wComp, 0).apply();
        this.wCompression = this.createComboVar(wComp, this.meta.getCompressionTypes());
        new BaseAvroStepDialog.FD((Control)this.wCompression).left(0, 0).top((Control)lCompression, 5).width(150 + VAR_EXTRA_WIDTH).apply();
        this.wDateInFileName = new Button(wComp, 32);
        new BaseAvroStepDialog.FD((Control)this.wDateInFileName).left(0, 0).top((Control)this.wCompression, 10).apply();
        this.props.setLook((Control)this.wDateInFileName);
        this.wDateInFileName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Options.DateInFileName", (String[])new String[0]));
        this.wDateInFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.meta.setChanged();
                boolean isSelected = AvroOutputDialog.this.wDateInFileName.getSelection();
                if (isSelected) {
                    AvroOutputDialog.this.wSpecifyDateTimeFormat.setSelection(false);
                    AvroOutputDialog.this.wDateTimeFormat.setText("");
                    AvroOutputDialog.this.wDateTimeFormat.setEnabled(false);
                }
            }
        });
        this.wTimeInFileName = new Button(wComp, 32);
        new BaseAvroStepDialog.FD((Control)this.wTimeInFileName).left(0, 0).top((Control)this.wDateInFileName, 10).apply();
        this.props.setLook((Control)this.wTimeInFileName);
        this.wTimeInFileName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Options.TimeInFileName", (String[])new String[0]));
        this.wTimeInFileName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.meta.setChanged();
                boolean isSelected = AvroOutputDialog.this.wTimeInFileName.getSelection();
                if (isSelected) {
                    AvroOutputDialog.this.wSpecifyDateTimeFormat.setSelection(false);
                    AvroOutputDialog.this.wDateTimeFormat.setText("");
                    AvroOutputDialog.this.wDateTimeFormat.setEnabled(false);
                }
            }
        });
        this.wSpecifyDateTimeFormat = new Button(wComp, 32);
        new BaseAvroStepDialog.FD((Control)this.wSpecifyDateTimeFormat).left(0, 0).top((Control)this.wTimeInFileName, 10).apply();
        this.props.setLook((Control)this.wSpecifyDateTimeFormat);
        this.wSpecifyDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Options.SpecifyDateTimeFormat", (String[])new String[0]));
        this.wSpecifyDateTimeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.meta.setChanged();
                boolean isSelected = AvroOutputDialog.this.wSpecifyDateTimeFormat.getSelection();
                AvroOutputDialog.this.wDateTimeFormat.setEnabled(isSelected);
                if (!isSelected) {
                    AvroOutputDialog.this.wDateTimeFormat.setText("");
                    AvroOutputDialog.this.wTimeInFileName.setEnabled(true);
                    AvroOutputDialog.this.wDateInFileName.setEnabled(true);
                } else {
                    AvroOutputDialog.this.wTimeInFileName.setSelection(false);
                    AvroOutputDialog.this.wDateInFileName.setSelection(false);
                    AvroOutputDialog.this.wTimeInFileName.setEnabled(false);
                    AvroOutputDialog.this.wDateInFileName.setEnabled(false);
                }
            }
        });
        String[] dates = Const.getDateFormats();
        dates = (String[])Arrays.stream(dates).filter(d -> d.indexOf(47) < 0 && d.indexOf(92) < 0 && d.indexOf(58) < 0).toArray(String[]::new);
        this.wDateTimeFormat = this.createComboVar(wComp, dates);
        new BaseAvroStepDialog.FD((Control)this.wDateTimeFormat).left(0, 15).top((Control)this.wSpecifyDateTimeFormat, 5).width(200).apply();
        this.props.setLook((Control)this.wDateTimeFormat);
    }

    protected ComboVar createComboVar(Composite container, String[] options) {
        ComboVar combo = new ComboVar((VariableSpace)this.transMeta, container, 18432);
        combo.setItems(options);
        combo.addModifyListener(this.lsMod);
        return combo;
    }

    protected String getComboVarValue(ComboVar combo) {
        String text = combo.getText();
        String data = (String)combo.getData(text);
        return data != null ? data : text;
    }

    private Label createLabel(Composite container, String labelRef) {
        Label label = new Label(container, 0);
        label.setText(BaseMessages.getString(PKG, (String)labelRef, (String[])new String[0]));
        this.props.setLook((Control)label);
        return label;
    }

    @Override
    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        List<String> validationErrorFields = this.validateOutputFields(this.wOutputFields, this.meta);
        if (validationErrorFields != null && !validationErrorFields.isEmpty()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"AvroOutput.MissingDefaultFields.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"AvroOutput.MissingDefaultFields.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(false);
        this.dispose();
    }

    @Override
    protected void getData() {
        this.wOverwriteExistingFile.setSelection(this.meta.isOverrideOutput());
        if (this.meta.getFilename() != null) {
            this.wPath.setText(this.meta.getFilename());
        }
        if (this.meta.getSchemaFilename() != null) {
            this.wSchemaPath.setText(this.meta.getSchemaFilename());
        }
        if (this.meta.getDocValue() != null) {
            this.wDocValue.setText(this.meta.getDocValue());
        }
        if (this.meta.getNamespace() != null) {
            this.wNameSpace.setText(this.meta.getNamespace());
        }
        if (this.meta.getRecordName() != null) {
            this.wRecordName.setText(this.meta.getRecordName());
        }
        this.populateFieldsUI(this.meta, this.wOutputFields);
        this.wCompression.setText(this.meta.getCompressionType());
        String dateTimeFormat = this.coalesce(this.meta.getDateTimeFormat());
        if (!dateTimeFormat.isEmpty()) {
            this.wTimeInFileName.setSelection(false);
            this.wDateInFileName.setSelection(false);
            this.wTimeInFileName.setEnabled(false);
            this.wDateInFileName.setEnabled(false);
            this.wSpecifyDateTimeFormat.setSelection(true);
            this.wDateTimeFormat.setText(dateTimeFormat);
            this.wDateTimeFormat.setEnabled(true);
        } else {
            this.wTimeInFileName.setEnabled(true);
            this.wDateInFileName.setEnabled(true);
            this.wTimeInFileName.setSelection(this.meta.isTimeInFileName());
            this.wDateInFileName.setSelection(this.meta.isDateInFileName());
            this.wSpecifyDateTimeFormat.setSelection(false);
            this.wDateTimeFormat.setEnabled(false);
            this.wDateTimeFormat.setText("");
        }
    }

    @Override
    protected void getInfo(boolean preview) {
        this.meta.setOverrideOutput(this.wOverwriteExistingFile.getSelection());
        this.meta.setFilename(this.wPath.getText());
        this.meta.setDocValue(this.wDocValue.getText());
        this.meta.setNamespace(this.wNameSpace.getText());
        this.meta.setRecordName(this.wRecordName.getText());
        this.meta.setSchemaFilename(this.wSchemaPath.getText());
        this.meta.setCompressionType(this.wCompression.getText());
        int nrFields = this.wOutputFields.nrNonEmpty();
        ArrayList<AvroOutputField> outputFields = new ArrayList<AvroOutputField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wOutputFields.getNonEmpty(i);
            int j = 1;
            AvroOutputField field = new AvroOutputField();
            field.setFormatFieldName(item.getText(j++));
            field.setPentahoFieldName(item.getText(j++));
            field.setFormatType(item.getText(j++));
            if (field.getAvroType().equals((Object)AvroSpec.DataType.DECIMAL)) {
                field.setPrecision(item.getText(j++));
                field.setScale(item.getText(j++));
            } else if (field.getAvroType().equals((Object)AvroSpec.DataType.FLOAT) || field.getAvroType().equals((Object)AvroSpec.DataType.DOUBLE)) {
                int n = ++j;
                field.setScale(item.getText(n));
            } else {
                j += 2;
            }
            int n = ++j;
            field.setDefaultValue(item.getText(n));
            int n2 = ++j;
            ++j;
            field.setAllowNull(this.getNullableValue(item.getText(n2)));
            outputFields.add(field);
        }
        if (this.wSpecifyDateTimeFormat.getSelection()) {
            this.meta.setTimeInFileName(false);
            this.meta.setDateInFileName(false);
            this.meta.setDateTimeFormat(this.wDateTimeFormat.getText().trim());
        } else {
            this.meta.setTimeInFileName(this.wTimeInFileName.getSelection());
            this.meta.setDateInFileName(this.wDateInFileName.getSelection());
            this.meta.setDateTimeFormat("");
        }
        this.meta.setOutputFields(outputFields);
    }

    private List<String> validateOutputFields(TableView wFields, AvroOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<String> validationErrorFields = new ArrayList<String>();
        for (int i = 0; i < nrFields; ++i) {
            String nullString;
            String scale;
            String precision;
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            String path = item.getText(j++);
            String name = item.getText(j++);
            String type = item.getText(j++);
            if ((precision = item.getText(j++)) == null || precision.trim().isEmpty()) {
                item.setText(4, Integer.toString(10));
            }
            if ((scale = item.getText(j++)) == null || scale.trim().isEmpty()) {
                item.setText(5, Integer.toString(0));
            }
            String defaultValue = item.getText(j++);
            if (!(nullString = this.getNullableValue(item.getText(j++))).equals(NullableValuesEnum.NO.getValue()) || defaultValue != null && !defaultValue.trim().isEmpty()) continue;
            validationErrorFields.add(name);
        }
        return validationErrorFields;
    }

    private String getNullableValue(String nullString) {
        return nullString != null && !nullString.isEmpty() ? nullString : NullableValuesEnum.getDefaultValue().getValue();
    }

    private void populateFieldsUI(AvroOutputMeta meta, TableView wOutputFields) {
        this.populateFieldsUI(meta.getOutputFields(), wOutputFields, (field, item) -> {
            int i = 1;
            item.setText(i++, this.coalesce(field.getFormatFieldName()));
            item.setText(i++, this.coalesce(field.getPentahoFieldName()));
            item.setText(i++, this.coalesce(field.getAvroType().getName()));
            if (field.getAvroType().equals((Object)AvroSpec.DataType.DECIMAL)) {
                item.setText(i++, this.coalesce(String.valueOf(field.getPrecision())));
                item.setText(i++, this.coalesce(String.valueOf(field.getScale())));
            } else if (field.getAvroType().equals((Object)AvroSpec.DataType.FLOAT) || field.getAvroType().equals((Object)AvroSpec.DataType.DOUBLE)) {
                int n = ++i;
                ++i;
                item.setText(n, field.getScale() > 0 ? String.valueOf(field.getScale()) : "");
            } else {
                i += 2;
            }
            item.setText(i++, this.coalesce(field.getDefaultValue()));
            item.setText(i++, field.getAllowNull() ? NullableValuesEnum.YES.getValue() : NullableValuesEnum.NO.getValue());
        });
    }

    private String coalesce(String value) {
        return value == null ? "" : value;
    }

    private void populateFieldsUI(List<AvroOutputField> fields, TableView wFields, BiConsumer<AvroOutputField, TableItem> converter) {
        int nrFields = fields.size();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = null;
            item = i < wFields.table.getItemCount() ? wFields.table.getItem(i) : new TableItem(wFields.table, 0);
            converter.accept(fields.get(i), item);
        }
    }

    protected void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        return true;
                    }
                };
                this.getFieldsFromPreviousStep(r, this.wOutputFields, 1, new int[]{1, 2}, new int[]{3}, 4, 5, true, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private String getSchemeFromPath(String path) {
        if (Utils.isEmpty((CharSequence)path)) {
            return SCHEMA_SCHEME_DEFAULT;
        }
        int endIndex = path.indexOf(58);
        if (endIndex > 0) {
            return path.substring(0, endIndex);
        }
        return SCHEMA_SCHEME_DEFAULT;
    }

    private MessageDialog getFieldsChoiceDialog(Shell shell, int existingFields, int newFields) {
        MessageDialog messageDialog = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetFieldsChoice.Message", (String[])new String[]{"" + existingFields, "" + newFields}), 4, new String[]{BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.Cancel", (String[])new String[0])}, 0);
        MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
        return messageDialog;
    }

    private void getFieldsFromPreviousStep(RowMetaInterface row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, boolean optimizeWidth, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Utils.isEmpty((CharSequence)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (keys.size() > 0) {
            MessageDialog getFieldsChoiceDialog = this.getFieldsChoiceDialog(tableView.getShell(), keys.size(), row.size());
            int idx = getFieldsChoiceDialog.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (int c = 0; c < nameColumn.length; ++c) {
                tableItem.setText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            String avroTypeName = AvroTypeConverter.convertToAvroType((int)v.getType());
            if (dataTypeColumn != null) {
                for (int c = 0; c < dataTypeColumn.length; ++c) {
                    tableItem.setText(dataTypeColumn[c], avroTypeName);
                }
            }
            if (avroTypeName.equals(AvroSpec.DataType.DECIMAL.getName())) {
                if (lengthColumn > 0 && v.getLength() > 0) {
                    tableItem.setText(lengthColumn, Integer.toString(v.getLength()));
                } else {
                    tableItem.setText(lengthColumn, Integer.toString(10));
                }
                if (precisionColumn > 0 && v.getPrecision() >= 0) {
                    tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
                } else {
                    tableItem.setText(precisionColumn, Integer.toString(0));
                }
            } else if ((avroTypeName.equals(AvroSpec.DataType.FLOAT.getName()) || avroTypeName.equals(AvroSpec.DataType.DOUBLE.getName())) && precisionColumn > 0 && v.getPrecision() > 0) {
                tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        if (optimizeWidth) {
            tableView.optWidth(true);
        }
    }

    private void browseForFileInputPathForSchema() {
        try {
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.transMeta.environmentSubstitute(this.wSchemaPath.getText());
            if (Utils.isEmpty((CharSequence)path)) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = "hdfs://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wSchemaPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.shell, null, this.getSchemeFromPath(path), true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null) {
                this.wSchemaPath.setText(selectedFile.getURL().toString());
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.FileSystemException"));
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected Listener getPreview() {
        return null;
    }
}

