/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroLookupField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.BaseAvroStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.VFSScheme;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class AvroInputDialog
extends BaseAvroStepDialog {
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private static final int AVRO_ORIGINAL_PATH_COLUMN_INDEX = 1;
    private static final int AVRO_DISPLAY_PATH_COLUMN_INDEX = 2;
    private static final int AVRO_TYPE_COLUMN_INDEX = 3;
    private static final int AVRO_INDEXED_VALUES_COLUMN_INDEX = 4;
    private static final int FIELD_NAME_COLUMN_INDEX = 5;
    private static final int FIELD_TYPE_COLUMN_INDEX = 6;
    private static final int FORMAT_COLUMN_INDEX = 7;
    private static final String SCHEMA_SCHEME_DEFAULT = "hdfs";
    private TableView wInputFields;
    protected Button wbSchemaBrowse;
    protected Composite wSchemaFileComposite;
    protected Composite wSchemaFieldComposite;
    protected Group wSourceGroup;
    Button wbGetSchemaFromFile;
    Button wbGetSchemaFromField;
    private Button m_getLookupFieldsBut;
    ComboVar wSchemaFieldNameCombo;
    private TableView m_lookupView;
    private AvroInputMeta meta;
    private Button wPassThruFields;
    private Button wAllowNullValues;
    private VFSScheme selectedSchemaVFSScheme;
    private TextVar wSchemaPath;
    private CCombo wSchemaLocation;

    public AvroInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)((AvroInputMeta)((Object)in)), transMeta, sname);
        this.meta = (AvroInputMeta)((Object)in);
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addSourceTab(wTabFolder);
        this.addFieldsTab(wTabFolder);
        this.addLookupFieldsTab(wTabFolder);
        new BaseAvroStepDialog.FD((Control)wTabFolder).left(0, 0).top(0, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    protected void populateNestedFieldsTable() {
        String schemaFileName = this.wSchemaPath.getText();
        schemaFileName = this.transMeta.environmentSubstitute(schemaFileName);
        String avroFileName = this.wPath.getText();
        avroFileName = this.transMeta.environmentSubstitute(avroFileName);
        List<? extends IAvroInputField> defaultFields = null;
        try {
            defaultFields = AvroInput.getLeafFields(this.meta.getNamedClusterServiceLocator(), this.meta.getNamedCluster(), schemaFileName, avroFileName);
            if (defaultFields != null) {
                this.wInputFields.clearAll();
                for (IAvroInputField iAvroInputField : defaultFields) {
                    TableItem item = new TableItem(this.wInputFields.table, 0);
                    if (iAvroInputField == null) continue;
                    this.setField(item, iAvroInputField.getDisplayableAvroFieldName(), 1);
                    this.setField(item, this.clearIndexFromFieldName(iAvroInputField.getDisplayableAvroFieldName()), 2);
                    this.setField(item, iAvroInputField.getAvroType().getName(), 3);
                    this.setField(item, iAvroInputField.getIndexedValues(), 4);
                    this.setField(item, iAvroInputField.getPentahoFieldName(), 5);
                    this.setField(item, ValueMetaFactory.getValueMetaName((int)iAvroInputField.getPentahoType()), 6);
                    this.setField(item, iAvroInputField.getStringFormat(), 7);
                }
                this.wInputFields.removeEmptyRows();
                this.wInputFields.setRowNums();
                this.wInputFields.optWidth(true);
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString((Class)this.PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[0]), ex);
            new ErrorDialog(this.shell, this.stepname, BaseMessages.getString((Class)this.PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[]{avroFileName}), ex);
        }
    }

    private void setField(TableItem item, String fieldValue, int fieldIndex) {
        if (!Utils.isEmpty((CharSequence)fieldValue)) {
            item.setText(fieldIndex, fieldValue);
        }
    }

    private void addLookupFieldsTab(CTabFolder wTabFolder) {
        CTabItem m_wVarsTab = new CTabItem(wTabFolder, 0);
        m_wVarsTab.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.VarsTab.Title", (String[])new String[0]));
        Composite wVarsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wVarsComp);
        FormLayout varsLayout = new FormLayout();
        varsLayout.marginWidth = 15;
        varsLayout.marginHeight = 15;
        wVarsComp.setLayout((Layout)varsLayout);
        this.m_getLookupFieldsBut = new Button(wVarsComp, 0x1000008);
        this.m_getLookupFieldsBut.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Button.GetLookupFields", (String[])new String[0]));
        new BaseAvroStepDialog.FD((Control)this.m_getLookupFieldsBut).bottom(100, -8).right(100, 0).apply();
        this.m_getLookupFieldsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.getIncomingFields();
            }
        });
        ColumnInfo[] colinf2 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.LOOKUP_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.LOOKUP_VARIABLE", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.LOOKUP_DEFAULT_VALUE", (String[])new String[0]), 1, false)};
        colinf2[0].setAutoResize(false);
        colinf2[1].setAutoResize(false);
        colinf2[2].setAutoResize(false);
        this.m_lookupView = new TableView((VariableSpace)this.transMeta, wVarsComp, 67586, colinf2, 1, this.lsMod, this.props);
        new BaseAvroStepDialog.FD((Control)this.m_lookupView).top(0, 8).bottom((Control)this.m_getLookupFieldsBut, -8).left(0, 0).right(100, 0).apply();
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 33, 33, 34});
        resizer.addColumnResizeListeners(this.m_lookupView.getTable());
        this.m_lookupView.getTable().addListener(11, (Listener)resizer);
        this.m_lookupView.optWidth(true);
        m_wVarsTab.setControl((Control)wVarsComp);
    }

    private void getIncomingFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.m_lookupView, (int)1, (int[])new int[]{1}, null, (int)-1, (int)-1, null);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.marginBottom = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.populateNestedFieldsTable();
            }
        };
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseAvroStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo avroOriginalPathColumnInfo = new ColumnInfo("Original Avro Path", 1, false, true);
        ColumnInfo avroDisplayPathColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Path", (String[])new String[0]), 0, false, true);
        ColumnInfo avroTypeColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.avro.type", (String[])new String[0]), 1, false, true);
        ColumnInfo avroIndexColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.avro.indexedValues", (String[])new String[0]), 1, false, false);
        ColumnInfo nameColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo typeColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        ColumnInfo formatColumnInfo = new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Fields.column.Format", (String[])new String[0]), 2, Const.getDateFormats());
        ColumnInfo[] parameterColumns = new ColumnInfo[]{avroOriginalPathColumnInfo, avroDisplayPathColumnInfo, avroTypeColumnInfo, avroIndexColumnInfo, nameColumnInfo, typeColumnInfo, formatColumnInfo};
        parameterColumns[1].setAutoResize(false);
        parameterColumns[3].setAutoResize(false);
        parameterColumns[4].setUsingVariables(true);
        parameterColumns[6].setAutoResize(false);
        this.wInputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 8, null, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 0, 20, 15, 15, 20, 15, 15});
        this.wInputFields.getTable().addListener(11, (Listener)resizer);
        new BaseAvroStepDialog.FD((Control)this.wInputFields).left(0, 0).right(100, 0).top(0, 8).bottom((Control)wGetFields, -10).apply();
        this.wInputFields.setRowNums();
        this.wInputFields.optWidth(true);
        this.wPassThruFields = new Button(wComp, 32);
        this.wPassThruFields.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PassThruFields.Label", (String[])new String[0]));
        this.wPassThruFields.setToolTipText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PassThruFields.Tooltip", (String[])new String[0]));
        this.wPassThruFields.setOrientation(0x2000000);
        this.props.setLook((Control)this.wPassThruFields);
        new BaseAvroStepDialog.FD((Control)this.wPassThruFields).left(0, 0).top((Control)this.wInputFields, 10).apply();
        this.wAllowNullValues = new Button(wComp, 32);
        this.wAllowNullValues.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.AllowNullValues.Label", (String[])new String[0]));
        this.wAllowNullValues.setOrientation(0x2000000);
        this.props.setLook((Control)this.wAllowNullValues);
        new BaseAvroStepDialog.FD((Control)this.wAllowNullValues).left(0, 0).top((Control)this.wPassThruFields, 5).apply();
        new BaseAvroStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wInputFields.getTable());
        this.setTruncatedColumn(this.wInputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wInputFields.getTable(), 1);
        }
        this.wInputFields.getColumns()[4].setAutoResize(true);
    }

    protected void addSourceTab(CTabFolder wTabFolder) {
        AvroInputMeta avroBaseMeta = this.meta;
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(this.getBaseMsg("AvroDialog.File.TabTitle"));
        Composite wTabComposite = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wTabComposite);
        this.props.setLook((Control)wTabComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        wTabComposite.setLayout((Layout)formLayout);
        Label encodingLabel = new Label(wTabComposite, 0);
        encodingLabel.setText(this.getBaseMsg("AvroDialog.Encoding.Label"));
        new BaseAvroStepDialog.FD((Control)encodingLabel).top(0, 0).right(100, -15).left(0, 15).apply();
        this.encodingCombo = new CCombo(wTabComposite, 2056);
        String[] availFormats = new String[]{BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.AvroFile.Label", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.JsonDatum.Label", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.BinaryDatum.Label", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.AvroFile.AlternateSchema.Label", (String[])new String[0])};
        this.encodingCombo.setItems(availFormats);
        this.encodingCombo.select(0);
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wSourceGroup.setVisible(AvroInputDialog.this.encodingCombo.getSelectionIndex() > 0);
            }
        });
        new BaseAvroStepDialog.FD((Control)this.encodingCombo).top((Control)encodingLabel, 5).left(0, 15).right(0, 215).apply();
        Group wFileSettingsGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wFileSettingsGroup);
        wFileSettingsGroup.setText(this.getBaseMsg("AvroDialog.File.FileSettingsTitle"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        wFileSettingsGroup.setLayout((Layout)layout);
        new BaseAvroStepDialog.FD((Control)wFileSettingsGroup).top((Control)encodingLabel, 35).left(0, 15).right(0, 635).apply();
        int RADIO_BUTTON_WIDTH = 150;
        Label separator = new Label((Composite)wFileSettingsGroup, 514);
        this.props.setLook((Control)separator);
        new BaseAvroStepDialog.FD((Control)separator).left(0, RADIO_BUTTON_WIDTH).top(0, 0).bottom(100, 0).apply();
        this.wbGetDataFromFile = new Button((Composite)wFileSettingsGroup, 16);
        this.wbGetDataFromFile.setText(this.getBaseMsg("AvroDialog.File.SpecifyFileName"));
        this.props.setLook((Control)this.wbGetDataFromFile);
        new BaseAvroStepDialog.FD((Control)this.wbGetDataFromFile).left(0, 0).top(0, 0).width(RADIO_BUTTON_WIDTH).apply();
        this.wbGetDataFromField = new Button((Composite)wFileSettingsGroup, 16);
        this.wbGetDataFromField.setText(this.getBaseMsg("AvroDialog.File.GetDataFromField"));
        this.props.setLook((Control)this.wbGetDataFromField);
        new BaseAvroStepDialog.FD((Control)this.wbGetDataFromField).left(0, 0).top((Control)this.wbGetDataFromFile, 10).width(RADIO_BUTTON_WIDTH).apply();
        Composite wFileSettingsDynamicArea = new Composite((Composite)wFileSettingsGroup, 0);
        this.props.setLook((Control)wFileSettingsDynamicArea);
        FormLayout fileSettingsDynamicAreaLayout = new FormLayout();
        wFileSettingsDynamicArea.setLayout((Layout)fileSettingsDynamicAreaLayout);
        new BaseAvroStepDialog.FD((Control)wFileSettingsDynamicArea).right(100, 0).left((Control)this.wbGetDataFromFile, 15).top(0, -15).apply();
        this.wDataFileComposite = new Composite(wFileSettingsDynamicArea, 0);
        FormLayout fileSettingLayout = new FormLayout();
        this.wDataFileComposite.setLayout((Layout)fileSettingLayout);
        new BaseAvroStepDialog.FD((Control)this.wDataFileComposite).left(0, 0).right(100, RADIO_BUTTON_WIDTH + 15 - 15).top(0, 0).apply();
        this.addFileWidgets(this.wDataFileComposite, (Control)this.wDataFileComposite);
        this.wDataFieldComposite = new Composite(wFileSettingsDynamicArea, 0);
        this.props.setLook((Control)this.wDataFieldComposite);
        FormLayout fieldNameLayout = new FormLayout();
        fieldNameLayout.marginHeight = 15;
        this.wDataFieldComposite.setLayout((Layout)fieldNameLayout);
        new BaseAvroStepDialog.FD((Control)this.wDataFieldComposite).left(0, 0).top(0, 0).apply();
        Label fieldNameLabel = new Label(this.wDataFieldComposite, 0);
        fieldNameLabel.setText(this.getBaseMsg("AvroDialog.FieldName.Label"));
        this.props.setLook((Control)fieldNameLabel);
        new BaseAvroStepDialog.FD((Control)fieldNameLabel).left(0, 0).top((Control)this.wDataFieldComposite, 0).apply();
        this.wFieldNameCombo = new ComboVar((VariableSpace)this.transMeta, this.wDataFieldComposite, 18432);
        this.updateIncomingFieldList(this.wFieldNameCombo);
        new BaseAvroStepDialog.FD((Control)this.wFieldNameCombo).left(0, 0).top((Control)fieldNameLabel, 5).width(250).apply();
        SelectionAdapter fileSettingRadioSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wDataFileComposite.setVisible(!AvroInputDialog.this.wbGetDataFromField.getSelection());
                AvroInputDialog.this.wDataFieldComposite.setVisible(AvroInputDialog.this.wbGetDataFromField.getSelection());
            }
        };
        this.wbGetDataFromFile.addSelectionListener((SelectionListener)fileSettingRadioSelectionAdapter);
        this.wbGetDataFromField.addSelectionListener((SelectionListener)fileSettingRadioSelectionAdapter);
        this.wbGetDataFromFile.setSelection(avroBaseMeta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        this.wbGetDataFromField.setSelection(avroBaseMeta.getDataLocationType() != AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        fileSettingRadioSelectionAdapter.widgetSelected(null);
        this.wFieldNameCombo.setText(avroBaseMeta.getDataLocationType() != AvroInputMetaBase.LocationDescriptor.FIELD_NAME ? "" : avroBaseMeta.getDataLocation());
        this.wSourceGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)this.wSourceGroup);
        this.wSourceGroup.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Schema.SourceTitle", (String[])new String[0]));
        FormLayout schemaLayout = new FormLayout();
        schemaLayout.marginWidth = 15;
        schemaLayout.marginHeight = 15;
        this.wSourceGroup.setLayout((Layout)schemaLayout);
        new BaseAvroStepDialog.FD((Control)this.wSourceGroup).top((Control)wFileSettingsGroup, 10).right(100, -15).left(0, 15).apply();
        Label schemaSeparator = new Label((Composite)this.wSourceGroup, 514);
        this.props.setLook((Control)schemaSeparator);
        new BaseAvroStepDialog.FD((Control)schemaSeparator).left(0, RADIO_BUTTON_WIDTH).top(0, 0).bottom(100, 0).apply();
        this.wbGetSchemaFromFile = new Button((Composite)this.wSourceGroup, 16);
        this.wbGetSchemaFromFile.setText(this.getBaseMsg("AvroDialog.File.SpecifyFileName"));
        this.props.setLook((Control)this.wbGetSchemaFromFile);
        new BaseAvroStepDialog.FD((Control)this.wbGetSchemaFromFile).left(0, 0).top(0, 0).width(RADIO_BUTTON_WIDTH).apply();
        this.wbGetSchemaFromField = new Button((Composite)this.wSourceGroup, 16);
        this.wbGetSchemaFromField.setText(this.getBaseMsg("AvroDialog.File.GetDataFromField"));
        this.props.setLook((Control)this.wbGetSchemaFromField);
        new BaseAvroStepDialog.FD((Control)this.wbGetSchemaFromField).left(0, 0).top((Control)this.wbGetSchemaFromFile, 10).width(RADIO_BUTTON_WIDTH).apply();
        Composite wSchemaSettingsDynamicArea = new Composite((Composite)this.wSourceGroup, 0);
        this.props.setLook((Control)wSchemaSettingsDynamicArea);
        FormLayout fileSettingsDynamicAreaSchemaLayout = new FormLayout();
        wSchemaSettingsDynamicArea.setLayout((Layout)fileSettingsDynamicAreaSchemaLayout);
        new BaseAvroStepDialog.FD((Control)wSchemaSettingsDynamicArea).right(100, 0).left((Control)this.wbGetSchemaFromFile, 15).top(0, -15).apply();
        this.wSchemaFileComposite = new Composite(wSchemaSettingsDynamicArea, 0);
        FormLayout schemaFileLayout = new FormLayout();
        this.wSchemaFileComposite.setLayout((Layout)schemaFileLayout);
        new BaseAvroStepDialog.FD((Control)this.wSchemaFileComposite).left(0, 0).right(100, RADIO_BUTTON_WIDTH + 15 - 15).top(0, 0).apply();
        Label wlLocation = new Label(this.wSchemaFileComposite, 131072);
        wlLocation.setText(this.getBaseMsg("AvroDialog.Location.Label"));
        this.props.setLook((Control)wlLocation);
        new BaseAvroStepDialog.FD((Control)wlLocation).left(0, 0).top(0, 15).apply();
        this.wSchemaLocation = new CCombo(this.wSchemaFileComposite, 2056);
        try {
            List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
            availableVFSSchemes.forEach(scheme -> this.wSchemaLocation.add(scheme.getSchemeName()));
            this.wSchemaLocation.addListener(13, event -> {
                this.selectedSchemaVFSScheme = (VFSScheme)availableVFSSchemes.get(this.wSchemaLocation.getSelectionIndex());
                this.wSchemaPath.setText("");
            });
            if (!availableVFSSchemes.isEmpty()) {
                this.wSchemaLocation.select(0);
                this.selectedSchemaVFSScheme = availableVFSSchemes.get(this.wSchemaLocation.getSelectionIndex());
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("AvroDialog.FileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("AvroDialog.FileBrowser.FileSystemException"));
        }
        this.wSchemaLocation.addModifyListener(this.lsMod);
        new BaseAvroStepDialog.FD((Control)this.wSchemaLocation).left(0, 0).top((Control)wlLocation, 5).width(150).apply();
        Label wlSchemaPath = new Label(this.wSchemaFileComposite, 131072);
        wlSchemaPath.setText(BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Schema.FileName", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaPath);
        new BaseAvroStepDialog.FD((Control)wlSchemaPath).left(0, 0).top((Control)this.wSchemaLocation, 15).apply();
        this.wSchemaPath = new TextVar((VariableSpace)this.transMeta, this.wSchemaFileComposite, 18436);
        this.props.setLook((Control)this.wSchemaPath);
        new BaseAvroStepDialog.FD((Control)this.wSchemaPath).left(0, 0).top((Control)wlSchemaPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbSchemaBrowse = new Button(this.wSchemaFileComposite, 8);
        this.props.setLook((Control)this.wbSchemaBrowse);
        this.wbSchemaBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbSchemaBrowse.addListener(13, event -> this.browseForFileInputPathForSchema());
        int bOffset = (this.wbSchemaBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wSchemaPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new BaseAvroStepDialog.FD((Control)this.wbSchemaBrowse).left((Control)this.wSchemaPath, 5).top((Control)wlSchemaPath, 5 - bOffset).apply();
        this.wSchemaFieldComposite = new Composite(wSchemaSettingsDynamicArea, 0);
        FormLayout schemaFieldLayout = new FormLayout();
        this.wSchemaFieldComposite.setLayout((Layout)schemaFieldLayout);
        new BaseAvroStepDialog.FD((Control)this.wSchemaFieldComposite).left(0, 0).right(100, RADIO_BUTTON_WIDTH + 15 - 15).top(0, 0).apply();
        Label fieldNameSchemaLabel = new Label(this.wSchemaFieldComposite, 0);
        fieldNameSchemaLabel.setText(this.getBaseMsg("AvroDialog.FieldName.Label"));
        this.props.setLook((Control)fieldNameSchemaLabel);
        new BaseAvroStepDialog.FD((Control)fieldNameSchemaLabel).left(0, 0).top(0, 15).apply();
        this.wSchemaFieldNameCombo = new ComboVar((VariableSpace)this.transMeta, this.wSchemaFieldComposite, 18432);
        this.updateIncomingFieldList(this.wSchemaFieldNameCombo);
        new BaseAvroStepDialog.FD((Control)this.wSchemaFieldNameCombo).left(0, 0).top((Control)fieldNameSchemaLabel, 5).width(250).apply();
        SelectionAdapter fileSettingRadioSelectionSchemaAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.wSchemaFileComposite.setVisible(!AvroInputDialog.this.wbGetSchemaFromField.getSelection());
                AvroInputDialog.this.wSchemaFieldComposite.setVisible(AvroInputDialog.this.wbGetSchemaFromField.getSelection());
            }
        };
        this.wbGetSchemaFromFile.addSelectionListener((SelectionListener)fileSettingRadioSelectionSchemaAdapter);
        this.wbGetSchemaFromField.addSelectionListener((SelectionListener)fileSettingRadioSelectionSchemaAdapter);
        this.wbGetSchemaFromFile.setSelection(true);
        this.wbGetSchemaFromField.setSelection(false);
        this.wSchemaFileComposite.setVisible(true);
        this.wSchemaFieldComposite.setVisible(false);
        this.wSourceGroup.setVisible(false);
    }

    private void browseForFileInputPathForSchema() {
        try {
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.transMeta.environmentSubstitute(this.wSchemaPath.getText());
            if (Utils.isEmpty((CharSequence)path)) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = this.selectedSchemaVFSScheme.getScheme() + "://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wSchemaPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.shell, null, this.selectedSchemaVFSScheme.getScheme(), true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null) {
                this.wSchemaPath.setText(selectedFile.getURL().toString());
                this.updateSchemaLocation();
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.FileSystemException"));
        }
    }

    @Override
    protected void getData() {
        AvroInputMeta meta = (AvroInputMeta)this.getStepMeta();
        this.wPath.setText("");
        this.wFieldNameCombo.setText("");
        this.wSchemaPath.setText("");
        this.wbGetDataFromFile.setSelection(true);
        this.wbGetDataFromField.setSelection(false);
        this.wDataFileComposite.setVisible(true);
        this.wDataFieldComposite.setVisible(false);
        this.encodingCombo.select(meta.getFormat());
        this.wbGetSchemaFromFile.setSelection(true);
        this.wbGetSchemaFromField.setSelection(false);
        this.wSchemaFileComposite.setVisible(true);
        this.wSchemaFieldComposite.setVisible(false);
        this.wSourceGroup.setVisible(meta.getFormat() > 0);
        if (meta.getDataLocation() != null) {
            if (meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
                this.wPath.setText(meta.getDataLocation());
            } else if (meta.getDataLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
                this.wFieldNameCombo.setText(meta.getDataLocation());
                this.wbGetDataFromFile.setSelection(false);
                this.wbGetDataFromField.setSelection(true);
                this.wDataFileComposite.setVisible(false);
                this.wDataFieldComposite.setVisible(true);
            }
        }
        if (meta.getSchemaLocation() != null) {
            if (meta.getSchemaLocationType() == AvroInputMetaBase.LocationDescriptor.FILE_NAME) {
                this.wSchemaPath.setText(meta.getSchemaLocation());
            } else if (meta.getSchemaLocationType() == AvroInputMetaBase.LocationDescriptor.FIELD_NAME) {
                this.wSchemaFieldNameCombo.setText(meta.getSchemaLocation());
                this.wbGetSchemaFromFile.setSelection(false);
                this.wbGetSchemaFromField.setSelection(true);
                this.wSchemaFileComposite.setVisible(false);
                this.wSchemaFieldComposite.setVisible(true);
            }
        }
        this.wPassThruFields.setSelection(meta.passingThruFields);
        this.wAllowNullValues.setSelection(meta.isAllowNullForMissingFields());
        int itemIndex = 0;
        for (AvroInputField inputField : meta.getInputFields()) {
            TableItem item = null;
            item = itemIndex < this.wInputFields.table.getItemCount() ? this.wInputFields.table.getItem(itemIndex) : new TableItem(this.wInputFields.table, 0);
            if (inputField.getAvroFieldName() != null) {
                item.setText(1, inputField.getDisplayableAvroFieldName());
                item.setText(2, this.clearIndexFromFieldName(inputField.getDisplayableAvroFieldName()));
            }
            if (inputField.getAvroType() != null) {
                item.setText(3, inputField.getAvroType().getName());
            }
            if (inputField.getIndexedValues() != null) {
                item.setText(4, inputField.getIndexedValues());
            }
            if (inputField.getPentahoFieldName() != null) {
                item.setText(5, inputField.getPentahoFieldName());
            }
            if (inputField.getTypeDesc() != null) {
                item.setText(6, inputField.getTypeDesc());
            }
            if (inputField.getStringFormat() != null) {
                item.setText(7, inputField.getStringFormat());
            } else {
                item.setText(7, "");
            }
            ++itemIndex;
        }
        this.setVariableTableFields(meta.getLookupFields());
    }

    protected void setVariableTableFields(List<AvroLookupField> fields) {
        this.m_lookupView.clearAll();
        for (AvroLookupField f : fields) {
            TableItem item = new TableItem(this.m_lookupView.table, 0);
            if (!Const.isEmpty((String)f.fieldName)) {
                item.setText(1, f.fieldName);
            }
            if (!Const.isEmpty((String)f.variableName)) {
                item.setText(2, f.variableName);
            }
            if (Const.isEmpty((String)f.defaultValue)) continue;
            item.setText(3, f.defaultValue);
        }
        this.m_lookupView.removeEmptyRows();
        this.m_lookupView.setRowNums();
        this.m_lookupView.optWidth(true);
    }

    @Override
    protected void getInfo(boolean preview) {
        if (this.wbGetDataFromField.getSelection()) {
            this.meta.setDataLocation(this.wFieldNameCombo.getText(), AvroInputMetaBase.LocationDescriptor.FIELD_NAME);
        } else {
            this.meta.setDataLocation(this.wPath.getText(), AvroInputMetaBase.LocationDescriptor.FILE_NAME);
        }
        if (this.wbGetSchemaFromField.getSelection()) {
            this.meta.setSchemaLocation(this.wSchemaFieldNameCombo.getText(), AvroInputMetaBase.LocationDescriptor.FIELD_NAME);
        } else {
            this.meta.setSchemaLocation(this.wSchemaPath.getText(), AvroInputMetaBase.LocationDescriptor.FILE_NAME);
            this.meta.setCacheSchemas(false);
        }
        this.meta.passingThruFields = this.wPassThruFields.getSelection();
        this.meta.setAllowNullForMissingFields(this.wAllowNullValues.getSelection());
        this.meta.setFormat(this.encodingCombo.getSelectionIndex());
        int nrFields = this.wInputFields.nrNonEmpty();
        this.meta.inputFields = new AvroInputField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wInputFields.getNonEmpty(i);
            AvroInputField field = new AvroInputField();
            String formatFieldName = this.extractFieldName(item.getText(1));
            formatFieldName = this.fixPath(formatFieldName, item);
            field.setFormatFieldName(formatFieldName);
            field.setAvroType(item.getText(3));
            field.setIndexedValues(item.getText(4));
            field.setPentahoFieldName(item.getText(5));
            field.setPentahoType(ValueMetaFactory.getIdForValueMeta((String)item.getText(6)));
            field.setStringFormat(item.getText(7));
            this.meta.inputFields[i] = field;
        }
        nrFields = this.m_lookupView.nrNonEmpty();
        if (nrFields > 0) {
            ArrayList<AvroLookupField> varFields = new ArrayList<AvroLookupField>();
            for (int i = 0; i < nrFields; ++i) {
                TableItem item = this.m_lookupView.getNonEmpty(i);
                AvroLookupField newField = new AvroLookupField();
                boolean add = false;
                newField.fieldName = item.getText(1).trim();
                if (!Const.isEmpty((String)item.getText(2))) {
                    newField.variableName = item.getText(2).trim();
                    add = true;
                    if (!Const.isEmpty((String)item.getText(3))) {
                        newField.defaultValue = item.getText(3).trim();
                    }
                }
                if (!add) continue;
                varFields.add(newField);
            }
            this.meta.setLookupFields(varFields);
        }
    }

    private String fixPath(String formatFieldName, TableItem item) {
        String value = formatFieldName;
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(value);
        while (m.find()) {
            if (m.end() - m.start() < 3) {
                value = new StringBuilder(value).insert(m.start() + 1, item.getText(4)).toString();
                continue;
            }
            value = value.replace(m.group(1), item.getText(4));
        }
        return value;
    }

    private String extractFieldName(String parquetNameTypeFromUI) {
        if (parquetNameTypeFromUI != null && parquetNameTypeFromUI.indexOf("(") >= 0) {
            return StringUtils.substringBefore((String)parquetNameTypeFromUI, (String)"(").trim();
        }
        return parquetNameTypeFromUI;
    }

    private void doPreview() {
        this.getInfo(true);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)this.meta, (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    private String clearIndexFromFieldName(String fieldName) {
        String cleanFieldName = fieldName;
        int bracketPos = cleanFieldName.indexOf("[");
        if (bracketPos > -1) {
            int closeBracketPos = cleanFieldName.indexOf("]");
            cleanFieldName = cleanFieldName.substring(0, bracketPos + 1) + cleanFieldName.substring(closeBracketPos);
        }
        return cleanFieldName;
    }

    @Override
    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.meta.setChanged();
            }
        };
        this.changed = this.meta.hasChanged();
        this.createUI();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AvroInputDialog.this.cancel();
            }
        });
        int height = Math.max(this.getMinHeight((Composite)this.shell, this.getWidth()), this.getHeight());
        this.shell.setMinimumSize(this.getWidth(), height);
        this.shell.setSize(this.getWidth(), height);
        this.getData();
        this.updateLocation();
        this.updateSchemaLocation();
        this.shell.open();
        this.wStepname.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void updateSchemaLocation() {
        String scheme;
        String schemaPath = this.wSchemaPath.getText();
        String string = scheme = schemaPath.isEmpty() ? SCHEMA_SCHEME_DEFAULT : UriParser.extractScheme((String)schemaPath);
        if (scheme != null) {
            try {
                List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
                for (int i = 0; i < availableVFSSchemes.size(); ++i) {
                    VFSScheme s = availableVFSSchemes.get(i);
                    if (!scheme.equals(s.getScheme())) continue;
                    this.wSchemaLocation.select(i);
                    this.selectedSchemaVFSScheme = s;
                }
            }
            catch (KettleFileException ex) {
                this.log.logError(this.getBaseMsg("AvroInputDialog.FileBrowser.KettleFileException"));
            }
            catch (FileSystemException ex) {
                this.log.logError(this.getBaseMsg("AvroInputDialog.FileBrowser.FileSystemException"));
            }
        }
        if (this.wPreview != null) {
            this.wPreview.setEnabled(!this.wPath.getText().isEmpty());
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString((Class)this.PKG, (String)"AvroInputDialog.Shell.Title", (String[])new String[0]);
    }

    @Override
    protected Listener getPreview() {
        return new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.doPreview();
            }
        };
    }
}

