/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.common;

import java.util.logging.Logger;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.refinery.publish.util.PublishRestUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.publish.JobEntryDatasourcePublish;

public class ConnectionValidator {
    private static final Class<JobEntryDatasourcePublish> PKG = JobEntryDatasourcePublish.class;
    private static final Logger logger = Logger.getLogger(PKG.getName());
    private boolean suppressSuccessMessage;
    private PublishRestUtil publishRestUtil = new PublishRestUtil();
    private BiServerConnection connection;

    public void validateConnectionInRuntime() throws KettleException {
        boolean isAuthenticated;
        if (!this.isPentahoServer()) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Test.InvalidPentahoServerMsgRuntime"));
        }
        if (!this.isUserInfoProvided()) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Test.MissingUserMsg"));
        }
        boolean bl = isAuthenticated = !this.publishRestUtil.isUnauthenticatedUser(this.connection);
        if (!isAuthenticated) {
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Test.UsernamePasswordFailMsg"));
        }
        if (!this.canConnect()) {
            if (this.publishRestUtil.getLastHTTPStatus() == 404) {
                throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Test.BadURLMsg"));
            }
            throw new KettleException(this.getMsg("JobEntryDatasourcePublish.Test.PermissionsErrorMsg"));
        }
    }

    public boolean validateConnectionInDesignTime() {
        boolean isAuthenticated;
        if (!this.isPentahoServer()) {
            this.showError(this.getMsg("JobEntryDatasourcePublish.Test.InvalidPentahoServer"), this.getMsg("JobEntryDatasourcePublish.Test.InvalidPentahoServerMsg"));
            return false;
        }
        if (!this.isUserInfoProvided()) {
            this.showError(this.getMsg("JobEntryDatasourcePublish.Test.MissingUser"), this.getMsg("JobEntryDatasourcePublish.Test.MissingUserMsg"));
            return false;
        }
        boolean bl = isAuthenticated = !this.publishRestUtil.isUnauthenticatedUser(this.connection);
        if (!isAuthenticated) {
            this.showError(this.getMsg("JobEntryDatasourcePublish.Test.UsernamePasswordFail"), this.getMsg("JobEntryDatasourcePublish.Test.UsernamePasswordFailMsg"));
            return false;
        }
        if (this.canConnect()) {
            if (!this.suppressSuccessMessage) {
                this.showInfo(this.getMsg("JobEntryDatasourcePublish.Test.Passed"), this.getMsg("JobEntryDatasourcePublish.Test.PassedMsg"));
            }
            return true;
        }
        if (this.publishRestUtil.getLastHTTPStatus() == 404) {
            this.showError(this.getMsg("JobEntryDatasourcePublish.Test.BadURL"), this.getMsg("JobEntryDatasourcePublish.Test.BadURLMsg"));
        } else {
            this.showError(this.getMsg("JobEntryDatasourcePublish.Test.PermissionsError"), this.getMsg("JobEntryDatasourcePublish.Test.PermissionsErrorMsg"));
        }
        return false;
    }

    public boolean isBiServerConnectionProvided() {
        return this.connection != null;
    }

    public boolean isUserInfoProvided() {
        return this.publishRestUtil.isUserInfoProvided(this.connection);
    }

    public boolean isPentahoServer() {
        try {
            return this.isBiServerConnectionProvided() && this.publishRestUtil.isPentahoServer(this.connection);
        }
        catch (Exception e) {
            logger.warning(e.getLocalizedMessage());
            return false;
        }
    }

    public boolean canConnect() {
        if (!this.isPentahoServer()) {
            return false;
        }
        boolean canPublish = this.publishRestUtil.canPublish(this.connection);
        if (!canPublish) {
            return false;
        }
        boolean canManageDatasources = this.publishRestUtil.canManageDatasources(this.connection);
        return canManageDatasources;
    }

    public void showInfo(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 3);
    }

    public void showError(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 2);
    }

    public void setConnection(BiServerConnection connection) {
        this.connection = connection;
    }

    public void setSuppressSuccessMessage(boolean suppressSuccessMessage) {
        this.suppressSuccessMessage = suppressSuccessMessage;
    }

    public void setPublishRestUtil(PublishRestUtil publishRestUtil) {
        this.publishRestUtil = publishRestUtil;
    }

    protected SpoonInterface getSpoon() {
        return SpoonFactory.getInstance();
    }

    protected String getMsg(String messageKey) {
        return BaseMessages.getString(PKG, (String)messageKey, (String[])new String[0]);
    }
}

